/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.index.external.result.ExternalAnalysisResultMetricSchemaChange;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.index.report.result.metrics.MetricEntryUpdater;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisMetricSchemaChangeProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultMetricSchemaChange> {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metric-schema")
    private MetricSchemaIndex metricSchemaIndex;
    private final List<MetricSchemaChangeEntry> changeEntries = new ArrayList<MetricSchemaChangeEntry>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isCodePath() || uniformPath.isNonCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultMetricSchemaChange> getResultClass() {
        return ExternalAnalysisResultMetricSchemaChange.class;
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultMetricSchemaChange analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        return this.changeEntries.addAll((Collection<MetricSchemaChangeEntry>)analysisResult.getData());
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        MetricEntryUpdater.updateMetricEntries(this.changeEntries, this.metricsIndex, this.metricSchemaIndex, this.basicTokenElementIndex);
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        this.metricsIndex.removeEntries(deletedPartitionAndPaths);
    }

    @Override
    public void reset() {
        this.changeEntries.clear();
    }
}

