/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Index(name="process-step-partition-path-to-metric-id-mapping", options={EStorageOption.BRANCHED}, valueClasses={TreeSet.class})
public class ProcessStepPartitionAndPathToMetricIdMappingIndex
extends IndexBase
implements IProjectIndex {
    public static final String NAME = "process-step-partition-path-to-metric-id-mapping";

    public ProcessStepPartitionAndPathToMetricIdMappingIndex(IStore store) {
        super(store);
    }

    private static byte[] makeKey(@NonNull PartitionAndPath partitionAndPath) {
        return StringUtils.stringToBytes((String)(partitionAndPath.getUniformPath() + "#" + partitionAndPath.getPartition() + "#"));
    }

    public @NonNull SetMap<PartitionAndPath, String> getMetricIdsByPath(List<@NonNull PartitionAndPath> partitionAndPaths) throws StorageException {
        List keys = CollectionUtils.map(partitionAndPaths, ProcessStepPartitionAndPathToMetricIdMappingIndex::makeKey);
        List results = StorageUtils.deserializeValues((List)this.store.get(keys));
        SetMap partitionAndPathToMetricIdsMap = new SetMap();
        for (int i = 0; i < partitionAndPaths.size(); ++i) {
            if (results.get(i) == null) continue;
            partitionAndPathToMetricIdsMap.addAll((Object)partitionAndPaths.get(i), (Collection)results.get(i));
        }
        return partitionAndPathToMetricIdsMap;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addPartitionPathToMetricIdMappings(PairList<@NonNull PartitionAndPath, @NonNull String> metricForPartitionAndPath) throws StorageException {
        SetMap partitionAndPathToMetrics = new SetMap();
        for (Pair entry : metricForPartitionAndPath) {
            partitionAndPathToMetrics.add((Object)((PartitionAndPath)entry.getFirst()), (Object)((String)entry.getSecond()));
        }
        ArrayList partitionAndPathKeysToQuery = new ArrayList(partitionAndPathToMetrics.getKeys());
        @NonNull List keysToQuery = CollectionUtils.map(partitionAndPathKeysToQuery, ProcessStepPartitionAndPathToMetricIdMappingIndex::makeKey);
        List previousValues = StorageUtils.deserializeValues((List)this.store.get(keysToQuery));
        PairList dataToStore = new PairList(partitionAndPathKeysToQuery.size());
        for (int i = 0; i < partitionAndPathKeysToQuery.size(); ++i) {
            TreeSet previousMetricIds = (TreeSet)previousValues.get(i);
            if (previousMetricIds == null) {
                previousMetricIds = new TreeSet();
            }
            previousMetricIds.addAll(partitionAndPathToMetrics.getCollection((Object)((PartitionAndPath)partitionAndPathKeysToQuery.get(i))));
            dataToStore.add((Object)((byte[])keysToQuery.get(i)), (Object)StorageUtils.serialize(previousMetricIds));
        }
        this.store.put(dataToStore);
    }

    public Set<String> hasEntriesForUniformPath(Collection<String> uniformPaths) throws StorageException {
        ArrayList<String> uniformPathList = new ArrayList<String>(uniformPaths);
        List keys = CollectionUtils.map(uniformPathList, path -> path + "#");
        Set<String> foundKeys = Collections.synchronizedSet(new HashSet());
        for (int i = 0; i < keys.size(); ++i) {
            String uniformPath = (String)uniformPathList.get(i);
            this.store.scanKeys((String)keys.get(i), (a, b) -> foundKeys.add(uniformPath));
        }
        return foundKeys;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeAllMetricsFor(Collection<PartitionAndPath> deletedPartitionAndPaths) throws StorageException {
        @NonNull List keysToUpdate = CollectionUtils.map(deletedPartitionAndPaths, ProcessStepPartitionAndPathToMetricIdMappingIndex::makeKey);
        this.store.remove(keysToUpdate);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeDeletedMetrics(SetMap<PartitionAndPath, String> pathToMetricIdsThatShouldBeDeleted) throws StorageException {
        ArrayList mappingsToUpdate = new ArrayList(pathToMetricIdsThatShouldBeDeleted.getKeys());
        @NonNull List keysToUpdate = CollectionUtils.map(mappingsToUpdate, ProcessStepPartitionAndPathToMetricIdMappingIndex::makeKey);
        List previousValues = StorageUtils.deserializeValues((List)this.store.get(keysToUpdate));
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
        PairList entriesToUpdate = new PairList();
        for (int i = 0; i < mappingsToUpdate.size(); ++i) {
            ((TreeSet)previousValues.get(i)).removeAll(pathToMetricIdsThatShouldBeDeleted.getCollection((Object)((PartitionAndPath)mappingsToUpdate.get(i))));
            if (((TreeSet)previousValues.get(i)).isEmpty()) {
                keysToRemove.add((byte[])keysToUpdate.get(i));
                continue;
            }
            entriesToUpdate.add((Object)((byte[])keysToUpdate.get(i)), (Object)StorageUtils.serialize((Serializable)((Serializable)previousValues.get(i))));
        }
        this.store.remove(keysToRemove);
        this.store.put(entriesToUpdate);
    }
}

