/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.issue_reference.CodeToReferenceMappingSynchronizerBase;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryCommitMappingSynchronizerBase;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class RepositoryCommitIssueMappingSynchronizer
extends RepositoryCommitMappingSynchronizerBase {
    public static final String ISSUE_IN_COMMIT_PATTERN_PARAMETER = "issue-in-commit-pattern";
    public static final String ISSUE_IN_BRANCH_PATTERN_PARAMETER = "issue-in-branch-pattern";
    public static final String ISSUE_ID_COMMIT_RENAME_RULE_PARAMETER = "issue-id-commit-rename-rule";
    public static final String ISSUE_ID_BRANCH_RENAME_RULE_PARAMETER = "issue-id-branch-rename-rule";
    public static final String CONNECTOR_ID_PARAMETER = "connector-id";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RepositoryCommitIssueMappingIndex changeByIssueIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CommitDescriptorIndex commitDescriptorIndex;
    @StepParameter(value="connector-id")
    private String connectorId;
    @StepParameter(value="issue-in-commit-pattern", optional=true)
    private String issueInCommitPattern;
    @StepParameter(value="issue-in-branch-pattern", optional=true)
    private String issueInBranchPattern;
    @StepParameter(value="issue-id-commit-rename-rule", optional=true)
    private final PairList<String, String> issueIdCommitRenameRules = new PairList();
    private PairList<Pattern, String> compiledIssueIdCommitRenameRules;
    @StepParameter(value="issue-id-branch-rename-rule", optional=true)
    private final PairList<String, String> issueIdBranchRenameRules = new PairList();
    private PairList<Pattern, String> compiledIssueIdBranchRenameRules;

    @Override
    protected void storeMapping(SetMap<CommitDescriptor, String> newCommitsToIds) throws StorageException {
        SetMap entries = newCommitsToIds.mapValues(issueId -> new TeamscaleIssueId(this.connectorId, issueId));
        RepositoryCommitIssueMappingSynchronizer.storeFirstAndLastCommitForIssues((SetMap<CommitDescriptor, TeamscaleIssueId>)entries, this.changeByIssueIndex, this.commitDescriptorIndex);
        this.changeByIssueIndex.addRelations((SetMap<CommitDescriptor, TeamscaleIssueId>)entries);
    }

    @VisibleForTesting
    static void storeFirstAndLastCommitForIssues(SetMap<CommitDescriptor, TeamscaleIssueId> newCommitsToIds, RepositoryCommitIssueMappingIndex changeByIssueIndex, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        SetMap newIdsToCommits = newCommitsToIds.invert();
        ArrayList<TeamscaleIssueId> allIssueIds = new ArrayList<TeamscaleIssueId>(newCommitsToIds.getValues());
        Map idsAndCommits = PairList.zip(allIssueIds, changeByIssueIndex.getFirstAndLastCommitsForIssues(allIssueIds)).toMap();
        HashMap<TeamscaleIssueId, FirstLastCommit> newValuesToStore = new HashMap<TeamscaleIssueId, FirstLastCommit>();
        HashSet<CommitDescriptor> knownMergesCache = new HashSet<CommitDescriptor>();
        for (Map.Entry idAndCommit : idsAndCommits.entrySet()) {
            Set newCommitsForIssue = (Set)newIdsToCommits.getCollection((Object)((TeamscaleIssueId)idAndCommit.getKey()));
            FirstLastCommit existingFirstLast = (FirstLastCommit)idAndCommit.getValue();
            FirstLastCommit newFirstLastCommit = FirstLastCommit.extractFromList(newCommitsForIssue);
            if (newFirstLastCommit == null) continue;
            if (existingFirstLast == null) {
                newValuesToStore.put((TeamscaleIssueId)idAndCommit.getKey(), newFirstLastCommit);
                continue;
            }
            Optional<FirstLastCommit> firstLastCommitToStore = RepositoryCommitIssueMappingSynchronizer.determineFirstLastCommit(existingFirstLast, newFirstLastCommit, knownMergesCache, commitDescriptorIndex);
            firstLastCommitToStore.ifPresent(firstLastCommit -> newValuesToStore.put((TeamscaleIssueId)idAndCommit.getKey(), (FirstLastCommit)firstLastCommit));
        }
        changeByIssueIndex.storeFirstAndLastCommitForIssues(newValuesToStore);
    }

    private static Optional<FirstLastCommit> determineFirstLastCommit(FirstLastCommit existingFirstLast, FirstLastCommit newFirstLastCommit, Set<CommitDescriptor> knownMergeCommits, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        boolean hasNewLastCommit;
        boolean hasNewFirstCommit = newFirstLastCommit.firstCommit.getTimestamp() < existingFirstLast.firstCommit.getTimestamp();
        boolean bl = hasNewLastCommit = newFirstLastCommit.lastCommit.getTimestamp() >= existingFirstLast.lastCommit.getTimestamp();
        if (!hasNewFirstCommit && !hasNewLastCommit) {
            return Optional.empty();
        }
        CommitDescriptor newFirstCommit = existingFirstLast.firstCommit;
        if (hasNewFirstCommit) {
            newFirstCommit = newFirstLastCommit.firstCommit;
        }
        CommitDescriptor newLastCommit = existingFirstLast.lastCommit;
        if (hasNewLastCommit) {
            newLastCommit = newFirstLastCommit.lastCommit;
            if (knownMergeCommits.contains(newFirstLastCommit.lastCommit) || commitDescriptorIndex.getCommit(newFirstLastCommit.lastCommit).isMergeCommit()) {
                knownMergeCommits.add(newFirstLastCommit.lastCommit);
                newLastCommit = new CommitDescriptor(existingFirstLast.lastCommit.getBranchName(), newLastCommit.getTimestamp());
            }
        }
        return Optional.of(new FirstLastCommit(newFirstCommit, newLastCommit));
    }

    @Override
    protected String transform(String id) {
        if (this.compiledIssueIdCommitRenameRules == null) {
            this.compiledIssueIdCommitRenameRules = this.issueIdCommitRenameRules.mapFirst(Pattern::compile);
        }
        return super.transform(StringUtils.replaceAll((String)id, this.compiledIssueIdCommitRenameRules));
    }

    private String transformInBranchName(String id) {
        if (this.compiledIssueIdBranchRenameRules == null) {
            this.compiledIssueIdBranchRenameRules = this.issueIdBranchRenameRules.mapFirst(Pattern::compile);
        }
        return StringUtils.replaceAll((String)id, this.compiledIssueIdBranchRenameRules);
    }

    @Override
    public SetMap<CommitDescriptor, String> processLogEntries(List<RepositoryLogEntryAggregate> logEntries) throws ConQATException {
        SetMap commitsToIds = new SetMap();
        if (!StringUtils.isEmpty((String)this.issueInCommitPattern)) {
            commitsToIds.addAll(this.mapCommitsToIssueIds(logEntries, Pattern.compile(this.issueInCommitPattern, 2)));
        }
        if (!StringUtils.isEmpty((String)this.issueInBranchPattern)) {
            commitsToIds.addAll(this.mapCommitsToIssueIdsUsingBranchName(logEntries, Pattern.compile(this.issueInBranchPattern)));
        }
        return commitsToIds;
    }

    private SetMap<CommitDescriptor, String> mapCommitsToIssueIdsUsingBranchName(Collection<RepositoryLogEntryAggregate> logEntries, Pattern pattern) throws ConQATException {
        SetMap commitsToIds = new SetMap();
        for (RepositoryLogEntryAggregate entry : logEntries) {
            String branchName = entry.getCommit().getBranchName();
            if (StringUtils.isEmpty((String)branchName)) continue;
            Matcher matcher = pattern.matcher(branchName);
            CodeToReferenceMappingSynchronizerBase.getGroupMatches(matcher).keySet().stream().map(this::transformInBranchName).forEach(issueId -> commitsToIds.add((Object)entry.getCommit(), issueId));
        }
        return commitsToIds;
    }
}

