/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.FileSystemAccessOption;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.filesystem.FileSystemCacheEntry;
import com.teamscale.index.repository.filesystem.FileSystemCacheIndex;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class FileSystemRepositoryConnection
extends RepositoryConnectionBase {
    public static final String CHANGE_SET_MESSAGE = "File system import/update ";
    private final long timestamp;
    private final File baseDirectory;
    private final IBranchingLayer fileSystemCacheBranchingLayer;
    private RepositoryChangeSet changeSet;
    private final boolean hiddenElementConnector;
    private final ServerOptionIndex serverOptionIndex;

    public FileSystemRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, File baseDirectory, long timestamp, IBranchingLayer fileSystemCacheBranchingLayer, boolean hiddenElementConnector, ServerOptionIndex serverOptionIndex) {
        super(connectorBaseParameterStep);
        this.baseDirectory = baseDirectory;
        this.timestamp = timestamp;
        this.fileSystemCacheBranchingLayer = fileSystemCacheBranchingLayer;
        this.hiddenElementConnector = hiddenElementConnector;
        this.serverOptionIndex = serverOptionIndex;
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(IChangeRetrieverCommitTree commitTree) throws RepositoryException {
        Optional latestRevision = commitTree.getLatestContainedRevisionForBranch(this.baseParameters.getDefaultBranchName());
        long usedTimestamp = this.timestamp;
        if (latestRevision.isEmpty() && this.hiddenElementConnector) {
            usedTimestamp = 2L;
        }
        String revision = String.valueOf(usedTimestamp);
        try {
            FileSystemCacheIndex fileSystemCacheIndex = this.openCacheIndex(revision, true);
            this.updateCache(fileSystemCacheIndex);
            if (this.changeSet == null) {
                return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(false).build();
            }
            CommitTreeRevision commitTreeRevision = new CommitTreeRevision(revision, this.getDefaultBranchName());
            List parentRevisions = latestRevision.map(this::createParentRevisionsList).orElse(Collections.emptyList());
            if (parentRevisions.contains(commitTreeRevision)) {
                return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).build();
            }
            fileSystemCacheIndex.setChangeSet(this.changeSet);
            Set<ICommitTreeNode> addedNodes = Set.of(commitTree.addNode(commitTreeRevision, this.timestamp, parentRevisions));
            return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).withAddedNodes(addedNodes).build();
        }
        catch (StorageException e) {
            throw new RepositoryException("Unable to write changeset for revision: " + revision, (Throwable)e);
        }
    }

    private List<CommitTreeRevision> createParentRevisionsList(String revision) {
        return Collections.singletonList(new CommitTreeRevision(revision, this.getDefaultBranchName()));
    }

    private void updateCache(FileSystemCacheIndex fileSystemCacheIndex) throws RepositoryException {
        try {
            List<FileSystemCacheEntry> cacheEntries = fileSystemCacheIndex.getFileSystemCacheEntries(this.baseDirectory.getAbsolutePath());
            HashSet<String> relativeFilePathsFromCache = new HashSet<String>();
            for (FileSystemCacheEntry entry : cacheEntries) {
                relativeFilePathsFromCache.add(entry.getPath());
            }
            this.changeSet = this.createEmptyChangeSet();
            this.cacheNewFiles(relativeFilePathsFromCache, fileSystemCacheIndex);
            this.cacheModifiedOrDeletedFiles(cacheEntries, fileSystemCacheIndex);
        }
        catch (IOException | StorageException e) {
            this.changeSet = null;
            throw new RepositoryException(e);
        }
        if (this.changeSet.isEmpty()) {
            this.changeSet = null;
        }
    }

    private RepositoryChangeSet createEmptyChangeSet() {
        return new RepositoryChangeSet(String.valueOf(this.timestamp), this.getDefaultBranchName(), this.timestamp, "Teamscale", this.getCommitMessage(), this.getCodePatternSupport(), this.timestamp);
    }

    private String getCommitMessage() {
        return "File system import/update <" + DateTimeUtils.getUiFormattedDateString((long)this.timestamp) + " (" + this.timestamp + ")>.";
    }

    private void cacheNewFiles(Set<String> relativeFilePathsFromCache, FileSystemCacheIndex fileSystemCacheIndex) throws IOException, StorageException, RepositoryException {
        FileSystemAccessOption filesystemAccessOption = FileSystemAccessOption.getOption((ServerOptionIndex)this.serverOptionIndex);
        for (File file : this.getIncludedFiles()) {
            String filename = FileSystemRepositoryConnection.getRelativePath(file, this.baseDirectory);
            if (relativeFilePathsFromCache.contains(filename)) continue;
            Path filePath = this.baseDirectory.toPath().resolve(filename);
            filesystemAccessOption.validateRepositoryAccess(filePath);
            byte[] content = Files.readAllBytes(file.toPath());
            this.addChangeToCache(filename, ERepositoryChangeType.ADD, content, FileSystemUtils.getLastModifiedTimestamp((File)file), fileSystemCacheIndex);
        }
    }

    private void cacheModifiedOrDeletedFiles(List<FileSystemCacheEntry> cachedEntries, FileSystemCacheIndex fileSystemCacheIndex) throws StorageException, IOException {
        for (FileSystemCacheEntry entry : cachedEntries) {
            File fileFromFS = new File(this.baseDirectory, entry.getPath());
            if (!fileFromFS.exists()) {
                this.addChangeToCache(entry.getPath(), ERepositoryChangeType.DELETE, null, null, fileSystemCacheIndex);
                continue;
            }
            this.cacheModifiedFile(entry, fileFromFS, fileSystemCacheIndex);
        }
    }

    private void cacheModifiedFile(FileSystemCacheEntry entry, File fileFromFS, FileSystemCacheIndex fileSystemCacheIndex) throws IOException, StorageException {
        byte[] content;
        long lastModifiedTimestamp = FileSystemUtils.getLastModifiedTimestamp((File)fileFromFS);
        if (lastModifiedTimestamp != entry.getLastModified() && !Arrays.equals(content = Files.readAllBytes(fileFromFS.toPath()), entry.getContents())) {
            this.addChangeToCache(entry.getPath(), ERepositoryChangeType.EDIT, content, lastModifiedTimestamp, fileSystemCacheIndex);
        }
    }

    private void addChangeToCache(String relativeFilePath, ERepositoryChangeType changeType, byte[] content, Long lastModified, FileSystemCacheIndex fileSystemCacheIndex) throws StorageException {
        if (changeType == ERepositoryChangeType.DELETE) {
            fileSystemCacheIndex.removeFileSystemCacheEntry(this.baseDirectory.getAbsolutePath(), relativeFilePath);
        } else {
            fileSystemCacheIndex.setFileSystemCacheEntry(this.baseDirectory.getAbsolutePath(), relativeFilePath, new FileSystemCacheEntry(relativeFilePath, content, lastModified));
        }
        this.changeSet.addChange(relativeFilePath, changeType);
    }

    @Override
    public String getLocationDescription() {
        return this.baseDirectory.getAbsolutePath();
    }

    private List<File> getIncludedFiles() {
        return FileSystemUtils.listFilesRecursively((File)this.baseDirectory, file -> file.isFile() && this.isIncluded(FileSystemRepositoryConnection.getRelativePath(file, this.baseDirectory)));
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) {
        List<File> files = this.getIncludedFiles();
        HashSet<String> result = new HashSet<String>();
        for (File file : files) {
            result.add(FileSystemRepositoryConnection.getRelativePath(file, this.baseDirectory));
        }
        return result;
    }

    public static String getRelativePath(File file, File baseDirectory) {
        Path absolutePath = file.toPath();
        Path basePath = baseDirectory.toPath();
        try {
            absolutePath = absolutePath.toRealPath(new LinkOption[0]);
            basePath = basePath.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path relativePath = basePath.relativize(absolutePath);
        return FileSystemUtils.normalizeSeparators((String)relativePath.toString());
    }

    private FileSystemCacheIndex openCacheIndex(String revision, boolean readWrite) throws StorageException {
        HistoryAccessOption historyAccess = readWrite ? HistoryAccessOption.readHeadWriteTimestamp((String)this.getDefaultBranchName(), (long)Long.parseLong(revision)) : HistoryAccessOption.readHead((String)this.getDefaultBranchName());
        return new FileSystemCacheIndex(this.fileSystemCacheBranchingLayer.openStore(historyAccess));
    }

    @Override
    public byte[] getContent(String path, CommitTreeRevision revision) throws RepositoryException {
        try {
            FileSystemCacheEntry entry = this.openCacheIndex(revision.getRevision(), false).getFileSystemCacheEntry(this.baseDirectory.getAbsolutePath(), path);
            CCSMAssert.isNotNull((Object)entry, (String)("File " + path + " not found at revision " + String.valueOf(revision) + "."));
            return entry.getContents();
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        try {
            return this.openCacheIndex(revision.getRevision(), false).getChangeSet();
        }
        catch (StorageException e) {
            throw new RepositoryException("Unable to load changest for revision: " + String.valueOf(revision), (Throwable)e);
        }
    }

    @Override
    public boolean supportsSkipping() {
        return false;
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        return new Pair((Object)"Teamscale", (Object)this.getCommitMessage());
    }

    @Override
    public String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        return null;
    }
}

