/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem.multiversion;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.FileSystemAccessOption;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemCommit;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemRepositoryConnectorDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.AntPatternDirectoryScanner;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.Nullable;

public class MultiVersionFileSystemRepositoryConnection
extends RepositoryConnectionBase {
    private final ListMap<String, MultiVersionFileSystemCommit> commits = new ListMap();
    private final String normalizedBaseDirectoryPath;
    private final ServerOptionIndex serverOptionIndex;
    private static final String COMMIT_MESSAGE_FILE_NAME = "commitMessage.txt";
    private static final Logger LOGGER = LogManager.getLogger();

    public MultiVersionFileSystemRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, File baseDirectory, ServerOptionIndex serverOptionIndex) throws RepositoryException {
        super(connectorBaseParameterStep);
        this.serverOptionIndex = serverOptionIndex;
        try {
            this.normalizedBaseDirectoryPath = FileSystemUtils.normalizeSeparators((String)baseDirectory.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to normalize base path: " + e.getMessage(), (Throwable)e);
        }
        for (String directoryName : MultiVersionFileSystemRepositoryConnectorDescriptor.getRevisionDirectoryNames(baseDirectory)) {
            if (FileSystemUtils.isSystemFileName((String)directoryName)) continue;
            String commitMessage = MultiVersionFileSystemRepositoryConnection.readCommitMessage(baseDirectory, directoryName);
            MultiVersionFileSystemCommit commit = new MultiVersionFileSystemCommit(directoryName, connectorBaseParameterStep.getDefaultBranchName(), commitMessage);
            this.commits.add((Object)commit.getBranchName(), (Object)commit);
        }
        this.commits.getKeys().stream().map(arg_0 -> this.commits.getCollection(arg_0)).filter(Objects::nonNull).forEach(Collections::sort);
    }

    private static String readCommitMessage(File baseDirectory, String directoryName) {
        Path commitMessagePath = baseDirectory.toPath().resolve(directoryName).resolve(COMMIT_MESSAGE_FILE_NAME);
        if (Files.exists(commitMessagePath, new LinkOption[0])) {
            try {
                return Files.readString(commitMessagePath);
            }
            catch (IOException e) {
                LOGGER.error("Unable to read commit message in directory {}. Skipping custom commit message.", (Object)directoryName, (Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getLocationDescription() {
        return this.normalizedBaseDirectoryPath;
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(IChangeRetrieverCommitTree commitTree) throws RepositoryException {
        List allNodes = commitTree.getAllNodes();
        HashSet<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();
        HashSet knownRevisions = new HashSet(CollectionUtils.map((Collection)allNodes, node -> node.getRevision().getRevision()));
        for (MultiVersionFileSystemCommit commit : CollectionUtils.sort((Collection)this.commits.getValues(), Comparator.comparingLong(MultiVersionFileSystemCommit::getTimestamp))) {
            String revision;
            if (!this.isBranchNameIncludedOrDefaultBranch(commit.getBranchName()) || knownRevisions.contains(revision = commit.getRevision())) continue;
            addedNodes.add(commitTree.addNode(new CommitTreeRevision(revision, commit.getBranchName()), commit.getTimestamp(), this.getParentRevisions(commit)));
        }
        return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).withAddedNodes(addedNodes).build();
    }

    private List<CommitTreeRevision> getParentRevisions(MultiVersionFileSystemCommit commit) throws RepositoryException {
        ArrayList<CommitTreeRevision> parentRevisions = new ArrayList<CommitTreeRevision>();
        PairList<String, Long> additionalCommits = commit.getAdditionalParentCommits();
        if (additionalCommits.isEmpty()) {
            MultiVersionFileSystemCommit parentCommit = this.getPredecessorCommit(commit);
            if (parentCommit != null) {
                parentRevisions.add(new CommitTreeRevision(parentCommit.getRevision(), parentCommit.getBranchName()));
            }
        } else {
            for (int i = 0; i < additionalCommits.size(); ++i) {
                String branchName = (String)additionalCommits.getFirst(i);
                if (!this.isBranchNameIncludedOrDefaultBranch(branchName)) continue;
                String parentRevision = branchName + ":" + String.valueOf(additionalCommits.getSecond(i));
                parentRevisions.add(new CommitTreeRevision(parentRevision, branchName));
            }
        }
        return parentRevisions;
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        MultiVersionFileSystemCommit commit = this.getStoredCommit(revision.getRevision());
        String revisionPath = FileSystemUtils.concatenatePaths((String)this.normalizedBaseDirectoryPath, (String[])new String[]{commit.getDirectoryName()});
        return this.createChangeset(commit, revisionPath);
    }

    @Override
    public boolean supportsSkipping() {
        return false;
    }

    private MultiVersionFileSystemCommit getStoredCommit(String revision) throws RepositoryException {
        MultiVersionFileSystemCommit commit = new MultiVersionFileSystemCommit(revision, this.getDefaultBranchName());
        List branchCommits = Objects.requireNonNull((List)this.commits.getCollection((Object)commit.getBranchName()), "No branch commits found for revision '%s'.".formatted(revision));
        int index = branchCommits.indexOf(commit);
        if (index < 0) {
            throw new RepositoryException("Could not resolve directory for revision " + revision);
        }
        return (MultiVersionFileSystemCommit)branchCommits.get(index);
    }

    private RepositoryChangeSet createChangeset(MultiVersionFileSystemCommit revision, String revisionPath) throws RepositoryException {
        RepositoryChangeSet repositoryChangeset = new RepositoryChangeSet(revision.getRevision(), revision.toCommitDescriptor(), "Teamscale", "File system import/update " + revision.getCommitMessage(), this.getCodePatternSupport(), 0L);
        List<String> filesToInclude = this.getFilesToInclude(revisionPath);
        this.appendChangesSinceLastRevision(revision, filesToInclude, repositoryChangeset);
        return repositoryChangeset;
    }

    private List<String> getFilesToInclude(String revisionPath) throws RepositoryException {
        String[] includePatterns = (String[])CollectionUtils.toArray((Collection)this.getCodePatternSupport().getIncludePatterns(), String.class);
        String[] excludePatterns = (String[])CollectionUtils.toArray((Collection)this.getCodePatternSupport().getExcludePatterns(), String.class);
        try {
            Path revisionDirectory = Paths.get(revisionPath, new String[0]);
            String[] files = AntPatternDirectoryScanner.scan((String)revisionPath, (boolean)true, (String[])includePatterns, (String[])excludePatterns);
            FileSystemAccessOption filesystemAccessOption = FileSystemAccessOption.getOption((ServerOptionIndex)this.serverOptionIndex);
            for (String filename : files) {
                Path filePath = revisionDirectory.resolve(filename);
                filesystemAccessOption.validateRepositoryAccess(filePath);
            }
            return CollectionUtils.map(Arrays.asList(files), FileSystemUtils::normalizeSeparators);
        }
        catch (IOException | StorageException e) {
            throw new RepositoryException("Failure in directory scan: " + e.getMessage(), e);
        }
    }

    private void appendChangesSinceLastRevision(MultiVersionFileSystemCommit revision, List<String> filesToInclude, RepositoryChangeSet repositoryChangeset) throws RepositoryException {
        MultiVersionFileSystemCommit previousRevision = Objects.requireNonNull(this.getPredecessorCommit(revision), "No previous commit found for revision '%s'.".formatted(revision.getRevision()));
        List<String> previousRevisionFilesToInclude = this.getFilesToInclude(FileSystemUtils.concatenatePaths((String)this.normalizedBaseDirectoryPath, (String[])new String[]{previousRevision.getDirectoryName()}));
        this.addChangeTypes(repositoryChangeset, filesToInclude, revision, previousRevisionFilesToInclude, previousRevision);
    }

    private @Nullable MultiVersionFileSystemCommit getPredecessorCommit(MultiVersionFileSystemCommit revision) throws RepositoryException {
        List branchCommits = Objects.requireNonNull((List)this.commits.getCollection((Object)revision.getBranchName()), "No branch commits found for revision '%s'.".formatted(revision));
        int index = branchCommits.indexOf(revision);
        if (index > 0) {
            return (MultiVersionFileSystemCommit)branchCommits.get(index - 1);
        }
        if (!revision.getAdditionalParentCommits().isEmpty()) {
            return this.getStoredCommit((String)revision.getAdditionalParentCommits().getFirst(0) + ":" + String.valueOf(revision.getAdditionalParentCommits().getSecond(0)));
        }
        return null;
    }

    private void addChangeTypes(RepositoryChangeSet repositoryChangeset, List<String> filesToInclude, MultiVersionFileSystemCommit revision, List<String> previousRevisionFilesToInclude, MultiVersionFileSystemCommit previousRevision) throws RepositoryException {
        for (String addedFile : CollectionUtils.differenceSet(filesToInclude, (Collection[])new Collection[]{previousRevisionFilesToInclude})) {
            repositoryChangeset.addChange(addedFile, ERepositoryChangeType.ADD);
        }
        for (String deletedFile : CollectionUtils.differenceSet(previousRevisionFilesToInclude, (Collection[])new Collection[]{filesToInclude})) {
            repositoryChangeset.addChange(deletedFile, ERepositoryChangeType.DELETE);
        }
        for (String commonFile : CollectionUtils.intersectionSet(filesToInclude, (Collection[])new Collection[]{previousRevisionFilesToInclude})) {
            if (!this.hasChanged(commonFile, revision, previousRevision)) continue;
            repositoryChangeset.addChange(commonFile, ERepositoryChangeType.EDIT);
        }
    }

    private boolean hasChanged(String potentiallyEditedFile, MultiVersionFileSystemCommit revision, MultiVersionFileSystemCommit previousRevision) throws RepositoryException {
        File file = new File(FileSystemUtils.concatenatePaths((String)this.normalizedBaseDirectoryPath, (String[])new String[]{revision.getDirectoryName(), potentiallyEditedFile}));
        File previousRevisionFile = new File(FileSystemUtils.concatenatePaths((String)this.normalizedBaseDirectoryPath, (String[])new String[]{previousRevision.getDirectoryName(), potentiallyEditedFile}));
        return !Arrays.equals(MultiVersionFileSystemRepositoryConnection.getFileContents(file), MultiVersionFileSystemRepositoryConnection.getFileContents(previousRevisionFile));
    }

    private static byte[] getFileContents(File file) throws RepositoryException {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new RepositoryException("The file " + file.getAbsolutePath() + "could not be read from the filesystem.", (Throwable)e);
        }
    }

    @Override
    public byte[] getContent(String path, CommitTreeRevision revision) throws RepositoryException {
        return MultiVersionFileSystemRepositoryConnection.getFileContents(new File(FileSystemUtils.concatenatePaths((String)this.normalizedBaseDirectoryPath, (String[])new String[]{this.getStoredCommit(revision.getRevision()).getDirectoryName(), path})));
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) throws RepositoryException {
        return new HashSet<String>(this.getFilesToInclude(FileSystemUtils.concatenatePaths((String)this.normalizedBaseDirectoryPath, (String[])new String[]{this.getStoredCommit(revision.getRevision()).getDirectoryName()})));
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        MultiVersionFileSystemCommit commit = this.getStoredCommit(revision.getRevision());
        return new Pair((Object)"Teamscale", (Object)("File system import/update " + commit.getCommitMessage()));
    }

    @Override
    public String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        return null;
    }
}

