/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public class GitBranchRefInfo {
    private final Ref headRef;
    private final List<Ref> branchHeadRefs;

    private GitBranchRefInfo(Ref headRef, List<Ref> branchHeadRefs) {
        this.branchHeadRefs = CollectionUtils.asUnmodifiable(branchHeadRefs);
        this.headRef = headRef;
    }

    public boolean containsRefForBranchName(String branchName) {
        if (branchName == null) {
            return false;
        }
        String branchHeadRefName = GitRefUtils.createBranchHeadRefName((String)branchName);
        return this.branchHeadRefs.stream().map(Ref::getName).anyMatch(branchHeadRefName::equals);
    }

    public List<String> getBranchNamesMatchingHeadRef() {
        if (this.headRef == null) {
            return Collections.emptyList();
        }
        ObjectId headRevision = this.headRef.getObjectId();
        if (headRevision == null) {
            return Collections.emptyList();
        }
        ArrayList<String> branchNames = new ArrayList<String>(this.branchHeadRefs.size());
        for (Ref branchHeadRef : this.branchHeadRefs) {
            CCSMAssert.isFalse((boolean)this.headRef.equals((Object)branchHeadRef), (String)"Head ref should not be part of the branch head refs.");
            if (!headRevision.equals((AnyObjectId)branchHeadRef.getObjectId())) continue;
            GitRefUtils.getBranchNameFromRef((String)branchHeadRef.getName()).ifPresent(branchNames::add);
        }
        return branchNames;
    }

    public static GitBranchRefInfo create(Collection<Ref> refs) {
        Ref headRef = null;
        ArrayList<Ref> branchHeadRefs = new ArrayList<Ref>();
        for (Ref ref : refs) {
            if (GitRefUtils.isHeadRef((String)ref.getName())) {
                headRef = ref;
                continue;
            }
            if (!GitRefUtils.isBranchHead((String)ref.getName())) continue;
            branchHeadRefs.add(ref);
        }
        return new GitBranchRefInfo(headRef, branchHeadRefs);
    }
}

