/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.cross_repo_merge_requests;

import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.LockableIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={CrossRepositoryMergeRequestSourceBranch.class})
public class CrossRepositoryMergeRequestSourceBranchesIndex
extends LockableIndex<LockedIndexAccess>
implements IProjectIndexWithDynamicName {
    public static final String BASE_NAME = "cross-repo-merge-request-source-branches";
    private static final String ACTIVE_BRANCHES_KEY_PREFIX = "active";
    private final ValueIndex<CrossRepositoryMergeRequestSourceBranch> branchesDelegateIndex;
    private String indexName;

    public CrossRepositoryMergeRequestSourceBranchesIndex(IStore store) {
        super(store);
        this.branchesDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, ACTIVE_BRANCHES_KEY_PREFIX));
    }

    public static String createIndexName(String connectorIdentifier) {
        return connectorIdentifier + "-cross-repo-merge-request-source-branches";
    }

    protected LockedIndexAccess getIndexAccess(IStore store) {
        return new LockedIndexAccess();
    }

    public void setName(String indexName) {
        this.indexName = indexName;
    }

    public String getName() {
        return this.indexName;
    }

    public class LockedIndexAccess {
        private LockedIndexAccess() {
        }

        public UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> readAllBranches() throws StorageException {
            return CrossRepositoryMergeRequestSourceBranchesIndex.this.branchesDelegateIndex.getAllEntries().getSecondList();
        }

        public boolean updateBranch(CrossRepositoryMergeRequestSourceBranch branch) throws StorageException {
            String key = LockedIndexAccess.getKey(branch);
            if (branch.equals(CrossRepositoryMergeRequestSourceBranchesIndex.this.branchesDelegateIndex.getValue(key))) {
                return false;
            }
            CrossRepositoryMergeRequestSourceBranchesIndex.this.branchesDelegateIndex.setValue(key, (Object)branch);
            return true;
        }

        public void removeBranch(CrossRepositoryMergeRequestSourceBranch branch) throws StorageException {
            String key = LockedIndexAccess.getKey(branch);
            CrossRepositoryMergeRequestSourceBranchesIndex.this.branchesDelegateIndex.removeValue(key);
        }

        public void removeBranch(List<CrossRepositoryMergeRequestSourceBranch> branches) throws StorageException {
            List<String> keys = branches.stream().map(LockedIndexAccess::getKey).toList();
            CrossRepositoryMergeRequestSourceBranchesIndex.this.branchesDelegateIndex.removeValues(keys);
        }

        private static String getKey(CrossRepositoryMergeRequestSourceBranch branch) {
            return branch.localBranchName();
        }
    }
}

