/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.RepositoryContentUpdaterBase;
import com.teamscale.index.repository.sap.abapsystem.AbapRepositoryConnector;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public class AbapContentUpdater
extends RepositoryContentUpdaterBase {
    static final String MODIFICATIONS_SYSTEM_IDS_REGEX_PARAMETER_NAME = "abap-modifications-system-id";
    @StepParameter(value="abap-modifications-system-id", optional=true)
    protected String modificationsSystemIdsRegex = "";
    private Pattern modificationsSystemIdsPattern = null;
    private static final Pattern OPEN_MODIFICATION_BLOCK_PATTERN = Pattern.compile("\\*\\{\\s+(INSERT|REPLACE|DELETE)\\s+(?<modId>[A-Z0-9]{10})\\s+\\d+\\s*");
    private static final String MODIFICATION_ID_GROUP_NAME = "modId";
    private static final Pattern CLOSE_MODIFICATION_BLOCK_PATTERN = Pattern.compile("\\*}\\s+(INSERT|REPLACE|DELETE)\\s*");
    @StepParameterObject
    private final AbapRepositoryConnector connector = new AbapRepositoryConnector();

    @Override
    protected IRepositoryConnection createRepositoryConnection() throws RepositoryException {
        return this.connector.createConnection(this.getProfilingMonitor(), (ICancelable)this, this.getParallelTaskExecutor());
    }

    @Override
    protected String getConnectionIdentifier() {
        return this.connector.getBaseParameters().getConnectionIdentifier();
    }

    @Override
    protected void storeConnectorDownStatus(String error) throws StorageException {
    }

    @Override
    protected List<Deletion> determineAdditionalDeletions(UniformPath uniformPath, ELanguage language, String textContent) {
        return this.determineDeletionsInModificationsFile(uniformPath, textContent);
    }

    private @NonNull List<Deletion> determineDeletionsInModificationsFile(UniformPath uniformPath, String textContent) {
        if (!uniformPath.getPathSegments().contains((Object)"_MODIFICATIONS")) {
            return Collections.emptyList();
        }
        if (!uniformPath.getLastSegment().endsWith(".abap")) {
            return Collections.emptyList();
        }
        ArrayList<Deletion> deletions = new ArrayList<Deletion>();
        int previousModificationEnd = 0;
        int currentOffset = 0;
        boolean inAcceptedModification = false;
        for (String line : StringUtils.splitLines((String)textContent)) {
            if (this.isAcceptedModificationHeader(line)) {
                inAcceptedModification = true;
                deletions.add(new Deletion(previousModificationEnd, currentOffset, true));
            } else if (inAcceptedModification && AbapContentUpdater.isModificationFooter(line)) {
                previousModificationEnd = currentOffset + line.length() + 1;
                inAcceptedModification = false;
            }
            currentOffset += line.length() + 1;
        }
        if (deletions.isEmpty()) {
            return List.of(new Deletion(0, textContent.length(), true));
        }
        if (previousModificationEnd < textContent.length()) {
            deletions.add(new Deletion(previousModificationEnd, textContent.length(), true));
        }
        return deletions;
    }

    private Pattern lazyLoadModificationsSystemIdPattern() {
        if (this.modificationsSystemIdsPattern != null) {
            return this.modificationsSystemIdsPattern;
        }
        if (StringUtils.isEmpty((String)this.modificationsSystemIdsRegex)) {
            return null;
        }
        this.modificationsSystemIdsPattern = Pattern.compile(this.modificationsSystemIdsRegex);
        return this.modificationsSystemIdsPattern;
    }

    private boolean isAcceptedModificationHeader(String line) {
        if (!line.startsWith("*{")) {
            return false;
        }
        Matcher matcher = OPEN_MODIFICATION_BLOCK_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return false;
        }
        Pattern systemIdPattern = this.lazyLoadModificationsSystemIdPattern();
        if (systemIdPattern == null) {
            return true;
        }
        String modificationId = matcher.group(MODIFICATION_ID_GROUP_NAME);
        if (modificationId.length() < 4) {
            return false;
        }
        return systemIdPattern.matcher(modificationId.substring(0, 3)).matches();
    }

    private static boolean isModificationFooter(String line) {
        return line.startsWith("*}") && CLOSE_MODIFICATION_BLOCK_PATTERN.matcher(line).matches();
    }
}

