/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request;

import com.teamscale.core.user.User;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class SpecItemMappingToIdsEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, List<TeamscaleIssueId>> componentToSpecItemIds = new HashMap<String, List<TeamscaleIssueId>>();
    private final SpecItemHistoryIndex specItemHistoryIndex;
    private final GlobalStorageSystem globalStorageSystem;
    private final ProjectStorageSystem projectStorageSystem;
    private final User currentUser;
    private final String branch;

    public SpecItemMappingToIdsEvaluator(SpecItemHistoryIndex specItemHistoryIndex, GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, User currentUser, String branch) {
        this.specItemHistoryIndex = specItemHistoryIndex;
        this.globalStorageSystem = globalStorageSystem;
        this.projectStorageSystem = projectStorageSystem;
        this.currentUser = currentUser;
        this.branch = branch;
    }

    public void evaluate(ArchitectureDefinition architectureDefinition) throws StorageException {
        for (ComponentNode component : architectureDefinition.getAllComponents()) {
            if (StringUtils.isEmpty((String)component.getSpecItemMapping())) continue;
            List<TeamscaleIssueId> specItemIds = this.evaluateMapping(component.getName(), component.getSpecItemMapping());
            this.componentToSpecItemIds.put(component.getName(), specItemIds);
        }
    }

    public List<TeamscaleIssueId> evaluateMapping(String componentName, String specItemMapping) throws StorageException {
        try {
            QueryableEntityUtils.QueryContext queryContext = QueryableEntityUtils.QueryContext.ofTimestamp(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, System.currentTimeMillis(), this.branch);
            return QueryableEntityUtils.runIssueQuery(this.specItemHistoryIndex, specItemMapping, queryContext);
        }
        catch (QueryCompilationException | QueryParsingException e) {
            LOGGER.error("Evaluating spec item mapping query " + specItemMapping + " for component " + componentName + " failed badly.", e);
            return Collections.emptyList();
        }
    }

    public Map<String, List<TeamscaleIssueId>> getComponentToSpecItemIds() {
        return this.componentToSpecItemIds;
    }
}

