/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.search;

import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.SearchSource;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SearchToken {
    private static final int MIN_SIGNIFICANCE = 0;
    private static final int MAX_SIGNIFICANCE = 100;
    public static final byte SIGNIFICANCE_LOW = 1;
    public static final byte SIGNIFICANCE_NORMAL = 5;
    public static final byte SIGNIFICANCE_HIGH = 10;
    private final String text;
    private final ESearchTokenSourceType sourceType;
    private final String sourceName;
    private final int offset;
    private final byte significance;

    public SearchToken(String text, ESearchTokenSourceType sourceType, String sourceName, int offset, byte significance) {
        this.text = text;
        this.sourceType = sourceType;
        this.sourceName = sourceName;
        this.offset = offset;
        CCSMAssert.isTrue((0 <= significance && significance <= 100 ? 1 : 0) != 0, (String)"Significance out of bounds!");
        this.significance = significance;
    }

    public String getText() {
        return this.text;
    }

    public ESearchTokenSourceType getSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public SearchSource getSearchSource() {
        return new SearchSource(this.sourceType, this.sourceName);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSignificance() {
        return this.significance;
    }
}

