/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.naming_convention;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.simulink.analysis.SimulinkAnalysisRunner;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.naming_convention.SimulinkNamingConventionAnalysis;
import eu.cqse.check.framework.core.CheckException;
import java.util.Base64;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

public class SimulinkNamingConventionAnalysisRunner
extends SimulinkAnalysisRunner {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SERIALIZED_PARAMETER_MAP_PARAMETER = "serialized-parameter-map";
    @StepParameter(value="serialized-parameter-map")
    private String serializedParameterMap;
    private static final String FINDINGS_PARTITION = "simulink-naming-convention-checks";

    @Override
    protected String getFindingsPartition() {
        return FINDINGS_PARTITION;
    }

    @Override
    protected SimulinkFindingAnalysisBase configureSimulinkFindingAnalysis(SimulinkFindingAnalysisBase analysisInstance) throws ConQATException {
        if (analysisInstance instanceof SimulinkNamingConventionAnalysis) {
            SimulinkNamingConventionAnalysis namingConventionsAnalysis = (SimulinkNamingConventionAnalysis)analysisInstance;
            try {
                HashMap<String, String> parameterMap = this.unwrapParameters();
                namingConventionsAnalysis.initialize(parameterMap);
            }
            catch (CheckException | ConQATException e) {
                LOGGER.error("Failure while initializing Simulink naming patterns", e);
            }
            return namingConventionsAnalysis;
        }
        return super.configureSimulinkFindingAnalysis(analysisInstance);
    }

    private HashMap<String, String> unwrapParameters() throws ConQATException {
        try {
            return (HashMap)StorageUtils.deserialize((byte[])Base64.getDecoder().decode(this.serializedParameterMap));
        }
        catch (StorageException e) {
            throw new ConQATException("Exception while decoding and deserializing parameter.", (Throwable)e);
        }
    }
}

