/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.teamscale.index.dependencies.simulink.DataDictionaryLoader;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.simulink.utils.SimulinkPhaseUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;

public final class DataDictionaryLoaderUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void addReferencesToLoader(DataDictionaryLoader dataDictionaryLoader, Collection<SimulinkModel> models, Function<String, List<SimulinkFileReference>> fileReferenceAccessor) {
        Set<SimulinkDataDictionary> simulinkDataDictionaries = DataDictionaryLoaderUtils.loadDataDictionaries(models, dataDictionaryLoader);
        ListMap simulinkFileReferencedMap = new ListMap();
        simulinkFileReferencedMap.addAll(DataDictionaryLoaderUtils.createFileReferencedMapFromDictionaries(simulinkDataDictionaries));
        simulinkFileReferencedMap.addAll(DataDictionaryLoaderUtils.createFileReferencedMapFromAccessor(models, fileReferenceAccessor));
        ListMap<String, SimulinkModelBlockIdListingPhase.BlockIdDefinition> blockIdMap = DataDictionaryLoaderUtils.createBlockIdMap(models);
        ListMap<String, SimulinkDataDictionaryLoadingPhase.DataDictionaryContainer> dictionaryContainerMap = DataDictionaryLoaderUtils.createDataDictionaryMap(simulinkDataDictionaries);
        SimulinkCheckFileReferencesResolver fileReferencesResolver = new SimulinkCheckFileReferencesResolver(DataDictionaryLoaderUtils.asFunction(simulinkFileReferencedMap), DataDictionaryLoaderUtils.asFunction(DataDictionaryLoaderUtils.invert(simulinkFileReferencedMap)), DataDictionaryLoaderUtils.asFunction(blockIdMap), DataDictionaryLoaderUtils.asFunction(DataDictionaryLoaderUtils.invert(blockIdMap)));
        for (SimulinkModel model : models) {
            List dataDictionariesForModel = fileReferencesResolver.getSimulinkDataDictionariesForModel(model, DataDictionaryLoaderUtils.asFunction(dictionaryContainerMap));
            dataDictionaryLoader.addReferences(model, new HashSet<SimulinkDataDictionary>(dataDictionariesForModel));
        }
    }

    private static <E> Function<String, List<E>> asFunction(ListMap<String, E> map) {
        return string -> (List)map.getCollectionOrElse(string, Collections.emptyList());
    }

    private static <E extends IExtractedValue<String>> ListMap<String, E> invert(ListMap<String, E> originalMap) {
        ListMap result = new ListMap();
        for (IExtractedValue value : (List)originalMap.getValues()) {
            result.add((Object)value.getValue(), (Object)value);
        }
        return result;
    }

    private static Set<SimulinkDataDictionary> loadDataDictionaries(Collection<SimulinkModel> models, DataDictionaryLoader dataDictionaryLoader) {
        return models.stream().flatMap(model -> {
            try {
                return dataDictionaryLoader.getReferencedDataDictionaries((SimulinkModel)model).stream();
            }
            catch (StorageException e) {
                LOGGER.error((Object)e);
                return Stream.empty();
            }
        }).collect(Collectors.toSet());
    }

    private static ListMap<String, SimulinkDataDictionaryLoadingPhase.DataDictionaryContainer> createDataDictionaryMap(Collection<SimulinkDataDictionary> dictionaries) {
        ListMap result = new ListMap();
        for (SimulinkDataDictionary dictionary : dictionaries) {
            result.addAll((Object)dictionary.getUniformPath(), Collections.singletonList(new SimulinkDataDictionaryLoadingPhase.DataDictionaryContainer(dictionary.getUniformPath(), dictionary)));
        }
        return result;
    }

    private static ListMap<String, SimulinkFileReference> createFileReferencedMapFromDictionaries(Collection<SimulinkDataDictionary> simulinkDataDictionaries) {
        ListMap result = new ListMap();
        for (SimulinkDataDictionary dictionary : simulinkDataDictionaries) {
            result.addAll((Object)dictionary.getUniformPath(), (Collection)SimulinkPhaseUtils.extractReferencesForDataDictionary((SimulinkDataDictionary)dictionary));
        }
        return result;
    }

    private static ListMap<String, SimulinkFileReference> createFileReferencedMapFromAccessor(Collection<SimulinkModel> models, Function<String, List<SimulinkFileReference>> fileReferenceAccessor) {
        ListMap result = new ListMap();
        for (SimulinkModel model : models) {
            List<SimulinkFileReference> fileReferences = fileReferenceAccessor.apply(model.getUniformPath());
            result.addAll((Object)model.getUniformPath(), fileReferences);
        }
        return result;
    }

    private static ListMap<String, SimulinkModelBlockIdListingPhase.BlockIdDefinition> createBlockIdMap(Collection<SimulinkModel> models) {
        ListMap result = new ListMap();
        for (SimulinkModel model : models) {
            result.addAll((Object)model.getUniformPath(), (Collection)SimulinkPhaseUtils.getBlockIdDefinitions((SimulinkModel)model));
        }
        return result;
    }

    private DataDictionaryLoaderUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

