/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.simulink.DataDictionaryLoader;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.SimulinkSignalLabelIndex;
import com.teamscale.index.simulink.LibraryBlockIdentifier;
import com.teamscale.index.simulink.content.SimulinkFileSynchronizer;
import com.teamscale.index.simulink.signal_type.DataDictionaryLoaderUtils;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeResolver;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkOutputDataTypeIndex;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityIndex;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityResolver;
import com.teamscale.index.simulink.signal_type.signal_labels.SimulinkSignalLabelResolver;
import com.teamscale.index.simulink.subsystems.SimulinkFileReferenceIndex;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;
import org.conqat.lib.simulink.model.SimulinkResolvedInformation;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.NonNull;

public class SimulinkOutputDataTypeExtractionStep
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="binary-content")
    private BinaryElementIndex binaryContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="simulink-model-info")
    private SimulinkModelInfoIndex simulinkModelInfoIndex;
    @DeltaSource(value=BinaryElementIndex.class, indexName="binary-content")
    private KeyDelta binaryContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="simulink-output-data-type")
    private SimulinkOutputDataTypeIndex outputDataTypeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="simulink-dimensionality")
    private SimulinkDimensionalityIndex dimensionsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="simulink-data-dict")
    private SimulinkDataDictionaryIndex dataDictionaryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="simulink-signal-labels")
    private SimulinkSignalLabelIndex signalLabelIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="simulink-file-reference")
    private SimulinkFileReferenceIndex fileReferenceIndex;

    public void execute() throws Exception {
        List<String> uniformPaths = SimulinkFileSynchronizer.filterSimulinkModels(this.binaryContentIndex.getAllElements());
        LazyModelLoader modelLoader = new LazyModelLoader(this.binaryContentIndex);
        SimulinkLibraryLoader libraryLoader = new SimulinkLibraryLoader(modelLoader, this.simulinkModelInfoIndex);
        modelLoader.preloadModels(uniformPaths);
        DataDictionaryLoader dataDictionaryLoader = new DataDictionaryLoader(this.binaryContentIndex, this.dataDictionaryIndex);
        Pair<List<SimulinkModel>, Set<SimulinkModel>> sortedModels = SimulinkOutputDataTypeExtractionStep.getTopSortedModels(uniformPaths, modelLoader, libraryLoader);
        List<SimulinkModel> sortedCycle = ((Set)sortedModels.getSecond()).stream().sorted(Comparator.comparing(SimulinkModel::getUniformPath)).toList();
        ArrayList models = CollectionUtils.unionList((Collection)((Collection)sortedModels.getFirst()), (Collection[])new Collection[]{sortedCycle});
        DataDictionaryLoaderUtils.addReferencesToLoader(dataDictionaryLoader, models, this.getFileReferencesAccessor());
        List<String> invalidatedPaths = this.getInvalidatedModelPaths(this.binaryContentDelta.getAllKeysAsStrings(), dataDictionaryLoader);
        this.outputDataTypeIndex.removeResolvedDataTypes(invalidatedPaths);
        this.dimensionsIndex.removeSignalDimensions(invalidatedPaths);
        this.signalLabelIndex.removeSignalLabels(invalidatedPaths);
        SimulinkSignalPropagationContext context = new SimulinkSignalPropagationContext();
        context.loadDataFromPreviousCommits(this.outputDataTypeIndex, this.dimensionsIndex, this.signalLabelIndex, modelLoader);
        HashMap<String, SimulinkDataTypeResolver> resolversMap = new HashMap<String, SimulinkDataTypeResolver>();
        for (SimulinkModel model : models) {
            this.resolveDataTypes(model, libraryLoader, dataDictionaryLoader, context.resolvedDataTypes, resolversMap);
            this.resolveDimensions(model, modelLoader, libraryLoader, context.resolvedDimensions);
            this.resolveSignalLabels(model, modelLoader, libraryLoader, context.resolvedLabels);
        }
        this.outputDataTypeIndex.setResolvedDataTypes(context.getChangedResolvedDataTypes());
        this.dimensionsIndex.setSignalDimensions(context.getChangedResolvedDimensions());
        this.signalLabelIndex.setSignalLabels(context.getChangedResolvedLabels());
    }

    private List<String> getInvalidatedModelPaths(List<String> changedOrRemovedPaths, DataDictionaryLoader dataDictionaryLoader) throws StorageException {
        ArrayList<String> invalidatedPaths = new ArrayList<String>(changedOrRemovedPaths);
        for (String changedOrRemovedPath : changedOrRemovedPaths) {
            SimulinkDataDictionary dictionary;
            if (!SimulinkUtils.isSimulinkDataDictionary((String)changedOrRemovedPath) || (dictionary = (SimulinkDataDictionary)dataDictionaryLoader.getDictionaryByUniformPath(changedOrRemovedPath).orElse(null)) == null) continue;
            invalidatedPaths.addAll(dataDictionaryLoader.getModelsThatReferenceDataDictionary(dictionary).stream().filter(Objects::nonNull).map(SimulinkModel::getUniformPath).toList());
        }
        return invalidatedPaths;
    }

    private Function<String, List<SimulinkFileReference>> getFileReferencesAccessor() {
        return uniformPath -> {
            try {
                return this.fileReferenceIndex.getFileReferences((String)uniformPath);
            }
            catch (StorageException e) {
                LOGGER.error("Storage failure while to retrieving file references for " + uniformPath, (Throwable)e);
                return Collections.emptyList();
            }
        };
    }

    static Pair<List<SimulinkModel>, Set<SimulinkModel>> getTopSortedModels(List<String> uniformPaths, LazyModelLoader modelLoader, SimulinkLibraryLoader libraryLoader) throws StorageException {
        HashMap<SimulinkModel, List<SimulinkModel>> modelReferences = new HashMap<SimulinkModel, List<SimulinkModel>>();
        for (String uniformPath : uniformPaths) {
            SimulinkModel model = modelLoader.getModelByUniformPath(uniformPath).orElse(null);
            if (model == null) continue;
            modelReferences.put(model, SimulinkOutputDataTypeExtractionStep.getReferencedModels(model, libraryLoader));
        }
        return CollectionUtils.topSort(modelReferences.keySet(), modelReferences::get);
    }

    private static List<SimulinkModel> getReferencedModels(SimulinkModel model, SimulinkLibraryLoader libraryLoader) throws StorageException {
        ArrayList<SimulinkModel> referencedModels = new ArrayList<SimulinkModel>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Reference", "SubSystem"), (boolean)true, (boolean)true)) {
            if (block.isOfType("Reference") && SimulinkUtils.referencesCustomLibrary((SimulinkBlock)block)) {
                referencedModels.addAll(libraryLoader.loadLibraryFromReferenceBlock(block));
                continue;
            }
            if (!block.isOfType("SubSystem") || !SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) continue;
            referencedModels.addAll(libraryLoader.loadReferencedModelFromSubsystemReferenceBlock(block));
        }
        return referencedModels;
    }

    private void resolveDataTypes(SimulinkModel model, SimulinkLibraryLoader libraryLoader, DataDictionaryLoader dictionaryLoader, Map<String, SimulinkResolvedDataTypes> resolvedDataTypes, Map<String, SimulinkDataTypeResolver> dataTypeResolversMap) {
        try {
            SimulinkResolvedDataTypes resolved = Optional.ofNullable(resolvedDataTypes.get(model.getUniformPath())).orElse(new SimulinkResolvedDataTypes());
            SimulinkDataTypeResolver dataTypeResolver = dataTypeResolversMap.get(model.getUniformPath());
            if (dataTypeResolver == null) {
                dataTypeResolver = new SimulinkDataTypeResolver(model, libraryLoader, dictionaryLoader, resolved, dataTypeResolversMap);
                dataTypeResolversMap.put(model.getUniformPath(), dataTypeResolver);
            }
            if (!model.isLibraryModel()) {
                resolvedDataTypes.putAll(dataTypeResolver.resolveOutputDataTypes((SimulinkBlock)model, Collections.emptyMap(), new HashSet<LibraryBlockIdentifier>()));
                return;
            }
            List<SimulinkBlock> libraryBlocks = this.determineLibraryBlocksInLibraryModel(model);
            if (libraryBlocks.isEmpty()) {
                resolvedDataTypes.putAll(SimulinkOutputDataTypeExtractionStep.resolveDataTypesInLibraryWithoutLibraryBlocks(model, resolved, dataTypeResolver));
            } else {
                for (SimulinkBlock libraryBlock : libraryBlocks) {
                    resolvedDataTypes.putAll(SimulinkOutputDataTypeExtractionStep.resolveDataTypesInLibraryBlock(libraryBlock, resolved, dataTypeResolver));
                }
            }
        }
        catch (Exception e) {
            SimulinkOutputDataTypeExtractionStep.logExceptionDuringPropagation("Failed to resolve data types for Simulink model ", model, e);
        }
    }

    private static Map<String, SimulinkResolvedDataTypes> resolveDataTypesInLibraryBlock(SimulinkBlock libraryBlock, SimulinkResolvedDataTypes resolvedTypesForLibraryModel, SimulinkDataTypeResolver dataTypeResolverForLibraryModel) throws StorageException {
        List unresolvedInportBlocks = resolvedTypesForLibraryModel.getUnresolvedInportBlocks(libraryBlock);
        unresolvedInportBlocks.removeIf(block -> {
            String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
            return dataType == null || !dataType.startsWith("Inherit: ");
        });
        Map<Pair<SimulinkBlock, String>, String> initialOutputDataTypes = SimulinkOutputDataTypeExtractionStep.createMapOfNotConnectedTypes(unresolvedInportBlocks);
        return dataTypeResolverForLibraryModel.resolveOutputDataTypes(libraryBlock, initialOutputDataTypes, new HashSet<LibraryBlockIdentifier>());
    }

    private static Map<String, SimulinkResolvedDataTypes> resolveDataTypesInLibraryWithoutLibraryBlocks(SimulinkModel model, SimulinkResolvedDataTypes resolved, SimulinkDataTypeResolver dataTypeResolver) throws StorageException {
        HashMap<Pair<SimulinkBlock, String>, String> initialOutputDataTypes = new HashMap<Pair<SimulinkBlock, String>, String>();
        for (SimulinkBlock topLevelBlock : model.getSubBlocks()) {
            if (!resolved.getResolvedDataTypesForAllOutports(topLevelBlock).isEmpty()) continue;
            for (SimulinkInPort inport : CollectionUtils.filter((Collection)topLevelBlock.getInPorts(), inport1 -> !inport1.isConnected())) {
                initialOutputDataTypes.put((Pair<SimulinkBlock, String>)Pair.createPair((Object)topLevelBlock, (Object)inport.getIndex()), "NOT_CONNECTED");
            }
            for (SimulinkOutPort outport : CollectionUtils.filter((Collection)topLevelBlock.getOutPorts(), outport1 -> !outport1.isConnected())) {
                initialOutputDataTypes.put((Pair<SimulinkBlock, String>)Pair.createPair((Object)topLevelBlock, (Object)outport.getIndex()), "NOT_CONNECTED");
            }
        }
        return dataTypeResolver.resolveOutputDataTypes((SimulinkBlock)model, initialOutputDataTypes, new HashSet<LibraryBlockIdentifier>());
    }

    private static Map<Pair<SimulinkBlock, String>, String> createMapOfNotConnectedTypes(List<SimulinkBlock> unresolvedInportBlocks) {
        HashMap<Pair<SimulinkBlock, String>, String> inputDataTypes = new HashMap<Pair<SimulinkBlock, String>, String>();
        for (SimulinkBlock unresolvedInportBlock : unresolvedInportBlocks) {
            inputDataTypes.put((Pair<SimulinkBlock, String>)Pair.createPair((Object)unresolvedInportBlock, (Object)"1"), "NOT_CONNECTED");
        }
        return inputDataTypes;
    }

    private void resolveDimensions(SimulinkModel model, LazyModelLoader modelLoader, SimulinkLibraryLoader libraryLoader, Map<String, SimulinkResolvedDimensions> resolvedDimensions) {
        try {
            SimulinkResolvedDimensions resolved = Optional.ofNullable(resolvedDimensions.get(model.getUniformPath())).orElse(new SimulinkResolvedDimensions());
            SimulinkDimensionalityResolver dimensionalityResolver = new SimulinkDimensionalityResolver(model, libraryLoader, resolved, this.getAlreadyResolvedDimensions(model, modelLoader, libraryLoader, resolvedDimensions));
            Map<String, SimulinkResolvedDimensions> resolveDimensions = dimensionalityResolver.resolveDimensions(new HashSet<LibraryBlockIdentifier>());
            resolvedDimensions.putAll(resolveDimensions);
        }
        catch (Exception e) {
            SimulinkOutputDataTypeExtractionStep.logExceptionDuringPropagation("Failed to resolve dimensions for Simulink model ", model, e);
        }
    }

    private Map<String, SimulinkDimensionalityResolver> getAlreadyResolvedDimensions(SimulinkModel exclude, LazyModelLoader modelLoader, SimulinkLibraryLoader libraryLoader, Map<String, SimulinkResolvedDimensions> resolvedDimensions) throws StorageException {
        HashMap<String, SimulinkDimensionalityResolver> resolvedDataTypesForEmbeddedModels = new HashMap<String, SimulinkDimensionalityResolver>();
        for (Map.Entry<String, SimulinkResolvedDimensions> entry : resolvedDimensions.entrySet()) {
            if (entry.getKey().equals(exclude.getUniformPath())) continue;
            modelLoader.getModelByUniformPath(entry.getKey()).ifPresent(m -> resolvedDataTypesForEmbeddedModels.put((String)entry.getKey(), new SimulinkDimensionalityResolver((SimulinkModel)m, libraryLoader, (SimulinkResolvedDimensions)entry.getValue())));
        }
        return resolvedDataTypesForEmbeddedModels;
    }

    private void resolveSignalLabels(SimulinkModel model, LazyModelLoader modelLoader, SimulinkLibraryLoader libraryLoader, Map<String, SimulinkPropagatedSignalLabels> resolvedLabels) {
        try {
            SimulinkPropagatedSignalLabels propagatedSignalLabels = Optional.ofNullable(resolvedLabels.get(model.getUniformPath())).orElse(new SimulinkPropagatedSignalLabels());
            Map<String, SimulinkSignalLabelResolver> resolvedSignalsForEmbeddedModel = this.getAlreadyResolvedSignalLabels(model, modelLoader, libraryLoader, resolvedLabels);
            SimulinkSignalLabelResolver signalLabelResolver = new SimulinkSignalLabelResolver(model, libraryLoader, propagatedSignalLabels, resolvedSignalsForEmbeddedModel);
            Map<String, SimulinkPropagatedSignalLabels> result = signalLabelResolver.resolveSignalLabels(new HashSet<LibraryBlockIdentifier>());
            resolvedLabels.putAll(result);
        }
        catch (Exception e) {
            SimulinkOutputDataTypeExtractionStep.logExceptionDuringPropagation("Failed to resolve signal labels for Simulink model ", model, e);
        }
    }

    private static void logExceptionDuringPropagation(String x, SimulinkModel model, Exception e) {
        LOGGER.error(x + model.getUniformPath() + ": " + e.getMessage(), (Throwable)e);
    }

    private Map<String, SimulinkSignalLabelResolver> getAlreadyResolvedSignalLabels(SimulinkModel exclude, LazyModelLoader modelLoader, SimulinkLibraryLoader libraryLoader, Map<String, SimulinkPropagatedSignalLabels> resolvedLabels) throws StorageException {
        HashMap<String, SimulinkSignalLabelResolver> resolvedSignalLabelsForEmbeddedModels = new HashMap<String, SimulinkSignalLabelResolver>();
        for (Map.Entry<String, SimulinkPropagatedSignalLabels> entry : resolvedLabels.entrySet()) {
            if (entry.getKey().equals(exclude.getUniformPath())) continue;
            modelLoader.getModelByUniformPath(entry.getKey()).ifPresent(model -> resolvedSignalLabelsForEmbeddedModels.put((String)entry.getKey(), new SimulinkSignalLabelResolver((SimulinkModel)model, libraryLoader, (SimulinkPropagatedSignalLabels)entry.getValue())));
        }
        return resolvedSignalLabelsForEmbeddedModels;
    }

    private List<SimulinkBlock> determineLibraryBlocksInLibraryModel(SimulinkModel library) {
        ArrayList<SimulinkBlock> libraryBlocks = new ArrayList<SimulinkBlock>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)library, (boolean)false, (boolean)false)) {
            boolean hasPorts = !block.getInPorts().isEmpty() || !block.getOutPorts().isEmpty();
            boolean isConnected = !block.getInLines().isEmpty() || !block.getOutLines().isEmpty();
            boolean hasMaskedParent = false;
            for (SimulinkBlock current = block.getParent(); current != null; current = current.getParent()) {
                if (!SimulinkUtils.isMaskedSubsystem((SimulinkBlock)current)) continue;
                hasMaskedParent = true;
                break;
            }
            if (!hasPorts || isConnected || hasMaskedParent) continue;
            libraryBlocks.add(block);
        }
        return libraryBlocks;
    }

    private static class SimulinkSignalPropagationContext {
        private Map<String, SimulinkResolvedDataTypes> resolvedDataTypes;
        private Map<String, Integer> dataTypesInitialContentHashes;
        private Map<String, SimulinkResolvedDimensions> resolvedDimensions;
        private Map<String, Integer> dimensionsInitialContentHashes;
        private Map<String, SimulinkPropagatedSignalLabels> resolvedLabels;
        private Map<String, Integer> labelsInitialContentHashes;

        private SimulinkSignalPropagationContext() {
        }

        private void loadDataFromPreviousCommits(SimulinkOutputDataTypeIndex outputDataTypeIndex, SimulinkDimensionalityIndex dimensionsIndex, SimulinkSignalLabelIndex signalLabelIndex, LazyModelLoader modelLoader) throws StorageException {
            this.resolvedDataTypes = this.loadIndexEntriesFromPreviousCommits(outputDataTypeIndex::getAllResolvedDataTypes, modelLoader);
            this.dataTypesInitialContentHashes = CollectionUtils.map(this.resolvedDataTypes, Function.identity(), SimulinkResolvedInformation::hashCode);
            this.resolvedDimensions = this.loadIndexEntriesFromPreviousCommits(dimensionsIndex::getAllSignalDimensions, modelLoader);
            this.dimensionsInitialContentHashes = CollectionUtils.map(this.resolvedDimensions, Function.identity(), SimulinkResolvedInformation::hashCode);
            this.resolvedLabels = this.loadIndexEntriesFromPreviousCommits(signalLabelIndex::getAllSignalLabels, modelLoader);
            this.labelsInitialContentHashes = CollectionUtils.map(this.resolvedLabels, Function.identity(), SimulinkResolvedInformation::hashCode);
        }

        private <T extends SimulinkResolvedInformation> Map<String, T> loadIndexEntriesFromPreviousCommits(SupplierWithException<PairList<String, T>, StorageException> getAllEntriesFromIndexMethod, LazyModelLoader modelLoader) throws StorageException {
            HashMap<String, SimulinkResolvedInformation> resolvedInfoFromPreviousCommits = new HashMap<String, SimulinkResolvedInformation>();
            for (Pair entry : (PairList)getAllEntriesFromIndexMethod.get()) {
                if (!modelLoader.getModelByUniformPath((String)entry.getFirst()).isPresent()) continue;
                resolvedInfoFromPreviousCommits.put((String)entry.getFirst(), (SimulinkResolvedInformation)entry.getSecond());
            }
            return resolvedInfoFromPreviousCommits;
        }

        private PairList<String, SimulinkResolvedDataTypes> getChangedResolvedDataTypes() {
            return SimulinkSignalPropagationContext.retainChangedEntries(this.resolvedDataTypes, this.dataTypesInitialContentHashes);
        }

        private PairList<String, SimulinkResolvedDimensions> getChangedResolvedDimensions() {
            return SimulinkSignalPropagationContext.retainChangedEntries(this.resolvedDimensions, this.dimensionsInitialContentHashes);
        }

        private PairList<String, SimulinkPropagatedSignalLabels> getChangedResolvedLabels() {
            return SimulinkSignalPropagationContext.retainChangedEntries(this.resolvedLabels, this.labelsInitialContentHashes);
        }

        private static <V extends SimulinkResolvedInformation> PairList<String, V> retainChangedEntries(@NonNull Map<String, V> resolvedInformation, Map<String, Integer> initialContentHashes) {
            PairList filteredMap = new PairList();
            for (Map.Entry<String, V> entry : resolvedInformation.entrySet()) {
                if (!initialContentHashes.containsKey(entry.getKey())) {
                    filteredMap.add((Object)entry.getKey(), (Object)((SimulinkResolvedInformation)entry.getValue()));
                    continue;
                }
                int initialHash = initialContentHashes.get(entry.getKey());
                if (resolvedInformation.hashCode() == initialHash) continue;
                filteredMap.add((Object)entry.getKey(), (Object)((SimulinkResolvedInformation)entry.getValue()));
            }
            return filteredMap;
        }
    }
}

