/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.MetricsIndexSynchronizer;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.CyclomaticComplexityAnalyzer;
import com.teamscale.index.structure.FindingsBasedMethodAssessor;
import com.teamscale.index.structure.LOCAnalyzer;
import com.teamscale.index.structure.NumericMetricAnalyzerBase;
import com.teamscale.index.structure.SLOCAnalyzer;
import com.teamscale.index.structure.ShallowParsedLongestStatementListAnalyzer;
import com.teamscale.index.structure.ShallowParsedStatementNestingDepthAnalyzer;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

public class StructuringAnalysis
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String NUMBER_OF_FILES_METRICS_INDEX_PARTITION = "elements";
    public static final String LANGUAGE_METRIC_PARTITION = "language";
    public static final String LOC_RED_THRESHOLD_PARAMETER = "loc-red-threshold";
    public static final String LOC_YELLOW_THRESHOLD_PARAMETER = "loc-yellow-threshold";
    public static final String SLOC_RED_THRESHOLD_PARAMETER = "sloc-red-threshold";
    public static final String SLOC_YELLOW_THRESHOLD_PARAMETER = "sloc-yellow-threshold";
    public static final String LSL_RED_THRESHOLD_PARAMETER = "lsl-red-threshold";
    public static final String LSL_YELLOW_THRESHOLD_PARAMETER = "lsl-yellow-threshold";
    public static final String NESTING_RED_THRESHOLD_PARAMETER = "nesting-red-threshold";
    public static final String NESTING_YELLOW_THRESHOLD_PARAMETER = "nesting-yellow-threshold";
    public static final String COMPLEXITY_RED_THRESHOLD_PARAMETER = "complexity-red-threshold";
    public static final String COMPLEXITY_YELLOW_THRESHOLD_PARAMETER = "complexity-yellow-threshold";
    public static final String LSL_SLOC_BASED_PARAMETER = "lsl-sloc-based";
    public static final String LSL_STATEMENT_BASED_PARAMETER = "lsl-statement-based";
    public static final String IGNORED_METHODS_PATTERN_PARAMETER = "ignored-methods-pattern";
    public static final String LSL_ASSESSMENT_SLOC_BASED_PARAMETER = "lsl-assessment-sloc-based";
    public static final String NESTING_ASSESSMENT_SLOC_BASED_PARAMETER = "nesting-assessment-sloc-based";
    public static final String COMPLEXITY_ASSESSMENT_SLOC_BASED_PARAMETER = "complexity-assessment-sloc-based";
    public static final String LSL_ENABLED = "lsl-enabled";
    public static final String LSL_ASSESSMENT_ENABLED = "lsl-assessment-enabled";
    public static final String NESTING_DEPTH_ENABLED = "nesting-depth-enabled";
    public static final String NESTING_DEPTH_ASSESSMENT_ENABLED = "nesting-depth-assessment-enabled";
    public static final String COMPLEXITY_ENABLED = "complexity-enabled";
    public static final String COMPLEXITY_ASSESSMENT_ENABLED = "complexity-assessment-enabled";
    @StepParameter(value="loc-red-threshold")
    private CodeScopeAware<Integer> locRedThreshold;
    @StepParameter(value="loc-yellow-threshold")
    private CodeScopeAware<Integer> locYellowThreshold;
    @StepParameter(value="sloc-red-threshold")
    private CodeScopeAware<Integer> slocRedThreshold;
    @StepParameter(value="sloc-yellow-threshold")
    private CodeScopeAware<Integer> slocYellowThreshold;
    @StepParameter(value="lsl-red-threshold")
    private CodeScopeAware<Integer> lslRedThreshold;
    @StepParameter(value="lsl-yellow-threshold")
    private CodeScopeAware<Integer> lslYellowThreshold;
    @StepParameter(value="nesting-red-threshold")
    private CodeScopeAware<Integer> nestingRedThreshold;
    @StepParameter(value="nesting-yellow-threshold")
    private CodeScopeAware<Integer> nestingYellowThreshold;
    @StepParameter(value="complexity-red-threshold")
    private CodeScopeAware<Integer> complexityRedThreshold;
    @StepParameter(value="complexity-yellow-threshold")
    private CodeScopeAware<Integer> complexityYellowThreshold;
    @StepParameter(value="lsl-sloc-based", optional=true)
    private CodeScopeAware<Boolean> lslSlocBased = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="lsl-statement-based", optional=true)
    private CodeScopeAware<Boolean> lslStatementBased = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="ignored-methods-pattern", optional=true)
    private CodeScopeAware<String> ignoredMethodsPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @StepParameter(value="lsl-assessment-sloc-based", optional=true)
    private CodeScopeAware<Boolean> lslAssessmentSlocBased = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="nesting-assessment-sloc-based", optional=true)
    private CodeScopeAware<Boolean> nestingAssessmentSlocBased = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="complexity-assessment-sloc-based", optional=true)
    private CodeScopeAware<Boolean> complexityAssessmentSlocBased = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="lsl-enabled")
    private CodeScopeAware<Boolean> lslEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @StepParameter(value="lsl-assessment-enabled")
    private CodeScopeAware<Boolean> lslAssessmentEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="nesting-depth-enabled")
    private CodeScopeAware<Boolean> nestingDepthEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @StepParameter(value="nesting-depth-assessment-enabled")
    private CodeScopeAware<Boolean> nestingDepthAssessmentEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="complexity-enabled")
    private CodeScopeAware<Boolean> complexityEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="complexity-assessment-enabled")
    private CodeScopeAware<Boolean> complexityAssessmentEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @IndexAccess(indexName="metrics", value=EIndexAccessMode.READ_WRITE)
    private MetricsIndex metricsIndex;
    @IndexAccess(indexName="binary-content", value=EIndexAccessMode.READ_ONLY)
    private BinaryElementIndex binaryElementIndex;
    private MetricsIndexSynchronizer metricsSynchronizer;
    private final CodeScopeAware<ListMap<String, IndexFinding>> findingsPerCodeScope = CodeScopeAware.empty();

    public void execute() throws StorageException {
        this.metricsSynchronizer = new MetricsIndexSynchronizer(this.metricsIndex, this.contentDelta);
        this.runFileCountAnalysis();
        CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope = CodeScopeUtils.groupElementsByCodeScope(this.getContentIndexCache().getValues(this.getAddedOrChangedPathsWithoutArchitectures()));
        this.initializeFindings(elementsPerCodeScope.getCodeScopeNames());
        this.runLocAnalysis(elementsPerCodeScope);
        this.runShallowParsedAnalysis(elementsPerCodeScope);
        this.storeLanguageMetric();
        this.storeCodeScopeMetric(elementsPerCodeScope);
        this.metricsSynchronizer.synchronize();
        this.synchronizeFindingsForTokenElementIndexDelta(this.findingsPerCodeScope, "structuring");
    }

    private void initializeFindings(List<CodeScopeName> codeScopeNames) {
        codeScopeNames.forEach(codeScope -> this.findingsPerCodeScope.setValue(codeScope, (Object)new ListMap()));
    }

    private void runFileCountAnalysis() {
        PairList fileCounts = new PairList();
        for (String uniformPath : this.getAddedOrChangedPathsWithoutArchitectures()) {
            fileCounts.add((Object)uniformPath, (Object)1.0);
        }
        StructuringAnalysis.addNullValues((PairList<String, Serializable>)fileCounts, this.getAddedOrChangedArchitectures());
        this.metricsSynchronizer.addPartition(NUMBER_OF_FILES_METRICS_INDEX_PARTITION, fileCounts);
    }

    private List<String> getAddedOrChangedPathsWithoutArchitectures() {
        return CollectionUtils.filter((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), uniformPath -> !UniformPathUtils.isArchitectureFile((String)uniformPath));
    }

    private List<String> getAddedOrChangedArchitectures() {
        return CollectionUtils.filter((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), UniformPathUtils::isArchitectureFile);
    }

    private void runLocAnalysis(CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope) {
        PairList loc = new PairList();
        PairList sloc = new PairList();
        for (CodeScopeName codeScopeName : elementsPerCodeScope.getCodeScopeNames()) {
            List elementsForScope = (List)elementsPerCodeScope.getValue(codeScopeName);
            LOCAnalyzer locAnalysis = StructuringAnalysis.runStructuringAnalysis(new LOCAnalyzer(this.binaryElementIndex), "file size threshold (lines of code)", (Integer)this.locRedThreshold.getValueWithDefault(codeScopeName), (Integer)this.locYellowThreshold.getValueWithDefault(codeScopeName), elementsForScope);
            loc.addAll(locAnalysis.getMetricValues());
            ((ListMap)this.findingsPerCodeScope.getValue(codeScopeName)).addAll(locAnalysis.getFindings());
            SLOCAnalyzer slocAnalysis = StructuringAnalysis.runStructuringAnalysis(new SLOCAnalyzer(), "file size threshold (source lines of code)", (Integer)this.slocRedThreshold.getValueWithDefault(codeScopeName), (Integer)this.slocYellowThreshold.getValueWithDefault(codeScopeName), elementsForScope);
            sloc.addAll(slocAnalysis.getMetricValues());
            ((ListMap)this.findingsPerCodeScope.getValue(codeScopeName)).addAll(slocAnalysis.getFindings());
        }
        List unsupportedPaths = CollectionUtils.filter((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), UniformPathUtils::isArchitectureFile);
        StructuringAnalysis.addNullValues((PairList<String, Serializable>)loc, unsupportedPaths);
        StructuringAnalysis.addNullValues((PairList<String, Serializable>)sloc, unsupportedPaths);
        this.metricsSynchronizer.addPartition("loc", loc);
        this.metricsSynchronizer.addPartition("sloc", sloc);
    }

    private void runShallowParsedAnalysis(CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope) {
        this.runStructuringAnalysisWithAssessment(ShallowParsedStatementNestingDepthAnalyzer::new, "nesting depth threshold", this.nestingRedThreshold, this.nestingYellowThreshold, this.nestingAssessmentSlocBased, "nesting", "nesting-method-assessment", elementsPerCodeScope, this.nestingDepthAssessmentEnabled, this.nestingDepthEnabled);
        this.runLslAnalysis(elementsPerCodeScope);
        this.runStructuringAnalysisWithAssessment(CyclomaticComplexityAnalyzer::new, "cyclomatic complexity threshold", this.complexityRedThreshold, this.complexityYellowThreshold, this.complexityAssessmentSlocBased, "complexity", "complexity-method-assessment", elementsPerCodeScope, this.complexityAssessmentEnabled, this.complexityEnabled);
    }

    private void runLslAnalysis(CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope) {
        CodeScopeAware instancePerCodeScope = CodeScopeAware.empty();
        CodeScopeAware messageCorePerCodeScope = CodeScopeAware.empty();
        elementsPerCodeScope.parameter().forEach((codeScope, elements) -> {
            String messageCore = this.determineMessageCore((CodeScopeName)codeScope);
            messageCorePerCodeScope.setValue(codeScope, (Object)messageCore);
            instancePerCodeScope.setValue(codeScope, (Object)new ShallowParsedLongestStatementListAnalyzer((Boolean)this.lslSlocBased.getValueWithDefault(codeScope), (Boolean)this.lslStatementBased.getValueWithDefault(codeScope), Pattern.compile((String)this.ignoredMethodsPattern.getValueWithDefault(codeScope))));
        });
        this.runStructuringAnalysisWithAssessment(instancePerCodeScope, (CodeScopeAware<String>)messageCorePerCodeScope, this.lslRedThreshold, this.lslYellowThreshold, this.lslAssessmentSlocBased, "lsl", "lsl-method-assessment", elementsPerCodeScope, this.lslAssessmentEnabled, this.lslEnabled);
    }

    private @NonNull String determineMessageCore(CodeScopeName codeScopeName) {
        if (((Boolean)this.lslStatementBased.getValueWithDefault(codeScopeName)).booleanValue()) {
            return "method length threshold (statements)";
        }
        if (((Boolean)this.lslSlocBased.getValueWithDefault(codeScopeName)).booleanValue()) {
            return "method length threshold (source lines of code)";
        }
        return "method length threshold (lines of code)";
    }

    private void storeLanguageMetric() throws StorageException {
        List<String> uniformPaths = this.getAddedOrChangedPathsWithoutArchitectures();
        HashSet<String> uniformPathsAsSet = new HashSet<String>(uniformPaths);
        List<TokenElementInfo> tokenElementInfos = this.getContentIndexCache().getValues(uniformPaths);
        Map<String, Serializable> uniformPathLanguageMap = tokenElementInfos.stream().collect(Collectors.toMap(BasicTokenElementInfo::getUniformPath, tokenElementInfo -> {
            if (uniformPathsAsSet.remove(tokenElementInfo.getUniformPath())) {
                return new CounterSet((Object)tokenElementInfo.getLanguage().getReadableName(), 1);
            }
            return new CounterSet();
        }));
        this.metricsSynchronizer.addPartition(LANGUAGE_METRIC_PARTITION, new PairList(uniformPathLanguageMap));
    }

    private void storeCodeScopeMetric(CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope) {
        PairList uniformPathToCodeScopeMapping = new PairList();
        for (CodeScopeName codeScopeName : elementsPerCodeScope.getCodeScopeNames()) {
            List tokenElementInfos = (List)elementsPerCodeScope.getValue(codeScopeName);
            tokenElementInfos.forEach(elementInfo -> uniformPathToCodeScopeMapping.add((Object)elementInfo.getUniformPath(), (Object)new CounterSet(List.of(codeScopeName.name()))));
        }
        this.metricsSynchronizer.addPartition("code-scope", uniformPathToCodeScopeMapping);
    }

    private static <T extends NumericMetricAnalyzerBase> T runStructuringAnalysis(T instance, String findingMessageCore, int redThreshold, int yellowThreshold, Collection<TokenElementInfo> elements) {
        instance.setFindingThreshold(redThreshold, ETrafficLightColor.RED, findingMessageCore);
        instance.setFindingThreshold(yellowThreshold, ETrafficLightColor.YELLOW, findingMessageCore);
        instance.analyze(elements);
        return instance;
    }

    private static List<TokenElementInfo> filterShallowParseableElements(List<TokenElementInfo> elements) {
        return CollectionUtils.filter(elements, element -> ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage()));
    }

    private <T extends NumericMetricAnalyzerBase> void runStructuringAnalysisWithAssessment(CodeScopeAware<T> instance, CodeScopeAware<String> messageCore, CodeScopeAware<Integer> redThreshold, CodeScopeAware<Integer> yellowThreshold, CodeScopeAware<Boolean> assessmentSlocBased, String metricPartition, String assessmentPartition, CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope, CodeScopeAware<Boolean> assessmentEnablementPerCodeScope, CodeScopeAware<Boolean> metricEnablement) {
        PairList metrics = new PairList();
        PairList assessmentMetrics = new PairList();
        for (CodeScopeName codeScopeName : elementsPerCodeScope.getCodeScopeNames()) {
            if (!((Boolean)metricEnablement.getValue(codeScopeName)).booleanValue()) continue;
            List<TokenElementInfo> shallowParseableElements = StructuringAnalysis.filterShallowParseableElements((List)elementsPerCodeScope.getValue(codeScopeName));
            NumericMetricAnalyzerBase analyzer = StructuringAnalysis.runStructuringAnalysis((NumericMetricAnalyzerBase)instance.getValue(codeScopeName), (String)messageCore.getValue(codeScopeName), (Integer)redThreshold.getValueWithDefault(codeScopeName), (Integer)yellowThreshold.getValueWithDefault(codeScopeName), shallowParseableElements);
            ListMap<String, IndexFinding> newFindings = analyzer.getFindings();
            ((ListMap)this.findingsPerCodeScope.getValue(codeScopeName)).addAll(newFindings);
            metrics.addAll(analyzer.getMetricValues());
            if (!((Boolean)assessmentEnablementPerCodeScope.getValue(codeScopeName)).booleanValue()) continue;
            FindingsBasedMethodAssessor assessor = new FindingsBasedMethodAssessor((Boolean)assessmentSlocBased.getValueWithDefault(codeScopeName));
            assessmentMetrics.addAll(assessor.computeAssessmentMetricValues(shallowParseableElements, newFindings));
        }
        StructuringAnalysis.addNullValues((PairList<String, Serializable>)metrics, CollectionUtils.subtract((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), (Collection)metrics.extractFirstList()));
        this.metricsSynchronizer.addPartition(metricPartition, metrics);
        StructuringAnalysis.addEmptyAssessments((PairList<String, Serializable>)assessmentMetrics, CollectionUtils.subtract((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), (Collection)assessmentMetrics.extractFirstList()));
        this.metricsSynchronizer.addPartition(assessmentPartition, assessmentMetrics);
    }

    private <T extends NumericMetricAnalyzerBase> void runStructuringAnalysisWithAssessment(Supplier<T> instanceSupplier, String messageCore, CodeScopeAware<Integer> redThreshold, CodeScopeAware<Integer> yellowThreshold, CodeScopeAware<Boolean> assessmentSlocBased, String metricPartition, String assessmentPartition, CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope, CodeScopeAware<Boolean> assessmentEnablementPerCodeScope, CodeScopeAware<Boolean> metricEnablement) {
        CodeScopeAware messageCorePerCodeScope = CodeScopeAware.empty();
        CodeScopeAware instancePerCodeScope = CodeScopeAware.empty();
        elementsPerCodeScope.parameter().forEach((codeScope, elements) -> {
            messageCorePerCodeScope.setValue(codeScope, (Object)messageCore);
            instancePerCodeScope.setValue(codeScope, (Object)((NumericMetricAnalyzerBase)instanceSupplier.get()));
        });
        this.runStructuringAnalysisWithAssessment(instancePerCodeScope, (CodeScopeAware<String>)messageCorePerCodeScope, redThreshold, yellowThreshold, assessmentSlocBased, metricPartition, assessmentPartition, elementsPerCodeScope, assessmentEnablementPerCodeScope, metricEnablement);
    }

    private static void addEmptyAssessments(PairList<String, Serializable> metricValues, Collection<String> uniformPaths) {
        for (String uniformPath : uniformPaths) {
            metricValues.add((Object)uniformPath, (Object)new Assessment());
        }
    }

    private static void addNullValues(PairList<String, Serializable> metricValues, Collection<String> uniformPaths) {
        for (String uniformPath : uniformPaths) {
            metricValues.add((Object)uniformPath, null);
        }
    }
}

