/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemLoadFragment;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.abap.jco.JcoReflectionUtils;
import org.conqat.engine.abap.jco.JcoUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class JavaSystemInfoFragment
extends SystemInfoFragmentBase {
    private static final long serialVersionUID = 1L;
    private static final String PASSWORD_VM_ARGUMENT_INDICATOR = "Password=";
    private final String description;
    private final String version;
    private final String javaHome;
    private final String workingDirectory;
    private final String vmArguments;
    private final String userName;
    private final String defaultCharset;
    private final long maxMemory;
    private final long usedMemory;
    private final long totalMemory;
    private final double usedMemoryPercent;
    private final String sapJcoVersion;

    public JavaSystemInfoFragment() {
        super(Long.MAX_VALUE);
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        this.description = mxBean.getVmVendor() + " " + mxBean.getVmName() + " " + mxBean.getVmVersion();
        this.version = System.getProperty("java.version");
        this.javaHome = System.getProperty("java.home");
        this.vmArguments = JavaSystemInfoFragment.getSanitizedVmArguments();
        this.userName = System.getProperty("user.name");
        this.workingDirectory = System.getProperty("user.dir");
        this.defaultCharset = Charset.defaultCharset().name();
        Runtime runtime = Runtime.getRuntime();
        this.maxMemory = JavaSystemInfoFragment.byteToMegabyte(runtime.maxMemory());
        this.usedMemory = JavaSystemInfoFragment.byteToMegabyte(runtime.totalMemory() - runtime.freeMemory());
        this.usedMemoryPercent = 100.0 * (double)this.usedMemory / (double)this.maxMemory;
        this.totalMemory = JavaSystemInfoFragment.byteToMegabyte(runtime.totalMemory());
        this.sapJcoVersion = JcoReflectionUtils.isJCoLibraryLoaded() ? JcoUtils.getJcoVersion() : "not loaded";
    }

    private static String getSanitizedVmArguments() {
        return StringUtils.concat((Iterable)CollectionUtils.map(ManagementFactory.getRuntimeMXBean().getInputArguments(), JavaSystemInfoFragment::sanitizeVmArgument), (String)" ");
    }

    private static String sanitizeVmArgument(String vmArgument) {
        int passwordIndex = vmArgument.indexOf(PASSWORD_VM_ARGUMENT_INDICATOR);
        if (passwordIndex != -1) {
            return vmArgument.substring(0, passwordIndex + PASSWORD_VM_ARGUMENT_INDICATOR.length()) + "*****";
        }
        return vmArgument;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    private static long byteToMegabyte(long bytes) {
        return ByteUnit.BYTES.toMebiBytes(bytes);
    }

    public String toJavaInfo() {
        return "JVM Version: " + this.version + "\nJVM name: " + this.description + "\nInstallation directory: " + this.javaHome + "\n";
    }

    @Override
    public String getFragmentCaption() {
        return "Java VM";
    }

    @Override
    public int getFragmentOrder() {
        return 1;
    }

    @Override
    public List<SystemInfoEntry> convertToKeyValuePairs() {
        ArrayList<SystemInfoEntry> result = new ArrayList<SystemInfoEntry>();
        result.add(SystemInfoEntry.ofString("JVM version", this.version));
        result.add(SystemInfoEntry.ofString("JVM name", this.description));
        result.add(SystemInfoEntry.ofString("Installation directory", this.javaHome));
        result.add(SystemInfoEntry.ofString("JVM arguments", this.vmArguments));
        result.add(SystemInfoEntry.ofString("User name", this.userName));
        result.add(SystemInfoEntry.ofString("JVM working directory", this.workingDirectory));
        result.add(SystemInfoEntry.ofString("SAP JCo version", this.sapJcoVersion));
        result.add(SystemInfoEntry.ofString("Default charset", this.defaultCharset));
        result.add(SystemInfoEntry.ofString("Maximum memory", SystemLoadFragment.convertToGB(this.maxMemory, ByteUnit.MEBIBYTES)));
        result.add(SystemInfoEntry.ofString("Total memory", SystemLoadFragment.convertToGB(this.totalMemory, ByteUnit.MEBIBYTES)));
        result.add(SystemInfoEntry.ofPercentage("Used memory", this.usedMemoryPercent, SystemLoadFragment.convertToGB(this.usedMemory, ByteUnit.MEBIBYTES)));
        return result;
    }

    public String getJvmNameAndVersion() {
        return this.description + " " + this.version;
    }
}

