/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testcoverage.CoverageAdjuster;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public abstract class CoverageMetricSynchronizerBase
extends ChangeProcessorAnalysisStep {
    public static final String COVERAGE_PARTITION_GROUP_NAME_PARAMETER = "coverage-partition-group";
    public static final String COVERAGE_PARTITION_GROUP_PATTERN_PARAMETER = "coverage-partition-pattern";
    public static final String COVERABLE_PARTITION_PARAMETER = "coverable-partition";
    public static final String EXCLUDE_TEST_CODE_PARAMETER = "exclude-test-code";
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    protected TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CodeScopesMappingIndex codeScopesMappingIndex;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    protected KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics")
    private MetricsIndex metricsIndex;
    @DeltaSource(value=LineCoverageIndex.class)
    protected KeyDelta lineCoverageDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected LineCoverageIndex lineCoverageIndex;
    @StepParameter(value="coverage-partition-pattern", optional=true)
    private final List<String> coveragePartitionPatternInput = new ArrayList<String>();
    @StepParameter(value="coverage-partition-group", optional=true)
    private final List<String> coveragePartitionGroupNameInput = new ArrayList<String>();
    @StepParameter(value="exclude-test-code", optional=true)
    private boolean excludeTestCode = false;
    @StepParameter(value="coverable-partition", optional=true)
    private final List<String> coverablePartitionGroupInput = new ArrayList<String>();
    private final List<CoveragePartitionGroup> coveragePartitionGroups = new ArrayList<CoveragePartitionGroup>();

    public void execute() throws StorageException, ExecutionException {
        if (this.coveragePartitionGroupNameInput.isEmpty()) {
            CoveragePartitionGroup group = new CoveragePartitionGroup(this.getDefaultCoveredPartitionName(), this.getDefaultCoverablePartitionName(), ".*");
            this.coveragePartitionGroups.add(group);
        }
        for (int i = 0; i < this.coveragePartitionGroupNameInput.size(); ++i) {
            CoveragePartitionGroup group = new CoveragePartitionGroup(this.coveragePartitionGroupNameInput.get(i), this.coverablePartitionGroupInput.get(i), this.coveragePartitionPatternInput.get(i));
            this.coveragePartitionGroups.add(group);
        }
        this.removeDeletedMetrics();
        ArrayList<String> uniformPathsToUpdate = new ArrayList<String>(this.getUniformPathsToUpdate());
        for (CoveragePartitionGroup partitionGroup : this.coveragePartitionGroups) {
            this.executeInParallelBatches(uniformPathsToUpdate, batch -> this.updateCoverageMetrics(partitionGroup, (List<String>)batch));
        }
    }

    protected PairList<String, LineCoverageInfo> getLineCoverageInfosToUpdate(CoveragePartitionGroup partitionGroup, boolean includeMethodAccurate, List<String> uniformPaths) throws StorageException {
        if (uniformPaths.isEmpty()) {
            return new PairList();
        }
        return this.loadLineCoverageInfosWithCorrection(uniformPaths, partitionGroup, includeMethodAccurate);
    }

    protected Set<String> getUniformPathsToUpdate() {
        HashSet<String> keysToUpdate = new HashSet<String>(this.contentDelta.getAddedOrChangedKeysAsStrings());
        keysToUpdate.addAll(PartitionIndexBase.getUniformPaths((Collection)CollectionUtils.unionSet((Collection)this.lineCoverageDelta.getAddedOrChangedKeysAsStrings(), (Collection[])new Collection[]{this.lineCoverageDelta.getDeletedKeysAsStrings()})));
        return keysToUpdate;
    }

    protected abstract void updateCoverageMetrics(CoveragePartitionGroup var1, List<String> var2) throws StorageException;

    private PairList<String, LineCoverageInfo> loadLineCoverageInfosWithCorrection(List<String> uniformPaths, CoveragePartitionGroup partitionGroup, boolean includeMethodAccurate) throws StorageException {
        List<LineCoverageInfo> lineCoverageInfos = this.loadLineCoverageInfos(uniformPaths, partitionGroup, includeMethodAccurate);
        List<TokenElementLineInfo> elementInfos = this.tokenElementLineInfoIndex.getLineInfos(uniformPaths);
        Map<UniformPath, CodeScopeName> codeScopesPerPath = this.codeScopesMappingIndex.getMappings(UniformPathCompatibilityUtil.convertCollection(uniformPaths));
        PairList correctedLineCoverageInfos = new PairList();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            boolean lineCoverageInfoPresent;
            String uniformPath = uniformPaths.get(i);
            TokenElementLineInfo tokenElementLineInfo = elementInfos.get(i);
            if (tokenElementLineInfo == null) continue;
            LineCoverageInfo lineCoverageInfo = lineCoverageInfos.get(i);
            boolean bl = lineCoverageInfoPresent = lineCoverageInfo != null;
            if (!lineCoverageInfoPresent) {
                lineCoverageInfo = new LineCoverageInfo(false);
            }
            if (this.shouldExcludeFromCoverageComputation(tokenElementLineInfo, uniformPath, codeScopesPerPath)) {
                lineCoverageInfo.clear();
            } else {
                CoverageAdjuster.correctLineCoverage(uniformPath, tokenElementLineInfo, lineCoverageInfo, lineCoverageInfoPresent);
            }
            correctedLineCoverageInfos.add((Object)uniformPaths.get(i), (Object)lineCoverageInfo);
        }
        return correctedLineCoverageInfos;
    }

    private List<LineCoverageInfo> loadLineCoverageInfos(List<String> uniformPaths, CoveragePartitionGroup partitionGroup, boolean includeMethodAccurate) throws StorageException {
        ArrayList<LineCoverageInfo> lineCoverageInfos = new ArrayList<LineCoverageInfo>();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            lineCoverageInfos.add(null);
        }
        List<String> partitions = partitionGroup.filterPartitions(this.lineCoverageIndex.getPartitions());
        if (partitions.isEmpty()) {
            return lineCoverageInfos;
        }
        Map partitionCoverageInfos = this.lineCoverageIndex.getCoverageInfos(partitions, uniformPaths);
        for (String partition : partitions) {
            for (int i = 0; i < uniformPaths.size(); ++i) {
                LineCoverageInfo partitionCoverage = (LineCoverageInfo)partitionCoverageInfos.get(partition).get(uniformPaths.get(i));
                if (partitionCoverage == null || partitionCoverage.isMethodAccurate() && !includeMethodAccurate) continue;
                if (lineCoverageInfos.get(i) == null) {
                    lineCoverageInfos.set(i, partitionCoverage);
                    continue;
                }
                ((LineCoverageInfo)lineCoverageInfos.get(i)).addAll(partitionCoverage);
            }
        }
        return lineCoverageInfos;
    }

    private boolean shouldExcludeFromCoverageComputation(TokenElementLineInfo tokenElementLineInfo, String uniformPath, Map<UniformPath, CodeScopeName> codeScopesPerPath) {
        return this.excludeTestCode && tokenElementLineInfo.isTestCode() || this.isExcludedInCodeScope(uniformPath, codeScopesPerPath);
    }

    private boolean isExcludedInCodeScope(String uniformPath, Map<UniformPath, CodeScopeName> codeScopesPerPath) {
        Boolean isCoverageEnabled;
        UniformPath path = UniformPath.parse((String)uniformPath);
        if (!path.isCodePath()) {
            return false;
        }
        CodeScopeName codeScopeOfUniformPath = codeScopesPerPath.get(path);
        if (codeScopeOfUniformPath == null) {
            LOGGER.error("Could not find code scope for uniform path '{}'. Falling back to default code scope.", (Object)uniformPath);
            codeScopeOfUniformPath = CodeScopeName.DEFAULT;
        }
        if ((isCoverageEnabled = (Boolean)this.getCodeScopeAwareCoverageEnablement().getValueOrNull(codeScopeOfUniformPath)) == null) {
            return true;
        }
        return isCoverageEnabled == false;
    }

    private void removeDeletedMetrics() throws StorageException {
        List uniformPathsToDelete = this.contentDelta.getDeletedKeysAsStrings();
        if (!uniformPathsToDelete.isEmpty()) {
            this.metricsIndex.removeEntries((Collection)uniformPathsToDelete, this.getAllPartitionNames());
        }
    }

    private List<String> getAllPartitionNames() {
        ArrayList<String> partitionNames = new ArrayList<String>();
        HashSet<String> coverablePartitionNames = new HashSet<String>();
        for (CoveragePartitionGroup coverageGroup : this.coveragePartitionGroups) {
            partitionNames.add(coverageGroup.getCoveredPartition());
            coverablePartitionNames.add(coverageGroup.getCoverablePartition());
        }
        partitionNames.addAll(coverablePartitionNames);
        return partitionNames;
    }

    protected void storeData(PairList<String, Double> coverableData, PairList<String, Double> coveredData, CoveragePartitionGroup group) throws StorageException {
        if (coverableData.isEmpty()) {
            return;
        }
        this.metricsIndex.setMetricValues(Arrays.asList(coverableData, coveredData), Arrays.asList(group.getCoverablePartition(), group.getCoveredPartition()));
    }

    protected abstract String getDefaultCoverablePartitionName();

    protected abstract String getDefaultCoveredPartitionName();

    protected abstract CodeScopeAware<Boolean> getCodeScopeAwareCoverageEnablement();

    protected static class CoveragePartitionGroup {
        private final String coveredPartition;
        private final String coverablePartition;
        private final Pattern pattern;

        private CoveragePartitionGroup(String coveredPartition, String coverablePartition, String pattern) {
            this.coveredPartition = coveredPartition;
            this.coverablePartition = coverablePartition;
            this.pattern = Pattern.compile(pattern, 2);
        }

        public List<String> filterPartitions(List<String> partitions) {
            return CollectionUtils.filter(partitions, partition -> this.pattern.matcher((CharSequence)partition).matches());
        }

        private String getCoveredPartition() {
            return this.coveredPartition;
        }

        private String getCoverablePartition() {
            return this.coverablePartition;
        }
    }
}

