/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.dotnet.traces;

import com.teamscale.index.testgap.dotnet.ProfilerIdFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class DotNetTraceUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final char KEY_SEPARATOR = ':';
    public static final String LABEL_JITTED = "Jitted";
    public static final String LABEL_INLINED = "Inlined";
    public static final String LABEL_ASSEMBLY = "Assembly";
    private static final Pattern SEPARATOR_REGEX = Pattern.compile(String.valueOf(':'));
    private static final Pattern EQUALS_REGEX = Pattern.compile("=");
    private static final Pattern ASSEMBLY_REGEX = Pattern.compile("^([^:]+):(\\d+)");

    public static Set<ProfilerIdFeature> readExecutedMethods(String traceContent, String errorLocation, Predicate<String> assemblyFilter) {
        ListMap<String, String> traceMap = DotNetTraceUtils.keyValuesMapFor(traceContent);
        HashMap<String, String> assemblies = new HashMap<String, String>();
        List assemblyLines = (List)traceMap.getCollection((Object)LABEL_ASSEMBLY);
        if (assemblyLines != null) {
            for (String assemblyEntry : assemblyLines) {
                Matcher matcher = ASSEMBLY_REGEX.matcher(assemblyEntry);
                if (!matcher.find()) {
                    LOGGER.warn("Unknown assembly entry format '" + assemblyEntry + "' in trace " + errorLocation);
                    continue;
                }
                if (!assemblyFilter.test(matcher.group(1))) continue;
                assemblies.put(matcher.group(2), matcher.group(1));
            }
        }
        HashSet<ProfilerIdFeature> executedMethods = new HashSet<ProfilerIdFeature>();
        executedMethods.addAll(DotNetTraceUtils.constructMethodIds(assemblies, (List)traceMap.getCollection((Object)LABEL_INLINED), errorLocation));
        executedMethods.addAll(DotNetTraceUtils.constructMethodIds(assemblies, (List)traceMap.getCollection((Object)LABEL_JITTED), errorLocation));
        return executedMethods;
    }

    private static ListMap<String, String> keyValuesMapFor(String coverageReport) {
        ListMap entries = new ListMap();
        for (String line : StringUtils.splitLines((String)coverageReport)) {
            String[] parts;
            if (StringUtils.isEmpty((String)line) || line.startsWith("//") || (parts = EQUALS_REGEX.split(line)).length != 2) continue;
            entries.add((Object)parts[0], (Object)parts[1]);
        }
        return entries;
    }

    private static List<ProfilerIdFeature> constructMethodIds(Map<String, String> assemblies, List<String> methodInvocations, String location) {
        ArrayList<ProfilerIdFeature> methodIds = new ArrayList<ProfilerIdFeature>();
        if (methodInvocations == null) {
            return methodIds;
        }
        for (String methodInvocation : methodInvocations) {
            String containingAssembly;
            String methodToken;
            String assemblyToken;
            String[] parts = SEPARATOR_REGEX.split(methodInvocation);
            if (parts.length == 2) {
                assemblyToken = parts[0];
                methodToken = parts[1];
            } else if (parts.length == 3) {
                assemblyToken = parts[0];
                methodToken = parts[2];
            } else {
                LOGGER.warn("Expecting format like assembly:typetoken:methodtoken or assembly:methodtoken, but was: \"" + methodInvocation + "\" in " + location);
                continue;
            }
            if ((containingAssembly = assemblies.get(assemblyToken)) == null) continue;
            methodIds.add(new ProfilerIdFeature(containingAssembly, methodToken));
        }
        return methodIds;
    }

    public static String createMethodKey(String assemblyName, String methodMetadataToken) {
        return assemblyName + ":" + methodMetadataToken;
    }

    private DotNetTraceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

