/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.index;

import com.teamscale.index.tracking.index.FindingSerializationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Index(name="tracked-findings", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class TrackedFindingsIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "tracked-findings";
    private final ValueIndex<List<TrackedFinding>> delegate;

    public TrackedFindingsIndex(IStore store) {
        this.delegate = ValueIndex.of((IStore)store, FindingSerializationUtils.FINDING_LIST_SERIALIZER);
    }

    public List<List<TrackedFinding>> getFindings(List<UniformPath> uniformPaths) throws StorageException {
        return this.delegate.getValues(CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    public List<TrackedFinding> getFindings(String uniformPath) throws StorageException {
        return (List)this.delegate.getValue(uniformPath);
    }

    public void removeFindings(Set<UniformPath> uniformPaths) throws StorageException {
        this.delegate.removeValues((Collection)CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    public void setFindings(PairList<UniformPath, List<TrackedFinding>> uniformPathWithFindings) throws StorageException {
        this.delegate.setValues(UniformPathCompatibilityUtil.convertPairList(uniformPathWithFindings));
    }

    public void setFindings(UniformPath uniformPath, ArrayList<TrackedFinding> findings) throws StorageException {
        this.delegate.setValue(uniformPath.toString(), findings);
    }

    public Map<UniformPath, List<TrackedFinding>> getFindingsWithKeyPrefix(UniformPath uniformPathPrefix) throws StorageException {
        PairList entriesStartingWith = this.delegate.getEntriesStartingWith(uniformPathPrefix.toStringAsMigrationFrontier());
        return entriesStartingWith.stream().map(p -> new Pair((Object)UniformPathCompatibilityUtil.convert((String)((String)p.getFirst())), (Object)((List)p.getSecond()))).filter(p -> uniformPathPrefix.equals(p.getFirst()) || uniformPathPrefix.hasDescendant((UniformPath)p.getFirst())).collect(Collectors.toMap(ImmutablePair::getFirst, ImmutablePair::getSecond, CollectionUtils.throwingMerger(d -> "unknown"), LinkedHashMap::new));
    }

    public PairList<String, List<TrackedFinding>> getAllEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

