/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public class AsyncServiceJobRun
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="startTimestamp")
    private final long startTimestamp;
    @JsonProperty(value="progressStack")
    private final List<ProcessProgress> progressStack;
    @JsonProperty(value="jobDescription")
    private final String jobDescription;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="status")
    private final EJobStatus status;

    public AsyncServiceJobRun(String id, String username, long startTimestamp, String jobDescription, List<ProcessProgress> progressStack, EJobStatus status) {
        this.id = id;
        this.username = username;
        this.startTimestamp = startTimestamp;
        this.jobDescription = jobDescription;
        this.progressStack = Collections.unmodifiableList(progressStack);
        this.status = status;
    }

    public AsyncServiceJobRun(String username, long startTimestamp, String jobDescription) {
        this(UUID.randomUUID().toString(), username, startTimestamp, jobDescription, Collections.emptyList(), EJobStatus.SETUP);
    }

    public String getId() {
        return this.id;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public List<ProcessProgress> getProgressStack() {
        return this.progressStack;
    }

    public String getDescription() {
        return this.jobDescription;
    }

    public String getUsername() {
        return this.username;
    }

    public EJobStatus getStatus() {
        return this.status;
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum EJobStatus {
        SETUP,
        SCHEDULED,
        RUNNING,
        DONE,
        FAILED;

    }

    @IndexValueClass
    public record ProcessProgress(@JsonProperty(value="process") @NonNull String processDescription, @JsonProperty(value="step") int step, @JsonProperty(value="maxSteps") int maxSteps) implements Serializable
    {
    }
}

