/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.webhook;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.index.webhook.WebhookPayload;
import com.teamscale.index.webhook.WebhookSender;
import com.teamscale.index.webhook.XrayBuildsWebhookPayload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class XrayBuildsWebhookUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private XrayBuildsWebhookUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static void triggerWebhook(ServerOptionIndex serverOptionIndex, XrayBuildsWebhookPayload payload) throws StorageException {
        if (ShadowModeOption.isShadowModeEnabled((ServerOptionIndex)serverOptionIndex)) {
            LOGGER.atInfo().withMarker(LoggingUtils.INTERACTION).log("Skipping XRay-builds webhook because shadow mode is enabled.");
            return;
        }
        if (payload.updatedBuilds().isEmpty()) {
            LOGGER.debug("No updated builds to send in webhook. Skipping.");
            return;
        }
        try {
            XrayBuildsWebhookUtils.sendWebhook(serverOptionIndex, payload);
        }
        catch (ServiceCallException e) {
            LOGGER.error("Failed to send Xray-builds webhook.", (Throwable)e);
        }
    }

    private static void sendWebhook(ServerOptionIndex serverOptionIndex, XrayBuildsWebhookPayload xrayPayload) throws ServiceCallException {
        WebhookPayload<XrayBuildsWebhookPayload> payload = WebhookPayload.forXrayBuilds(xrayPayload);
        WebhookSender.sendWebhook(serverOptionIndex, payload);
        LOGGER.atInfo().withMarker(LoggingUtils.INTERACTION).log("Successfully sent Xray-builds webhook for project {} with {} builds.", (Object)xrayPayload.projectId(), (Object)xrayPayload.updatedBuilds().size());
    }
}

