/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.stream;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.conqat.engine.core.stream.ICollectorWithException;
import org.conqat.engine.core.stream.IIteratorWithException;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.error.ExceptionUtils;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class DelegatingStreamWithException<T, E extends Exception>
implements IStreamWithException<T, E> {
    private final Stream<T> delegate;
    private final Class<E> exceptionType;
    private final InvalidationSupport invalidationSupport = new InvalidationSupport();

    private DelegatingStreamWithException(Stream<T> delegate, Class<E> exceptionType) {
        this.delegate = delegate;
        this.exceptionType = exceptionType;
    }

    public DelegatingStreamWithException(IStreamSource<T, E> source) {
        CCSMAssert.isNotNull(source, () -> String.format("Expected \"%s\" to be not null", "source"));
        this.delegate = DelegatingStreamWithException.asStream(source);
        this.exceptionType = source.exceptionType();
    }

    private static <T, E extends Exception> @NonNull Stream<T> asStream(IStreamSource<T, E> source) {
        Runnable onClose;
        Spliterator<Object> spliterator;
        if (source instanceof SpliteratorBasedStreamSource) {
            SpliteratorBasedStreamSource streamBasedStreamSource = (SpliteratorBasedStreamSource)source;
            spliterator = streamBasedStreamSource.spliterator;
            onClose = streamBasedStreamSource.onClose;
        } else {
            spliterator = new StreamSourceSpliterator<T, E>(source);
            onClose = Unchecked.runnable(source::close);
        }
        return (Stream)StreamSupport.stream(spliterator, false).onClose(onClose);
    }

    @Override
    public IStreamWithException<T, E> filter(PredicateWithException<? super T, ? extends E> filter) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>(this.delegate.filter(Unchecked.predicate(filter)), this.exceptionType);
    }

    @Override
    public <R> IStreamWithException<R, E> map(FunctionWithException<? super T, ? extends R, ? extends E> mapper) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<R, E>(this.delegate.map(Unchecked.function(mapper)), this.exceptionType);
    }

    @Override
    public <R> IStreamWithException<R, E> flatMap(FunctionWithException<? super T, ? extends IStreamWithException<? extends R, ? extends E>, ? extends E> mapper) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException(this.delegate.flatMap(Unchecked.function(mapper).andThen(stream -> DelegatingStreamWithException.asStream(stream.source()))), this.exceptionType);
    }

    @Override
    public <R> IStreamWithException<R, E> flatMapStream(FunctionWithException<? super T, ? extends Stream<? extends R>, ? extends E> mapper) {
        return this.flatMap(element -> IStreamWithException.wrap((Stream)mapper.apply(element)).withException(this.exceptionType));
    }

    @Override
    public <R> IStreamWithException<R, E> mapMulti(BiConsumerWithException<? super T, Consumer<? super R>, ? extends E> mapper) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<R, E>(this.delegate.mapMulti(Unchecked.biConsumer(mapper)), this.exceptionType);
    }

    @Override
    public IStreamWithException<T, E> distinctBy(FunctionWithException<T, ?, ? extends E> mapper) {
        class Distinction {
            private final Object mapped;
            private final T original;

            private Distinction(DelegatingStreamWithException this$0, T original, Object mapped) {
                this.original = original;
                this.mapped = mapped;
            }

            public boolean equals(Object that) {
                return that != null && this.getClass().equals(that.getClass()) && Objects.equals(this.mapped, ((Distinction)that).mapped);
            }

            public int hashCode() {
                return Objects.hash(this.mapped);
            }
        }
        this.invalidationSupport.invalidate();
        Function<T, ?> uncheckedMapper = Unchecked.function(mapper);
        return new DelegatingStreamWithException<Object, E>(this.delegate.map((? super T e) -> new Distinction(this, e, uncheckedMapper.apply(e))).distinct().map((? super T d) -> d.original), this.exceptionType);
    }

    @Override
    public IStreamWithException<T, E> distinct() {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>(this.delegate.distinct(), this.exceptionType);
    }

    @Override
    public IStreamWithException<T, E> sorted(Comparator<? super T> comparator) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>(this.delegate.sorted(comparator), this.exceptionType);
    }

    @Override
    public IStreamWithException<T, E> peek(ConsumerWithException<? super T, ? extends E> action) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>(this.delegate.peek(Unchecked.consumer(action)), this.exceptionType);
    }

    @Override
    public IStreamWithException<T, E> limit(long maxSize) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>(this.delegate.limit(maxSize), this.exceptionType);
    }

    @Override
    public IStreamWithException<T, E> skip(long n) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>(this.delegate.skip(n), this.exceptionType);
    }

    @Override
    public IStreamWithException<List<T>, E> batch(final int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize (%d) must be greater than zero".formatted(batchSize));
        }
        final IStreamSource<T, E> original = this.source();
        IStreamSource batchingStreamSource = new IStreamSource<List<T>, E>(this){

            @Override
            public boolean tryAdvance(Consumer<? super List<T>> action) throws Exception {
                ArrayList batch = new ArrayList(batchSize);
                while (original.tryAdvance(batch::add) && batch.size() < batchSize) {
                }
                if (batch.isEmpty()) {
                    return false;
                }
                action.accept(batch);
                return true;
            }

            @Override
            public Class<E> exceptionType() {
                return original.exceptionType();
            }

            @Override
            public void close() throws Exception {
                original.close();
            }
        };
        return new DelegatingStreamWithException<T, E>(batchingStreamSource);
    }

    @Override
    public <U> IStreamWithException<Pair<T, U>, E> zip(IStreamWithException<U, E> other) {
        final IStreamSource<T, E> first = this.source();
        final IStreamSource<U, E> second = other.source();
        IStreamSource zippingStreamSource = new IStreamSource<Pair<T, U>, E>(this){

            @Override
            public boolean tryAdvance(Consumer<? super Pair<T, U>> action) throws Exception {
                AtomicReference firstElement = new AtomicReference();
                AtomicReference secondElement = new AtomicReference();
                boolean hasFirst = first.tryAdvance(firstElement::set);
                boolean hasSecond = second.tryAdvance(secondElement::set);
                if (!hasFirst && !hasSecond) {
                    return false;
                }
                if (!hasFirst || !hasSecond) {
                    throw new IllegalStateException("Zip: One stream has ended earlier than the other.");
                }
                action.accept(new Pair(firstElement.get(), secondElement.get()));
                return true;
            }

            @Override
            public Class<E> exceptionType() {
                return first.exceptionType();
            }

            @Override
            public void close() throws Exception {
                try {
                    first.close();
                }
                finally {
                    second.close();
                }
            }
        };
        return new DelegatingStreamWithException<T, E>(zippingStreamSource);
    }

    @Override
    public IIteratorWithException<T, E> toIterator() {
        final IStreamSource<T, E> streamSource = this.source();
        return new IIteratorWithException<T, E>(){
            private T nextElement = null;
            private boolean hasNextElement = false;
            private boolean nextElementFetched = false;
            private boolean closed = false;

            @Override
            public boolean hasNext() throws Exception {
                if (this.closed) {
                    return false;
                }
                if (!this.nextElementFetched) {
                    this.fetchNext();
                }
                return this.hasNextElement;
            }

            @Override
            public T next() throws Exception {
                if (this.closed) {
                    throw new NoSuchElementException("Iterator has been closed");
                }
                if (!this.nextElementFetched) {
                    this.fetchNext();
                }
                Object element = this.nextElement;
                this.nextElement = null;
                this.nextElementFetched = false;
                return element;
            }

            @Override
            public void close() throws Exception {
                if (!this.closed) {
                    this.closed = true;
                    streamSource.close();
                }
            }

            private void fetchNext() throws Exception {
                AtomicReference ref = new AtomicReference();
                this.hasNextElement = streamSource.tryAdvance(ref::set);
                this.nextElement = this.hasNextElement ? ref.get() : null;
                this.nextElementFetched = true;
            }
        };
    }

    @Override
    public IStreamWithException<T, E> afterTerminal(RunnableWithException<? extends E> terminalHandler) {
        this.invalidationSupport.invalidate();
        return new DelegatingStreamWithException<T, E>((Stream)this.delegate.onClose(Unchecked.runnable(terminalHandler)), this.exceptionType);
    }

    @Override
    public Object[] toArray() throws E {
        return this.terminateWithResult(this.delegate::toArray);
    }

    @Override
    public T[] toArray(IntFunction<T[]> generator) throws E {
        return this.terminateWithResult(() -> this.delegate.toArray(generator));
    }

    @Override
    public void forEach(ConsumerWithException<? super T, ? extends E> action) throws E {
        this.terminateWithResult(() -> {
            this.delegate.forEach(Unchecked.consumer(action));
            return null;
        });
    }

    @Override
    public T reduce(T identity, BiFunctionWithException<T, T, T, ? extends E> accumulator) throws E {
        return (T)this.terminateWithResult(() -> this.delegate.reduce(identity, Unchecked.biFunction(accumulator)::apply));
    }

    @Override
    public Optional<T> reduce(BiFunctionWithException<T, T, T, ? extends E> accumulator) throws E {
        return this.terminateWithResult(() -> this.delegate.reduce(Unchecked.biFunction(accumulator)::apply));
    }

    @Override
    public <U> U reduce(U identity, BiFunctionWithException<U, ? super T, U, ? extends E> accumulator, BiFunctionWithException<U, U, U, ? extends E> combiner) throws E {
        return (U)this.terminateWithResult(() -> this.delegate.reduce(identity, Unchecked.biFunction(accumulator), Unchecked.biFunction(combiner)::apply));
    }

    @Override
    public <R> R collect(SupplierWithException<R, ? extends E> supplier, BiConsumerWithException<R, ? super T, ? extends E> accumulator, BiConsumerWithException<R, R, ? extends E> combiner) throws E {
        return (R)this.terminateWithResult(() -> this.delegate.collect(Unchecked.supplier(supplier), Unchecked.biConsumer(accumulator), Unchecked.biConsumer(combiner)));
    }

    @Override
    public <R, A> R collect(ICollectorWithException<? super T, A, R, ? extends E> collector) throws E {
        return (R)this.terminateWithResult(() -> this.delegate.collect(Unchecked.collector(collector)));
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) throws E {
        return this.terminateWithResult(() -> this.delegate.min(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) throws E {
        return this.terminateWithResult(() -> this.delegate.max(comparator));
    }

    @Override
    public long count() throws E {
        return this.terminateWithResult(this.delegate::count);
    }

    @Override
    public boolean anyMatch(PredicateWithException<? super T, ? extends E> predicate) throws E {
        return this.terminateWithResult(() -> this.delegate.anyMatch(Unchecked.predicate(predicate)));
    }

    @Override
    public boolean allMatch(PredicateWithException<? super T, ? extends E> predicate) throws E {
        return this.terminateWithResult(() -> this.delegate.allMatch(Unchecked.predicate(predicate)));
    }

    @Override
    public boolean noneMatch(PredicateWithException<? super T, ? extends E> predicate) throws E {
        return this.terminateWithResult(() -> this.delegate.noneMatch(Unchecked.predicate(predicate)));
    }

    @Override
    public Optional<T> findFirst() throws E {
        return this.terminateWithResult(this.delegate::findFirst);
    }

    @Override
    public Optional<T> findAny() throws E {
        return this.terminateWithResult(this.delegate::findAny);
    }

    @Override
    public IStreamSource<T, E> source() {
        this.invalidationSupport.invalidate();
        Spliterator spliterator = this.delegate.spliterator();
        return new SpliteratorBasedStreamSource(spliterator, this.delegate::close, this.exceptionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R terminateWithResult(Supplier<R> resultProvider) throws E {
        this.invalidationSupport.invalidate();
        InternalException suppressing = null;
        try {
            R r = resultProvider.get();
            return r;
        }
        catch (InternalException e) {
            suppressing = e;
            Object r = InternalException.unwrapAndThrow(e, this.exceptionType);
            return r;
        }
        finally {
            this.closeDelegate(suppressing);
        }
    }

    private void closeDelegate(@Nullable InternalException suppressing) throws E {
        try {
            this.delegate.close();
        }
        catch (InternalException e) {
            if (suppressing != null) {
                InternalException.unwrapAndThrow(suppressing, this.exceptionType, e);
            }
            InternalException.unwrapAndThrow(e, this.exceptionType);
        }
    }

    private static final class InvalidationSupport {
        private final AtomicBoolean invalidated = new AtomicBoolean();

        private InvalidationSupport() {
        }

        private void invalidate() {
            if (this.invalidated.getAndSet(true)) {
                throw new IllegalStateException("Already invalidated");
            }
        }
    }

    private record SpliteratorBasedStreamSource<T, E extends Exception>(Spliterator<T> spliterator, Runnable onClose, Class<E> exceptionType) implements IStreamSource<T, E>
    {
        @Override
        public boolean tryAdvance(Consumer<? super T> action) throws E {
            try {
                return this.spliterator.tryAdvance(action);
            }
            catch (InternalException ex) {
                return (Boolean)InternalException.unwrapAndThrow(ex, this.exceptionType);
            }
        }

        @Override
        public void close() throws E {
            try {
                this.onClose.run();
            }
            catch (InternalException e) {
                InternalException.unwrapAndThrow(e, this.exceptionType);
            }
        }

        @Override
        public long estimateSize() throws E {
            try {
                return this.spliterator.estimateSize();
            }
            catch (InternalException e) {
                return (Long)InternalException.unwrapAndThrow(e, this.exceptionType);
            }
        }

        @Override
        public long getExactSizeIfKnown() throws E {
            try {
                return this.spliterator.getExactSizeIfKnown();
            }
            catch (InternalException e) {
                return (Long)InternalException.unwrapAndThrow(e, this.exceptionType);
            }
        }

        @Override
        public int characteristics() throws E {
            try {
                return this.spliterator.characteristics();
            }
            catch (InternalException e) {
                return (Integer)InternalException.unwrapAndThrow(e, this.exceptionType);
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.spliterator.getComparator();
        }
    }

    private record StreamSourceSpliterator<R, E extends Exception>(IStreamSource<R, E> source) implements Spliterator<R>
    {
        @Override
        public boolean tryAdvance(Consumer<? super R> action) {
            try {
                return this.source.tryAdvance(action);
            }
            catch (Exception ex) {
                return (Boolean)InternalException.wrap(ex);
            }
        }

        @Override
        public Spliterator<R> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            try {
                return this.source.estimateSize();
            }
            catch (Exception ex) {
                return (Long)InternalException.wrap(ex);
            }
        }

        @Override
        public int characteristics() {
            try {
                return this.source.characteristics();
            }
            catch (Exception ex) {
                return (Integer)InternalException.wrap(ex);
            }
        }

        @Override
        public long getExactSizeIfKnown() {
            try {
                return this.source.getExactSizeIfKnown();
            }
            catch (Exception ex) {
                return (Long)InternalException.wrap(ex);
            }
        }

        @Override
        public Comparator<? super R> getComparator() {
            return this.source.getComparator();
        }
    }

    private static final class Unchecked {
        private Unchecked() {
            throw new AssertionError((Object)"Utility class");
        }

        private static <T, E extends Exception> Predicate<T> predicate(PredicateWithException<? super T, ? extends E> predicateWithException) {
            return e -> {
                try {
                    return predicateWithException.test(e);
                }
                catch (Exception ex) {
                    return (Boolean)InternalException.wrap(ex);
                }
            };
        }

        private static <T, R, E extends Exception> Function<T, R> function(FunctionWithException<? super T, ? extends R, ? extends E> functionWithException) {
            return e -> {
                try {
                    return functionWithException.apply(e);
                }
                catch (Exception ex) {
                    return InternalException.wrap(ex);
                }
            };
        }

        private static <T1, T2, R, E extends Exception> BiFunction<T1, T2, R> biFunction(BiFunctionWithException<? super T1, ? super T2, ? extends R, ? extends E> biFunctionWithException) {
            return (e1, e2) -> {
                try {
                    return biFunctionWithException.apply(e1, e2);
                }
                catch (Exception ex) {
                    return InternalException.wrap(ex);
                }
            };
        }

        private static <T, E extends Exception> Consumer<T> consumer(ConsumerWithException<? super T, ? extends E> consumerWithException) {
            return e -> {
                try {
                    consumerWithException.accept(e);
                }
                catch (Exception ex) {
                    InternalException.wrap(ex);
                }
            };
        }

        private static <E extends Exception> Runnable runnable(RunnableWithException<? extends E> runnableWithException) {
            return () -> {
                try {
                    runnableWithException.run();
                }
                catch (Exception ex) {
                    InternalException.wrap(ex);
                }
            };
        }

        private static <T1, T2, E extends Exception> BiConsumer<T1, T2> biConsumer(BiConsumerWithException<? super T1, ? super T2, ? extends E> biConsumerWithException) {
            return (e1, e2) -> {
                try {
                    biConsumerWithException.accept(e1, e2);
                }
                catch (Exception ex) {
                    InternalException.wrap(ex);
                }
            };
        }

        private static <R, E extends Exception> Supplier<R> supplier(SupplierWithException<R, ? extends E> supplierWithException) {
            return () -> {
                try {
                    return supplierWithException.get();
                }
                catch (Exception ex) {
                    return InternalException.wrap(ex);
                }
            };
        }

        private static <T, A, R, E extends Exception> Collector<T, A, R> collector(final ICollectorWithException<? super T, A, R, ? extends E> collectorWithException) {
            return new Collector<T, A, R>(){

                @Override
                public Supplier<A> supplier() {
                    return Unchecked.supplier((SupplierWithException)Unchecked.supplier(collectorWithException::supplier).get());
                }

                @Override
                public BiConsumer<A, T> accumulator() {
                    return Unchecked.biConsumer((BiConsumerWithException)Unchecked.supplier(collectorWithException::accumulator).get());
                }

                @Override
                public BinaryOperator<A> combiner() {
                    return Unchecked.biFunction((BiFunctionWithException)Unchecked.supplier(collectorWithException::combiner).get())::apply;
                }

                @Override
                public Function<A, R> finisher() {
                    return Unchecked.function((FunctionWithException)Unchecked.supplier(collectorWithException::finisher).get());
                }

                @Override
                public Set<Collector.Characteristics> characteristics() {
                    return collectorWithException.characteristics();
                }
            };
        }
    }

    private static final class InternalException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private InternalException(Throwable cause) {
            super(cause);
        }

        private static <R> @NonNull R wrap(Throwable throwable) throws InternalException {
            if (throwable instanceof InternalException) {
                InternalException internalException = (InternalException)throwable;
                throw internalException;
            }
            throw new InternalException(throwable);
        }

        private static <R, E extends Throwable> @NonNull R unwrapAndThrow(InternalException internalException, Class<E> throwableType) throws E {
            return InternalException.unwrapAndThrow(internalException, throwableType, null);
        }

        private static <R, E extends Throwable> @NonNull R unwrapAndThrow(InternalException internalException, Class<E> throwableType, @Nullable InternalException suppressed) throws E {
            Throwable cause = internalException.getCause();
            InternalException.addSuppressed(cause, internalException, null);
            if (suppressed != null) {
                InternalException.addSuppressed(cause, suppressed, suppressed.getCause());
            }
            if (throwableType.isInstance(cause)) {
                throw (Throwable)throwableType.cast(cause);
            }
            if (cause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)cause;
                throw runtimeException;
            }
            throw (ClassCastException)ExceptionUtils.withSuppressed((Throwable)new ClassCastException("Checked Exception of type %s is different from the excepted Exception type %s".formatted(cause.getClass(), throwableType)), (Throwable)cause);
        }

        private static void addSuppressed(Throwable into, InternalException internalException, @Nullable Throwable suppressed) {
            if (suppressed != null) {
                into.addSuppressed(suppressed);
            }
            for (Throwable furtherSuppressed : internalException.getSuppressed()) {
                if (furtherSuppressed instanceof InternalException) {
                    InternalException suppressedInternalException = (InternalException)furtherSuppressed;
                    InternalException.addSuppressed(into, suppressedInternalException, suppressedInternalException.getCause());
                    continue;
                }
                into.addSuppressed(furtherSuppressed);
            }
        }
    }
}

