/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.ai;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsDescriptionOverrideCache;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.ai.findings.AiFindingResolutionEngine;
import com.teamscale.index.ai.findings.EAiFindingResolutionPromptGenerator;
import com.teamscale.index.ai.findings.FindingResolutionException;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.FindingTypeDescriptorService;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.resource.TokenElementServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.diff.DiffDescription;
import org.conqat.lib.commons.diff.LineBasedDiffer;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/ai/{engine}/findings/{id}")
public class FindingAiService
extends ApiBase {
    private static final int CONTEXT_LINES = 7;

    @GET
    @Operation(summary="Get an AI generated finding resolution suggestion", description="Retrieves the AI generated resolution for a finding.", tags={"Findings"})
    @Path(value="resolution")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public FindingResolutionResult getAiFindingResolution(@Parameter(description="The name of the configured AI engine to use.") @PathParam(value="engine") String engine, @Parameter(description="The id of the finding to find a resolution for.") @PathParam(value="id") String findingId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, ServiceCallException {
        TrackedFinding finding = this.retrieveTrackedFinding(findingId, commit);
        if (!(finding.getLocation() instanceof TextRegionLocation)) {
            throw new BadRequestException("Method is only supported for findings with text region location!");
        }
        if (finding.getGroupName().equals("Code Clones")) {
            throw new BadRequestException("This feature is currently not supported for code clone findings.");
        }
        TokenElementInfo element = this.retrieveTokenElementInfo(commit, finding);
        AiFindingResolutionEngine resolutionEngine = new AiFindingResolutionEngine((prompt, observabilityMonitor) -> this.serviceInfo.getAiEngineProvider().complete(engine, prompt), EAiFindingResolutionPromptGenerator.DEFAULT, null);
        try {
            String newElementContent = resolutionEngine.suggestResolution(finding, element, this.getFindingTypeDescription(finding));
            return FindingAiService.trimAndConvertResolution(element, newElementContent);
        }
        catch (FindingResolutionException e) {
            return FindingResolutionResult.error(e.getMessage());
        }
    }

    private static @NonNull FindingResolutionResult trimAndConvertResolution(TokenElementInfo element, String newElementContent) {
        int newLastLine;
        int firstLine;
        List oldLines = StringUtils.splitLinesAsList((String)element.getText());
        List newLines = StringUtils.splitLinesAsList((String)newElementContent);
        for (firstLine = 0; firstLine < oldLines.size() && firstLine < newLines.size() && ((String)oldLines.get(firstLine)).equals(newLines.get(firstLine)); ++firstLine) {
        }
        int oldLastLine = oldLines.size() - 1;
        for (newLastLine = newLines.size() - 1; oldLastLine >= 0 && newLastLine >= 0 && ((String)oldLines.get(oldLastLine)).equals(newLines.get(newLastLine)); --oldLastLine, --newLastLine) {
        }
        if (oldLastLine < firstLine || newLastLine < firstLine) {
            return FindingResolutionResult.error("AI resolution did not find a valid solution");
        }
        firstLine = Math.max(0, firstLine - 7);
        oldLastLine = Math.min(oldLines.size() - 1, oldLastLine + 7);
        newLastLine = Math.min(oldLines.size() - 1, newLastLine + 7);
        String oldPartialContent = StringUtils.concat(oldLines.subList(firstLine, oldLastLine), (String)"\n");
        String newPartialContent = StringUtils.concat(newLines.subList(firstLine, newLastLine), (String)"\n");
        DiffDescription diff = new LineBasedDiffer(false).performDiff((Object)oldPartialContent, (Object)newPartialContent);
        return new FindingResolutionResult(null, FindingAiService.convertToTokenElementInfo(oldPartialContent, element), FindingAiService.convertToTokenElementInfo(newPartialContent, element), firstLine, diff);
    }

    private @NonNull TrackedFinding retrieveTrackedFinding(String findingId, UnresolvedCommitDescriptor commit) throws StorageException {
        TrackedFinding finding = this.openProjectIndex(TrackedFindingsByIdIndex.class, this.determineHistoryOption(commit)).getFinding(findingId);
        if (finding == null) {
            throw new NotFoundException("No finding with id " + findingId + " found!");
        }
        return finding;
    }

    private @NonNull TokenElementInfo retrieveTokenElementInfo(UnresolvedCommitDescriptor commit, TrackedFinding finding) throws StorageException {
        TokenElementInfo element = TokenElementServiceUtils.retrieveElement(UniformPathCompatibilityUtil.convert((String)finding.getLocation().getUniformPath()), (ProjectStorageSystem)this.getProjectStorageSystem(), this.determineHistoryOption(commit));
        if (element == null) {
            throw new NotFoundException("Referenced element " + finding.getLocation().getUniformPath() + " not found!");
        }
        return element;
    }

    private FindingTypeDescription getFindingTypeDescription(TrackedFinding finding) throws StorageException {
        FindingsSchemaIndex findingsSchemaIndex = this.openProjectIndex(FindingsSchemaIndex.class, null);
        SynchronizedCacheAccess cacheAccess = this.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(FindingsDescriptionOverrideCache.class);
        FindingTypeDescription findingTypeDescription = (FindingTypeDescription)findingsSchemaIndex.getFindingTypeDescriptions(List.of(finding.getTypeId()), finding.getCodeScopeName()).get(finding.getTypeId());
        return FindingTypeDescriptorService.getFindingTypeDescriptionNullSafe(finding.getTypeId(), findingTypeDescription, (SynchronizedCacheAccess<FindingsDescriptionOverrideCache>)cacheAccess);
    }

    private static FormattedTokenElementInfo convertToTokenElementInfo(String newContent, TokenElementInfo element) {
        TokenElementInfo elementInfo = new TokenElementInfo(element.getUniformPath(), element.getLanguage(), element.getIsFileLanguageSetByUser(), newContent, List.of(), List.of(), List.of(), null);
        return new FormattedTokenElementInfo(elementInfo, Set.of());
    }

    public record FindingResolutionResult(@Nullable String error, @Nullable FormattedTokenElementInfo oldCode, @Nullable FormattedTokenElementInfo newCode, int lineOffset, @Nullable DiffDescription diff) {
        static FindingResolutionResult error(String message) {
            return new FindingResolutionResult(message, null, null, 0, null);
        }
    }
}

