/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@Path(value="api/validate-regex")
public class RegExValidationService {
    @GET
    @RequiresNoPermission
    @Operation(summary="Validate RegEx", description="Validates the given regex.", responses={@ApiResponse(responseCode="200", description="Returned when the given regex is an invalid RegEx in Java. The response contains the error message."), @ApiResponse(responseCode="204", description="Returned when the given regex is a valid RegEx in Java.")}, tags={"Architecture"})
    public String validateRegex(@Parameter(description="The regex that should be checked") @QueryParam(value="regex") String regex) {
        try {
            Pattern.compile(regex);
            return null;
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
    }
}

