/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commit_trees.debug;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.committree.ICommitTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;

public class CommitTreeNodeData {
    @JsonProperty(value="adjustedTimestamp")
    private final long adjustedTimestamp;
    @JsonProperty(value="originalTimestamp")
    private final long originalTimestamp;
    @JsonProperty(value="branch")
    private final String branch;
    @JsonProperty(value="commit")
    final CommitDescriptor commit;
    @JsonProperty(value="revision")
    private final String revision;
    @JsonProperty(value="state")
    private final String state;
    @JsonProperty(value="parents")
    private final List<String> parents = new ArrayList<String>();

    public CommitTreeNodeData(ICommitTreeNode node) {
        this.revision = node.getRevision().getRevision();
        this.adjustedTimestamp = node.getAdjustedTimestamp().orElse(-1L);
        this.originalTimestamp = node.getOriginalTimestamp();
        this.branch = node.getBranchName();
        this.commit = new CommitDescriptor(this.branch, this.adjustedTimestamp);
        this.state = node.getState().toString();
        node.getParentRevisions().forEach(parent -> this.parents.add(parent.getRevision()));
    }
}

