/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.layout;

import com.teamscale.service.documentation.layout.LayoutBase;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class Layouter {
    private final StringBuilder layoutedText = new StringBuilder();
    protected final LayoutBase layout;

    public Layouter(LayoutBase layout) {
        this.layout = layout;
    }

    public void clear() {
        this.layoutedText.setLength(0);
    }

    public String getLayoutedText() {
        return this.layoutedText.toString();
    }

    public String colorize(String s, ETrafficLightColor color) {
        return this.layout.colorize(s, color);
    }

    public String escape(String s) {
        return this.layout.escape(s);
    }

    public void append(String s) {
        this.layoutedText.append(this.layout.plainText(s));
    }

    public void appendNewLine() {
        this.layoutedText.append(this.layout.newLine());
    }

    public void appendNewParagraph() {
        this.layoutedText.append(this.layout.newParagraph());
    }

    public void appendHeading(String s, int level) {
        this.layoutedText.append(this.layout.heading(s, level));
    }

    public void appendTableStart() {
        this.layoutedText.append(this.layout.startTable());
    }

    public void appendTableHeader(String ... titles) {
        this.layoutedText.append(this.layout.tableHeader(titles));
    }

    public void appendTableHorizontalLine(int numberOfCells) {
        this.layoutedText.append(this.layout.tableHorizontalLine(numberOfCells));
    }

    public void appendTableRow(String ... cells) {
        this.layoutedText.append(this.layout.tableRow(cells));
    }

    public void appendTableEnd() {
        this.layoutedText.append(this.layout.endTable());
    }

    public void appendBulletListStart() {
        this.layoutedText.append(this.layout.startBulletList());
    }

    public void appendBullet(String s, int level) {
        this.layoutedText.append(this.layout.makeBullet(s, level));
    }

    public void appendBulletListEnd() {
        this.layoutedText.append(this.layout.endBulletList());
    }

    public void appendItalic(String s) {
        this.layoutedText.append(this.layout.makeItalic(s));
    }

    public void appendBold(String s) {
        this.layoutedText.append(this.layout.makeBold(s));
    }

    public void appendColorized(String s, ETrafficLightColor color) {
        this.layoutedText.append(this.layout.colorize(s, color));
    }

    public void appendEscaped(String s) {
        this.layoutedText.append(this.layout.escape(s));
    }
}

