/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.properties;

import com.teamscale.index.external.properties.ExternalPropertiesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.properties.IExternalPropertiesServiceApi;
import jakarta.ws.rs.Path;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/external-properties")
public class ExternalPropertiesService
extends ApiBase
implements IExternalPropertiesServiceApi {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public @Nullable Long getFindingDueDate(String findingId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        return index.getDueDate(findingId);
    }

    @Override
    public void setFindingDueDate(String findingId, long dueDate) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setDueDate(findingId, dueDate);
    }

    @Override
    public void setFindingDueDates(Map<String, Long> dueDates) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setDueDates(dueDates);
    }

    @Override
    public void deleteFindingDueDate(String findingId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        if (index.getDueDate(findingId) == null) {
            LOGGER.warn("Attempted to delete non-existent due date for finding ID: {}", (Object)findingId);
            return;
        }
        index.deleteDueDate(findingId);
    }

    @Override
    public Map<String, String> getFindingGenericProperties(String findingId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        return index.getGenericProperties(findingId).toMap();
    }

    @Override
    public void setFindingGenericProperties(String findingId, Map<String, String> properties) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setGenericProperties(findingId, new PairList(properties));
    }

    @Override
    public void setMultipleFindingGenericProperties(Map<String, Map<String, String>> properties) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setGenericPropertiesMultiple(properties);
    }

    @Override
    public void deleteFindingGenericProperties(String findingId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.deleteGenericProperties(findingId);
    }

    @Override
    public @Nullable Long getViolationDueDate(String violationId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        return index.getDueDate(violationId);
    }

    @Override
    public void setViolationDueDate(String violationId, long dueDate) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setDueDate(violationId, dueDate);
    }

    @Override
    public void setViolationDueDates(Map<String, Long> dueDates) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setDueDates(dueDates);
    }

    @Override
    public void deleteViolationDueDate(String violationId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        if (index.getDueDate(violationId) == null) {
            LOGGER.warn("Attempted to delete non-existent due date for violation ID: {}", (Object)violationId);
            return;
        }
        index.deleteDueDate(violationId);
    }

    @Override
    public Map<String, String> getViolationGenericProperties(String violationId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        return index.getGenericProperties(violationId).toMap();
    }

    @Override
    public void setViolationGenericProperties(String violationId, Map<String, String> properties) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setGenericProperties(violationId, new PairList(properties));
    }

    @Override
    public void setViolationGenericProperties(Map<String, Map<String, String>> properties) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.setGenericPropertiesMultiple(properties);
    }

    @Override
    public void deleteViolationGenericProperties(String violationId) throws StorageException {
        ExternalPropertiesIndex index = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        index.deleteGenericProperties(violationId);
    }
}

