/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.tracking.FindingChurnList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;

public class FindingChurnListDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMIT_PROPERTY = "commit";
    private static final String ADDED_FINDINGS_PROPERTY = "addedFindings";
    private static final String FINDINGS_ADDED_IN_BRANCH_PROPERTY = "findingsAddedInBranch";
    private static final String FINDINGS_IN_CHANGED_CODE_PROPERTY = "findingsInChangedCode";
    private static final String REMOVED_FINDINGS_PROPERTY = "removedFindings";
    private static final String FINDINGS_REMOVED_IN_BRANCH_PROPERTY = "findingsRemovedInBranch";
    @JsonIgnore
    private final int maxSize;
    private final CommitDescriptor commit;
    private final List<TrackedFinding> addedFindings;
    private final List<TrackedFinding> findingsAddedInBranch;
    private final List<TrackedFinding> findingsInChangedCode;
    private final List<TrackedFinding> removedFindings;
    private final List<TrackedFinding> findingsRemovedInBranch;

    @JsonCreator
    private FindingChurnListDto(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="addedFindings") List<TrackedFinding> addedFindings, @JsonProperty(value="findingsAddedInBranch") List<TrackedFinding> findingsAddedInBranch, @JsonProperty(value="findingsInChangedCode") List<TrackedFinding> findingsInChangedCode, @JsonProperty(value="removedFindings") List<TrackedFinding> removedFindings, @JsonProperty(value="findingsRemovedInBranch") List<TrackedFinding> findingsRemovedInBranch) {
        this(Integer.MAX_VALUE, commit, addedFindings, findingsAddedInBranch, findingsInChangedCode, removedFindings, findingsRemovedInBranch);
    }

    private FindingChurnListDto(int maxSize, CommitDescriptor commit, List<TrackedFinding> addedFindings, List<TrackedFinding> findingsAddedInBranch, List<TrackedFinding> findingsInChangedCode, List<TrackedFinding> removedFindings, List<TrackedFinding> findingsRemovedInBranch) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize (%d) must not be negative".formatted(maxSize));
        }
        this.maxSize = maxSize;
        this.commit = Objects.requireNonNull(commit, COMMIT_PROPERTY);
        this.addedFindings = Objects.requireNonNull(addedFindings, ADDED_FINDINGS_PROPERTY);
        this.findingsAddedInBranch = Objects.requireNonNull(findingsAddedInBranch, FINDINGS_ADDED_IN_BRANCH_PROPERTY);
        this.findingsInChangedCode = Objects.requireNonNull(findingsInChangedCode, FINDINGS_IN_CHANGED_CODE_PROPERTY);
        this.removedFindings = Objects.requireNonNull(removedFindings, REMOVED_FINDINGS_PROPERTY);
        this.findingsRemovedInBranch = Objects.requireNonNull(findingsRemovedInBranch, FINDINGS_REMOVED_IN_BRANCH_PROPERTY);
    }

    public static FindingChurnListDto empty(CommitDescriptor commit) {
        return new FindingChurnListDto(0, commit, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static FindingChurnListDto of(FindingChurnList findingChurnList) {
        Objects.requireNonNull(findingChurnList, "findingChurnList");
        return new FindingChurnListDto(Integer.MAX_VALUE, findingChurnList.getCommit(), (List<TrackedFinding>)findingChurnList.getAddedFindings(), (List<TrackedFinding>)findingChurnList.getFindingsAddedInBranch(), (List<TrackedFinding>)findingChurnList.getFindingsInChangedCode(), (List<TrackedFinding>)findingChurnList.getRemovedFindings(), (List<TrackedFinding>)findingChurnList.getFindingsRemovedInBranch());
    }

    public FindingChurnListDto withMaxSize(int maxSize) {
        return new FindingChurnListDto(maxSize, this.commit, this.addedFindings, this.findingsAddedInBranch, this.findingsInChangedCode, this.removedFindings, this.findingsRemovedInBranch);
    }

    @JsonGetter(value="commit")
    public CommitDescriptor getCommit() {
        return this.commit;
    }

    @JsonGetter(value="addedFindings")
    public Stream<TrackedFinding> getAddedFindings() {
        return this.addedFindings.stream().limit(this.maxSize);
    }

    @JsonGetter(value="addedFindingsCount")
    public int getAddedFindingsCount() {
        return this.addedFindings.size();
    }

    @JsonGetter(value="findingsAddedInBranch")
    public Stream<TrackedFinding> getFindingsAddedInBranch() {
        return this.findingsAddedInBranch.stream().limit(this.maxSize);
    }

    @JsonGetter(value="findingsAddedInBranchCount")
    public int getFindingsAddedInBranchCount() {
        return this.findingsAddedInBranch.size();
    }

    @JsonGetter(value="findingsInChangedCode")
    public Stream<TrackedFinding> getFindingsInChangedCode() {
        return this.findingsInChangedCode.stream().limit(this.maxSize);
    }

    @JsonGetter(value="findingsInChangedCodeCount")
    public int getFindingsInChangedCodeCount() {
        return this.findingsInChangedCode.size();
    }

    @JsonGetter(value="removedFindings")
    public Stream<TrackedFinding> getRemovedFindings() {
        return this.removedFindings.stream().limit(this.maxSize);
    }

    @JsonGetter(value="removedFindingsCount")
    public int getRemovedFindingsCount() {
        return this.removedFindings.size();
    }

    @JsonGetter(value="findingsRemovedInBranch")
    public Stream<TrackedFinding> getFindingsRemovedInBranch() {
        return this.findingsRemovedInBranch.stream().limit(this.maxSize);
    }

    @JsonGetter(value="findingsRemovedInBranchCount")
    public int getFindingsRemovedInBranchCount() {
        return this.findingsRemovedInBranch.size();
    }
}

