/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.model.IssueUserResolution;
import com.teamscale.index.issues.model.UserResolvedTeamscaleIssue;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.autocomplete.EntityFilterHelper;
import com.teamscale.service.autocomplete.PrefixPriorityComparator;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.issues.TeamscaleUserAliasResolver;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/issues")
public class IssueService
extends ApiBase {
    public static final String TEAMSCALE_ISSUE_ID_PARAMETER_FORMAT_DESCRIPTION = "The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".";
    public static final String COMPATIBILITY_ISSUE_ID_PARAMETER_FORMAT_DESCRIPTION = "The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.";

    @GET
    @Operation(summary="Get issue", description="Retrieves an issue by ID.", tags={"Issues"}, responses={@ApiResponse(responseCode="404", description="The issue with given ID could not be found."), @ApiResponse(responseCode="409", description="Multiple issues for the given ID were found for different connectors.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{issueId}")
    public UserResolvedTeamscaleIssue getIssue(@Parameter(description="ID of the issue to retrieve. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId) throws StorageException {
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        Optional issue = IssueUtils.getSingleIssueForId((IssueIndexBase)issueIndex, (String)issueId, (boolean)true);
        if (issue.isEmpty()) {
            throw new NotFoundException("The issue with ID '" + issueId + "' could not be found!");
        }
        IssueUserResolution resolution = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem())).resolveIssue((TeamscaleIssue)issue.get());
        return new UserResolvedTeamscaleIssue((TeamscaleIssue)issue.get(), resolution);
    }

    @GET
    @Operation(summary="Get issues details", description="Retrieves issue details by their IDs. Unknown issue IDs will cause 'null' entries in the result", tags={"Issues"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="details")
    public List<@Nullable UserResolvedTeamscaleIssue> getIssuesDetails(@Parameter(description="IDs of the issues to retrieve. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".") @QueryParam(value="issue-ids") List<String> issueIds) throws StorageException {
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        List issueDetails = issueIndex.getIssuesForInternalIds(issueIds);
        List<IssueUserResolution> resolutions = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem())).resolveIssues(issueDetails);
        return UserResolvedTeamscaleIssue.of((List)issueDetails, resolutions);
    }

    @GET
    @Path(value="count")
    @Operation(summary="Get issue count", description="Retrieves the overall issue count.", tags={"Issues"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public int getIssueCount() throws StorageException {
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        return issueIndex.getIssueCount();
    }

    @GET
    @Path(value="find")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get autocompletion suggestions", description="Gets autocompletion suggestions based on the input")
    public Collection<String> autocompleteIssueId(@QueryParam(value="search") String searchQuery) throws StorageException {
        if (StringUtils.isEmpty((String)searchQuery)) {
            return Collections.emptyList();
        }
        EntityFilterHelper<TeamscaleIssueId> entityFilterHelper = new EntityFilterHelper<TeamscaleIssueId>(TeamscaleIssueId::getInternalId);
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        return entityFilterHelper.filter(issueIndex.getAllKeys(), searchQuery, false, 10, new PrefixPriorityComparator<TeamscaleIssueId>(searchQuery, false, issue -> issue.getExternalId() + "|" + issue.getConnectorId(), (Comparator<? super String>)NumbersAwareStringComparator.INSTANCE)).map(TeamscaleIssueId::getInternalId).collect(Collectors.toList());
    }
}

