/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.force_vote;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.merge_request.force_vote.strategy.GerritMergeRequestVoteStrategy;
import com.teamscale.service.merge_request.force_vote.strategy.GitMergeRequestVoteStrategy;
import com.teamscale.service.merge_request.force_vote.strategy.IMergeRequestForceVoteStrategy;
import com.teamscale.service.merge_request.force_vote.strategy.NoOpMergeRequestVoteStrategy;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/merge-requests/re-vote")
public class MergeRequestRevoteService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @Operation(summary="Re-vote on all open merge requests", description="Re-votes on all open merge requests in the project. This can be used to manually trigger voting or commenting.", responses={@ApiResponse(responseCode="400", description="No voting connector is configured for the project"), @ApiResponse(responseCode="502", description="Retrieving open merge requests failed")}, tags={"Debugging", "Merge Requests", "Voting Connectors"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void revoteOnAllOpenMergeRequests() throws StorageException {
        List<ConnectorConfiguration> projectConnectors = this.getAllProjectVotingConnectors();
        if (projectConnectors.isEmpty()) {
            throw new BadRequestException("No voting connectors configured for project " + String.valueOf(this.serviceInfo.getPrimaryPublicId()));
        }
        ArrayList<ConnectorConfiguration> connectorConfigurationsToVoteOn = new ArrayList<ConnectorConfiguration>();
        for (ConnectorConfiguration connectorConfiguration : projectConnectors) {
            if (CcpIntegrationFeatureEnablements.isAnyIntegrationEnabled((ConnectorConfiguration)connectorConfiguration)) {
                connectorConfigurationsToVoteOn.add(connectorConfiguration);
                continue;
            }
            LOGGER.atInfo().log("Voting disabled for {} Connector '{}'. Skipping.", (Object)connectorConfiguration.getRawType(), (Object)connectorConfiguration.getIdentifier());
        }
        if (connectorConfigurationsToVoteOn.isEmpty()) {
            throw new BadRequestException("Could not re-vote on open merge requests. No voting connector with voting enabled was found in project " + String.valueOf(this.serviceInfo.getPrimaryPublicId()));
        }
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        List openMergeRequests = mergeRequestIndex.getAllMergeRequests();
        for (ConnectorConfiguration connectorConfiguration : connectorConfigurationsToVoteOn) {
            IMergeRequestForceVoteStrategy strategy = this.getVotingStrategyForConnector(connectorConfiguration, mergeRequestIndex);
            strategy.forceVoteOnMergeRequests(openMergeRequests, connectorConfiguration);
        }
    }

    @POST
    @Path(value="{idWithRepository}")
    @Operation(summary="Re-vote on a specific open merge request", description="Re-votes on a specific open merge request in the project. This can be used to manually trigger voting or commenting.", responses={@ApiResponse(responseCode="400", description="No voting connector is configured for the project"), @ApiResponse(responseCode="502", description="Retrieving open merge requests failed")}, tags={"Merge Requests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public void revoteOnMergeRequest(@Parameter(description="The unique merge request composite identifier used in Teamscale.\nIt must be composed of the Repository Name (from the connector config), a forward slash (/), and the actual merge request ID.\nExample: If the Repository Name is 'my-project/my-repo' and the merge request ID is 1234, then the required value is 'my-project/my-repo/1234'.") @PathParam(value="idWithRepository") MergeRequestIdentifier identifier) throws StorageException {
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        Optional mergeRequest = mergeRequestIndex.getMergeRequest(identifier);
        if (mergeRequest.isEmpty()) {
            throw new BadRequestException("Merge request with id " + identifier.toString() + " does not exist in project " + String.valueOf(this.serviceInfo.getPrimaryPublicId()));
        }
        Optional<ConnectorConfiguration> correspondingConnector = this.getConnectorCorrespondingToMergeRequest((MergeRequest)mergeRequest.get());
        if (correspondingConnector.isEmpty()) {
            throw new BadRequestException("Could not re-vote on merge request with id " + identifier.toString() + ". A corresponding connector with voting enabled was not found in project " + String.valueOf(this.serviceInfo.getPrimaryPublicId()));
        }
        IMergeRequestForceVoteStrategy strategy = this.getVotingStrategyForConnector(correspondingConnector.get(), mergeRequestIndex);
        strategy.forceVoteOnMergeRequests(List.of((MergeRequest)mergeRequest.get()), correspondingConnector.get());
    }

    private Optional<ConnectorConfiguration> getConnectorCorrespondingToMergeRequest(MergeRequest mergeRequest) throws StorageException {
        Predicate<ConnectorConfiguration> connectorMatchesMergeRequest = connector -> {
            if (!CcpIntegrationFeatureEnablements.isAnyIntegrationEnabled((ConnectorConfiguration)connector)) {
                return false;
            }
            String repositoryName = connector.getOptionValue("Repository name");
            if (repositoryName != null) {
                return mergeRequest.getRepositoryName().equalsIgnoreCase(repositoryName);
            }
            String repoIdentifier = connector.getOptionValue("Repository identifier");
            return mergeRequest.getRepositoryName().equalsIgnoreCase(repoIdentifier);
        };
        return this.getAllProjectVotingConnectors().stream().filter(connectorMatchesMergeRequest).findFirst();
    }

    private List<ConnectorConfiguration> getAllProjectVotingConnectors() throws StorageException {
        MetaIndex projectMetaIndex = this.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration config = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        return CollectionUtils.filter((Collection)config.getConnectors(), VotingConnectorUtils::isVotingConnector);
    }

    private IMergeRequestForceVoteStrategy getVotingStrategyForConnector(ConnectorConfiguration connectorConfiguration, MergeRequestIndex mergeRequestIndex) throws StorageException {
        ERepositoryConnector connector = (ERepositoryConnector)connectorConfiguration.getRepositoryType().orElseThrow(() -> new BadRequestException("Fetching voting strategy failed: Could not find connector of type '%s'.".formatted(connectorConfiguration.getRawType())));
        return switch (connector) {
            case ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST, ERepositoryConnector.AZURE_DEVOPS_GIT, ERepositoryConnector.BITBUCKET, ERepositoryConnector.BITBUCKET_SERVER, ERepositoryConnector.GITEA, ERepositoryConnector.GITHUB, ERepositoryConnector.GITLAB, ERepositoryConnector.SCM_MANAGER -> new GitMergeRequestVoteStrategy(this.serviceInfo.getInternalId(), mergeRequestIndex, this.openCommitDescriptorIndex(), this.getIndexLayer(), LOGGER);
            case ERepositoryConnector.GERRIT -> {
                RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
                RepositoryRevisionIndex repositoryRevisionIndex = this.openProjectIndex(RepositoryRevisionIndex.class, null);
                yield new GerritMergeRequestVoteStrategy(this.serviceInfo.getInternalId(), this.openCommitDescriptorIndex(), repositoryLogIndex, repositoryRevisionIndex, this.getIndexLayer(), LOGGER);
            }
            default -> new NoOpMergeRequestVoteStrategy();
        };
    }
}

