/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/teamscale-toml")
public class TeamscaleTomlExportService
extends ApiBase {
    @VisibleForTesting
    static final String REPOSITORY_ID_PARAMETER_NAME = "repositoryId";
    @VisibleForTesting
    static final String BASIC_TOML_CONFIGURATION = "# Configuration for project %2$s, connector %3$s\n\n# Learn more about the Teamscale IDE Configuration File Format at\n# <https://docs.teamscale.com/reference/teamscale-toml/>.\n\nversion = \"1.0\"\n\nroot = true\n\n[server]\nurl = \"%1$s\"\n\n[project]\nid = \"%2$s\"\n\n";
    @VisibleForTesting
    static final String BRANCH_TOML_CONFIGURATION = "# The value has been set because branch analysis has been deactivated or is not supported by the connector\nbranch = \"%s\" # Optional\n\n";
    @VisibleForTesting
    static final String PATH_TOML_CONFIGURATION = "# The value has been set because the repository identifier gets prepended\npath = \"%s\" # Optional\n\n";
    @VisibleForTesting
    static final String PATH_TRANSFORMATION_CONFIGURATION = "# Warning: The selected source code connector use the \"Path (prefix) transformation\" expert option.\n# Automatic generation of Teamscale IDE configuration files for such connectors is not supported.\n# Please adjust them manually.\n# (Note that, depending on the applied transformations, more than one configuration file may be necessary.)\n\n";

    @GET
    @Produces(value={"text/plain"})
    @PublicApi(since=ETeamscaleVersion.VERSION_9_9_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Export a Teamscale IDE Configuration File", description="Exports a Teamscale IDE Configuration File for the given project and repository, to be used by the IDE plugins.", tags={"Project"})
    public String exportTeamscaleToml(@Parameter(description="Identifier of the repository for which a Teamscale TOML will be generated.") @QueryParam(value="repositoryId") String repositoryId) throws StorageException {
        ConnectorConfiguration connector;
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class);
        if (repositoryId == null) {
            if (projectConfiguration.getConnectors().size() != 1) {
                throw new BadRequestException("The project has more than one connector. Please specify a repository ID.");
            }
            connector = (ConnectorConfiguration)projectConfiguration.getConnectors().stream().findFirst().orElseThrow();
            repositoryId = connector.getIdentifier();
        } else {
            connector = projectConfiguration.getConnectorByIdentifier(repositoryId);
        }
        ERepositoryConnector connectorType = (ERepositoryConnector)connector.getRepositoryType().orElseThrow(() -> new BadRequestException("Connector type '%s' is not supported.".formatted(connector.getRawType())));
        if (connectorType.isIgnoredByPreCommit3()) {
            throw new BadRequestException("The given connector is not supported by pre-commit.");
        }
        if (ERepositoryConnector.ABAP_GIT == connectorType) {
            throw new BadRequestException("Pre-commit with SAP does not support the TOML format.");
        }
        return this.createTeamscaleToml(repositoryId, connector);
    }

    private String createTeamscaleToml(String repositoryId, ConnectorConfiguration connector) throws StorageException {
        StringBuilder toml = new StringBuilder();
        toml.append(String.format(BASIC_TOML_CONFIGURATION, this.serviceInfo.getRequestBaseUri(), this.serviceInfo.getPrimaryPublicId(), repositoryId));
        if (!Boolean.parseBoolean(connector.getOptionValue("Enable branch analysis"))) {
            toml.append(String.format(BRANCH_TOML_CONFIGURATION, this.getDefaultBranchName()));
        }
        if (Boolean.parseBoolean(connector.getOptionValue("Prepend repository identifier"))) {
            toml.append(String.format(PATH_TOML_CONFIGURATION, connector.getIdentifier()));
        }
        String pathPrefixTransformation = connector.getOptionValue("Path prefix transformation");
        String pathTransformation = connector.getOptionValue("Path transformation");
        if (pathPrefixTransformation != null && !pathPrefixTransformation.isBlank() || pathTransformation != null && !pathTransformation.isBlank()) {
            toml.append(PATH_TRANSFORMATION_CONFIGURATION);
        }
        return toml.toString();
    }
}

