/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testcoverage.ProbeCoverageIndex;
import com.teamscale.index.testgap.query.LineCoverageSourceQueryParameters;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import com.teamscale.service.resource.CoverageServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/probe-coverage")
public class ProbeCoverageService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Path(value="{uniformPath: .*}")
    @Operation(summary="Get probe coverage", description="Returns the probe coverage data for an element.", responses={@ApiResponse(responseCode="204", description="No probe coverage is available for the given uniformPath.")}, tags={"Test Coverage"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ProbeCoverageInfo getProbeCoverage(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @QueryParam(value="t") UnresolvedCommitDescriptor commit, @BeanParam LineCoverageSourceQueryParameters coverageSources) throws StorageException {
        List partitions;
        if (CoverageServiceBase.isPathIgnoredForCoverage(uniformPath)) {
            return null;
        }
        ProbeCoverageIndex probeCoverageIndex = this.openProjectIndex(ProbeCoverageIndex.class, this.determineHistoryOption(commit));
        List allCoverageForFile = CollectionUtils.filterNullEntries((Collection)probeCoverageIndex.getAllCoverageForFile(partitions = coverageSources.getPartitions((Collection)probeCoverageIndex.getPartitions()), uniformPath));
        if (allCoverageForFile.isEmpty()) {
            return null;
        }
        return allCoverageForFile.stream().reduce(new ProbeCoverageInfo(true), (coverage1, coverage2) -> {
            if (!coverage1.mergeWith(coverage2)) {
                LOGGER.warn("Found multiple partitions for '{}' containing probe coverage (e.g. MC/DC), which could not be merged trivially. The result might not be accurate.", (Object)uniformPath);
            }
            return coverage1;
        });
    }
}

