/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.search.SearchServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.jspecify.annotations.NonNull;

@Path(value="api/search/autocomplete")
public class SearchAutocompletionService
extends SearchServiceBase {
    @GET
    @Operation(summary="Autocompletion for search field", description="Service that provides possible completions for a query.", tags={"Project", "Issues"})
    @RequiresNoPermission(description="The service will only search among projects visible to current user.")
    public Map<ESearchSuggestionType, List<SearchSuggestion>> getSearchAutocompletionResults(@Parameter(description="The string/query that should be auto-completed.") @QueryParam(value="token") String token, @Parameter(description="The project the search should be restricted to.") @QueryParam(value="project") PublicProjectId project, @Parameter(description="The maximal number of matches to return. Defaults to 10.") @DefaultValue(value="10") @QueryParam(value="max_matches") int maxMatches) throws StorageException {
        this.project = project;
        List<SearchSuggestion> result = this.determineSuggestions(token, maxMatches);
        if (result.size() > maxMatches) {
            result = result.subList(0, maxMatches);
        }
        return result.stream().collect(Collectors.groupingBy(suggestion -> suggestion.type, LinkedHashMap::new, Collectors.toList()));
    }

    private List<SearchSuggestion> determineSuggestions(String searchQuery, int numSuggestions) throws StorageException {
        Set<SearchSuggestion> suggestions;
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        if (searchQuery.startsWith("file:")) {
            suggestions = this.determineFileSuggestions(searchQuery.substring("file:".length()), numSuggestions, projectIndex, true);
        } else if (searchQuery.startsWith("rev:")) {
            suggestions = this.determineRevisionSuggestions(searchQuery.substring("rev:".length()), numSuggestions, projectIndex);
        } else if (searchQuery.startsWith("issue:")) {
            suggestions = this.determineIssueSuggestions(searchQuery.substring("issue:".length()), numSuggestions, projectIndex);
        } else {
            suggestions = this.determineFileSuggestions(searchQuery, numSuggestions, projectIndex, false);
            suggestions.addAll(this.determineRevisionSuggestions(searchQuery, Math.max(0, numSuggestions - suggestions.size()), projectIndex));
            suggestions.addAll(this.determineIssueSuggestions(searchQuery, Math.max(0, numSuggestions - suggestions.size()), projectIndex));
        }
        return CollectionUtils.sort(suggestions);
    }

    public record SearchSuggestion(@JsonProperty(value="type") ESearchSuggestionType type, @JsonProperty(value="project") PublicProjectId project, @JsonProperty(value="title") String title, @JsonProperty(value="full") String full) implements Comparable<SearchSuggestion>
    {
        private static final String TYPE_PROPERTY = "type";
        private static final String PROJECT_PROPERTY = "project";
        private static final String TITLE_PROPERTY = "title";
        private static final String FULL_PROPERTY = "full";

        @Override
        public int compareTo(@NonNull SearchSuggestion o) {
            return Comparator.comparing(suggestion -> suggestion.type).thenComparing(suggestion -> suggestion.full).compare(this, o);
        }

        @Override
        public String toString() {
            return this.full;
        }
    }

    @ExportToTypeScript
    public static enum ESearchSuggestionType {
        FILE,
        TOKEN,
        ISSUE,
        REVISION;

    }
}

