/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.search.result.IResultInfo;
import com.teamscale.service.search.result.SearchHitLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public class SearchResult {
    private static final String TITLE_PROPERTY = "title";
    private static final String URL_PROPERTY = "url";
    private static final String PROJECT_PROPERTY = "project";
    private static final String INFOS_PROPERTY = "infos";
    private static final String HITS_PROPERTY = "hits";
    private static final String FIRST_SEARCH_HIT_LINE_PROPERTY = "firstSearchHitLine";
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="project")
    private final PublicProjectId project;
    @JsonProperty(value="infos")
    protected final List<IResultInfo> infos = new ArrayList<IResultInfo>();
    @JsonProperty(value="hits")
    private final List<SearchHitLocation> hits = new ArrayList<SearchHitLocation>();
    @JsonProperty(value="firstSearchHitLine")
    private @Nullable Integer firstSearchHitLine;

    @JsonCreator
    public SearchResult(@JsonProperty(value="title") String title, @JsonProperty(value="url") String url, @JsonProperty(value="project") PublicProjectId project) {
        this.title = title;
        this.url = url;
        this.project = project;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public PublicProjectId getProject() {
        return this.project;
    }

    public void addInfo(IResultInfo info) {
        this.infos.add(info);
    }

    public void addHit(SearchHitLocation hit) {
        this.hits.add(hit);
    }

    public void setFirstSearchHitLine(@Nullable Integer firstSearchHitLine) {
        this.firstSearchHitLine = firstSearchHitLine;
    }

    public UnmodifiableList<IResultInfo> getInfos() {
        return CollectionUtils.asUnmodifiable(this.infos);
    }

    public int hashCode() {
        if (this.infos.isEmpty()) {
            return Objects.hash(this.title, this.project, this.url, this.firstSearchHitLine, this.infos);
        }
        return Objects.hash(this.title, this.project, this.url, this.firstSearchHitLine, this.infos.get(0));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)obj;
        IResultInfo info = null;
        if (!this.infos.isEmpty()) {
            info = this.infos.get(0);
        }
        IResultInfo otherInfo = null;
        if (!that.infos.isEmpty()) {
            otherInfo = that.infos.get(0);
        }
        return Objects.equals(this.title, that.title) && Objects.equals(this.url, that.url) && Objects.equals(this.project, that.project) && Objects.equals(info, otherInfo) && Objects.equals(this.firstSearchHitLine, that.firstSearchHitLine);
    }
}

