/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.software_composition;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ESoftwareCompositionAnalysisTool;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BlacklistingOption;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingExclusionApprovalOption;
import com.teamscale.index.external.properties.ExternalPropertiesIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.sca.BuildInfo;
import com.teamscale.index.repository.sca.BuildScanResult;
import com.teamscale.index.repository.sca.BuildScanResultWithProperties;
import com.teamscale.index.repository.sca.BuildVersion;
import com.teamscale.index.repository.sca.CompositionViolation;
import com.teamscale.index.repository.sca.IgnoreRuleApprovalState;
import com.teamscale.index.repository.sca.IgnoreViolationRequest;
import com.teamscale.index.repository.sca.IgnoreViolationRule;
import com.teamscale.index.repository.sca.NameWithVersion;
import com.teamscale.index.repository.sca.ViolationWithProperties;
import com.teamscale.index.repository.sca.jfrog.JFrogXrayIndex;
import com.teamscale.index.repository.sca.jfrog.JfrogXrayClient;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import retrofit2.Response;

@Path(value="api/projects/{project}/software-composition")
public class SoftwareCompositionService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Path(value="builds")
    @Operation(summary="Returns the known builds that were synced from Xray", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<BuildInfo> getBuilds() throws IOException, StorageException {
        try {
            JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
            return jFrogXrayIndex.getBuilds();
        }
        catch (StorageException e) {
            List<ConnectorConfiguration> softwareCompositionConnectors = this.getSoftwareCompositionToolConnectorsInProject();
            if (softwareCompositionConnectors.isEmpty()) {
                throw new BadRequestException("No Software Composition Analysis (SCA) connector configured for project", (Throwable)e);
            }
            throw e;
        }
    }

    private @NonNull List<ConnectorConfiguration> getSoftwareCompositionToolConnectorsInProject() throws StorageException {
        ProjectConfiguration projectConfig = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)this.getProjectStorageSystem());
        if (projectConfig == null) {
            return Collections.emptyList();
        }
        return projectConfig.getConnectorsByNames(ESoftwareCompositionAnalysisTool.getReadableNames());
    }

    @GET
    @Path(value="builds/{buildName}")
    @Operation(summary="Returns the known versions for the given build name", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<BuildVersion> getBuildVersions(@PathParam(value="buildName") String buildName) throws StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        return jFrogXrayIndex.getBuildVersions(buildName);
    }

    @GET
    @Path(value="builds/{buildName}/{buildVersion}")
    @Operation(summary="Returns the build details for the given build", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public BuildScanResultWithProperties getBuildDetails(@PathParam(value="buildName") String buildName, @PathParam(value="buildVersion") String buildVersion) throws IOException, StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        List scanResultsForBuilds = jFrogXrayIndex.getScanResultsForBuilds(List.of(new NameWithVersion(buildName, buildVersion)));
        if (scanResultsForBuilds.isEmpty() || scanResultsForBuilds.getFirst() == null) {
            return null;
        }
        BuildScanResult scanForBuild = (BuildScanResult)scanResultsForBuilds.getFirst();
        List<IgnoreViolationRule> ignoreRules = SoftwareCompositionService.getActiveIgnoreRules(jFrogXrayIndex);
        List<CompositionViolation> violations = scanForBuild.violations().stream().filter(violation -> ignoreRules.stream().noneMatch(ignoreRule -> ignoreRule.matches(violation))).toList();
        return new BuildScanResultWithProperties(scanForBuild.lastScanTimestamp(), scanForBuild.vulnerabilities(), this.enrichViolationsWithProperties(violations), scanForBuild.build());
    }

    @GET
    @Path(value="violations")
    @Operation(summary="Returns the violations for each latest build", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<BuildScanResultWithProperties> getCompositionViolations(@QueryParam(value="include-ignored") boolean includeIgnored, @QueryParam(value="include-pending-ignored") boolean includePendingIgnored) throws StorageException {
        List<ConnectorConfiguration> softwareCompositionConnectorsInProject = this.getSoftwareCompositionToolConnectorsInProject();
        if (softwareCompositionConnectorsInProject.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getViolationsForLatestBuildsWithProperties(includeIgnored, includePendingIgnored);
    }

    private List<BuildScanResultWithProperties> getViolationsForLatestBuildsWithProperties(boolean includeIgnored, boolean includePendingIgnored) throws StorageException {
        List<BuildScanResult> scanResults = this.getViolationsForLatestBuilds(includeIgnored, includePendingIgnored);
        Set allViolationIds = scanResults.stream().flatMap(scanResult -> scanResult.violations().stream()).map(CompositionViolation::getId).collect(Collectors.toSet());
        ExternalPropertiesIndex propertiesIndex = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        Map dueDates = propertiesIndex.getDueDates(allViolationIds);
        Map propertiesMap = propertiesIndex.getGenericProperties(allViolationIds);
        ArrayList<BuildScanResultWithProperties> enrichedResults = new ArrayList<BuildScanResultWithProperties>();
        for (BuildScanResult scanResult2 : scanResults) {
            List<ViolationWithProperties> enrichedViolations = scanResult2.violations().stream().map(violation -> new ViolationWithProperties(violation, (Long)dueDates.get(violation.getId()), (Map)propertiesMap.get(violation.getId()))).toList();
            enrichedResults.add(new BuildScanResultWithProperties(scanResult2.lastScanTimestamp(), scanResult2.vulnerabilities(), enrichedViolations, scanResult2.build()));
        }
        return enrichedResults;
    }

    private List<BuildScanResult> getViolationsForLatestBuilds(boolean includeIgnored, boolean includePendingIgnored) throws StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        Map latestVersionsByBuildName = jFrogXrayIndex.getLatestBuildsVersions();
        List scanInfos = jFrogXrayIndex.getScanResultsForBuilds(latestVersionsByBuildName.entrySet().stream().map(entry -> new NameWithVersion((String)entry.getKey(), (String)entry.getValue())).toList());
        if (includeIgnored && includePendingIgnored) {
            return scanInfos;
        }
        List ignoreRules = includePendingIgnored ? SoftwareCompositionService.getActiveIgnoreRules(jFrogXrayIndex) : jFrogXrayIndex.getIgnoreRules();
        if (ignoreRules.isEmpty()) {
            return scanInfos;
        }
        ArrayList<BuildScanResult> filteredScanResults = new ArrayList<BuildScanResult>();
        for (BuildScanResult scanInfo : scanInfos) {
            List<CompositionViolation> filteredViolations = scanInfo.violations().stream().filter(violation -> ignoreRules.stream().noneMatch(ignoreRule -> ignoreRule.matches(violation))).toList();
            filteredScanResults.add(new BuildScanResult(scanInfo.lastScanTimestamp(), CollectionUtils.emptyIfNull((List)scanInfo.vulnerabilities()), filteredViolations, scanInfo.build()));
        }
        return filteredScanResults;
    }

    @GET
    @Path(value="violations/ignored")
    @Operation(summary="Returns the ignored violations", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<ViolationWithIgnoreRule> getIgnoredCompositionViolations(@QueryParam(value="build-name") @Nullable String buildNameToFilterFor, @QueryParam(value="build-version") @Nullable String buildVersionToFilterFor) throws StorageException {
        List<ConnectorConfiguration> softwareCompositionConnectorsInProject = this.getSoftwareCompositionToolConnectorsInProject();
        if (softwareCompositionConnectorsInProject.isEmpty()) {
            return Collections.emptyList();
        }
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        List<ViolationWithProperties> violations = this.enrichViolationsWithProperties(this.getViolations(buildNameToFilterFor, buildVersionToFilterFor, jFrogXrayIndex));
        List<IgnoreViolationRule> ignoreRules = SoftwareCompositionService.getActiveIgnoreRules(jFrogXrayIndex);
        ArrayList<ViolationWithIgnoreRule> violationsWithIgnoreRule = new ArrayList<ViolationWithIgnoreRule>();
        for (ViolationWithProperties violation : violations) {
            Optional<IgnoreViolationRule> firstMatchingRule = ignoreRules.stream().filter(ignoreRule -> !ignoreRule.isPendingApproval() && ignoreRule.matches(violation.violation())).findFirst();
            if (!firstMatchingRule.isPresent()) continue;
            violationsWithIgnoreRule.add(new ViolationWithIgnoreRule(violation, firstMatchingRule.get()));
        }
        return violationsWithIgnoreRule;
    }

    private static List<CompositionViolation> violationsMatchingAtLeastOneRule(List<CompositionViolation> violations, List<IgnoreViolationRule> ignoreRules) {
        return violations.stream().filter(violation -> ignoreRules.stream().anyMatch(ignoreRule -> ignoreRule.matches(violation))).toList();
    }

    @GET
    @Path(value="violations/ignored/pending")
    @Operation(summary="Returns the ignored violations", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<ViolationWithIgnoreRule> getPendingIgnoredViolations(@QueryParam(value="build-name") @Nullable String buildNameToFilterFor, @QueryParam(value="build-version") @Nullable String buildVersionToFilterFor) throws StorageException, IOException {
        List<ConnectorConfiguration> softwareCompositionConnectorsInProject = this.getSoftwareCompositionToolConnectorsInProject();
        if (softwareCompositionConnectorsInProject.isEmpty()) {
            return Collections.emptyList();
        }
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        List<ViolationWithProperties> violations = this.enrichViolationsWithProperties(this.getViolations(buildNameToFilterFor, buildVersionToFilterFor, jFrogXrayIndex));
        List<IgnoreViolationRule> ignoreRules = this.getIgnoreRules();
        ArrayList<ViolationWithIgnoreRule> pendingIgnoredViolations = new ArrayList<ViolationWithIgnoreRule>();
        for (ViolationWithProperties violation : violations) {
            Optional<IgnoreViolationRule> firstMatchingRule = ignoreRules.stream().filter(ignoreRule -> ignoreRule.isPendingApproval() && ignoreRule.matches(violation.violation())).findFirst();
            if (!firstMatchingRule.isPresent()) continue;
            pendingIgnoredViolations.add(new ViolationWithIgnoreRule(violation, firstMatchingRule.get()));
        }
        return pendingIgnoredViolations;
    }

    @GET
    @Path(value="violations/for-ignore-rule/{ignoreRuleId}")
    @Operation(summary="Returns the violations affected by the given Ignore Rule (Id), based on the latest builds", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<CompositionViolation> getViolationsForIgnoreRule(@PathParam(value="ignoreRuleId") String ignoreRuleId) throws StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        IgnoreViolationRule ignoreRule = jFrogXrayIndex.getIgnoreRule(ignoreRuleId);
        if (ignoreRule == null) {
            throw new NotFoundException("No such Ignore Rule with id " + ignoreRuleId);
        }
        return SoftwareCompositionService.violationsMatchingAtLeastOneRule(this.getViolations(null, null, jFrogXrayIndex), List.of(ignoreRule));
    }

    @GET
    @Path(value="connector-count")
    @Operation(summary="Returns the number of Software Composition Analysis (SCA) tools in the given project.", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public int getSoftwareCompositionConnectorCount() throws StorageException {
        return this.getSoftwareCompositionToolConnectorsInProject().size();
    }

    private List<CompositionViolation> getViolations(@Nullable String buildNameToFilterFor, @Nullable String buildVersionToFilterFor, JFrogXrayIndex jFrogXrayIndex) throws StorageException {
        if (buildNameToFilterFor != null && buildVersionToFilterFor != null) {
            return jFrogXrayIndex.getScanResultsForBuilds(List.of(new NameWithVersion(buildNameToFilterFor, buildVersionToFilterFor))).stream().flatMap(scanInfo -> scanInfo.violations().stream()).toList();
        }
        return this.getViolationsForLatestBuilds(true, true).stream().flatMap(scanInfo -> scanInfo.violations().stream()).toList();
    }

    private static List<IgnoreViolationRule> getActiveIgnoreRules(JFrogXrayIndex jFrogXrayIndex) throws StorageException {
        return jFrogXrayIndex.getIgnoreRules().stream().filter(ignoreRule -> ignoreRule.approvalState() == null || ignoreRule.approvalState().state() == FindingBlacklistEvent.EExtendedBlacklistChangeType.EXCLUSION || ignoreRule.approvalState().state() == FindingBlacklistEvent.EExtendedBlacklistChangeType.APPROVAL).toList();
    }

    @NotNull
    private List<ViolationWithProperties> enrichViolationsWithProperties(List<CompositionViolation> filteredViolations) throws StorageException {
        Set violationIds = filteredViolations.stream().map(CompositionViolation::getId).collect(Collectors.toSet());
        ExternalPropertiesIndex propertiesIndex = this.openProjectIndex(ExternalPropertiesIndex.class, null);
        Map dueDates = propertiesIndex.getDueDates(violationIds);
        Map propertiesMap = propertiesIndex.getGenericProperties(violationIds);
        return filteredViolations.stream().map(violation -> new ViolationWithProperties(violation, (Long)dueDates.get(violation.getId()), (Map)propertiesMap.get(violation.getId()))).toList();
    }

    @GET
    @Path(value="builds-for-revisions")
    @Operation(summary="Returns the build(s) found for the given revisions (e.g. a Git commit hash)", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public SetMap<String, NameWithVersion> getBuildsForRevisions(@QueryParam(value="revision") List<String> revisions) throws StorageException {
        List<ConnectorConfiguration> softwareCompositionConnectorsInProject = this.getSoftwareCompositionToolConnectorsInProject();
        if (softwareCompositionConnectorsInProject.isEmpty()) {
            return new SetMap();
        }
        return this.openProjectIndex(JFrogXrayIndex.class, null).getBuildsForRevisions(revisions);
    }

    @GET
    @Path(value="builds/{buildName}/{buildVersion}/commit")
    @Operation(summary="Get commits for a build name and version", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public CommitsForBuild getCommitsForBuild(@PathParam(value="buildName") String buildName, @PathParam(value="buildVersion") String buildVersion) throws IOException, StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        List commitHashes = jFrogXrayIndex.getRevisionsForBuild(new NameWithVersion(buildName, buildVersion));
        if (commitHashes.isEmpty() || commitHashes.getFirst() == null) {
            return new CommitsForBuild(Collections.emptyList(), Collections.emptyList());
        }
        RepositoryRevisionIndex index = this.openProjectIndex(RepositoryRevisionIndex.class, null);
        HashSet commits = new HashSet();
        for (String commitHash : commitHashes) {
            commits.addAll(index.getKnownRepositoryCommits(commitHash).extractFirstList());
        }
        List<RepositoryLogEntryAggregate> repositoryLogEntries = new ArrayList<RepositoryLogEntryAggregate>();
        if (!commits.isEmpty()) {
            repositoryLogEntries = this.openProjectIndex(RepositoryLogIndex.class, null).getEntries(commits.stream().toList()).stream().filter(Objects::nonNull).toList();
        }
        return new CommitsForBuild(repositoryLogEntries, commitHashes);
    }

    @GET
    @Path(value="ignore-rules")
    @Operation(summary="Returns the Ignore Rules for violations (incl. rules pending approval, if approval is turned on in the project options)", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<IgnoreViolationRule> getIgnoreRules() throws IOException, StorageException {
        return this.openProjectIndex(JFrogXrayIndex.class, null).getIgnoreRules();
    }

    @GET
    @Path(value="ignore-rules/{ruleId}")
    @Operation(summary="Gets the Ignore Rule for the given rule ID", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public IgnoreViolationRule getIgnoreRule(@PathParam(value="ruleId") String ruleId) throws StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        return jFrogXrayIndex.getIgnoreRule(ruleId);
    }

    @DELETE
    @Path(value="ignore-rules/{ruleId}")
    @Operation(summary="Returns the Ignore Rules for violations", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    public void deleteIgnoreRule(@PathParam(value="ruleId") String ruleId) throws StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        IgnoreViolationRule ignoreRule = jFrogXrayIndex.getIgnoreRule(ruleId);
        if (ignoreRule == null) {
            LOGGER.warn("Received invalid Ignore rule ID for deletion, ignoring: {}", (Object)ruleId);
            return;
        }
        jFrogXrayIndex.deleteIgnoreRules(List.of(ruleId));
        if (ignoreRule.xrayRuleId() == null) {
            LOGGER.warn("Cannot delete Ignore rule from Xray, as its Xray Rule ID is unknown: {}", (Object)ruleId);
            return;
        }
        this.deleteIgnoreRuleFromXrayUnlessInTestMode(ignoreRule);
    }

    private void deleteIgnoreRuleFromXrayUnlessInTestMode(IgnoreViolationRule ignoreRule) {
        if (this.isInShadowModeOrTestMode()) {
            return;
        }
        try {
            Response xrayResponse = this.getFrogClient(ignoreRule.tsAccountIdentifier()).getClient().deleteIgnoreRule(ignoreRule.xrayRuleId()).execute();
            if (!xrayResponse.isSuccessful()) {
                throw new StorageException("Could not delete Ignore Rule, status: " + String.valueOf(xrayResponse));
            }
        }
        catch (IOException | StorageException e) {
            LOGGER.error("Failed to delete Ignore rule {}: {}", (Object)ignoreRule.xrayRuleId(), (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isInShadowModeOrTestMode() {
        try {
            return EFeatureToggle.ENABLE_TEST_MODE.isEnabled() || ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.getGlobalStorageSystem());
        }
        catch (StorageException e) {
            LOGGER.error("Failed to determine if shadow mode is enabled", (Throwable)e);
            return true;
        }
    }

    @POST
    @Path(value="violations/ignore")
    @Operation(summary="Creates a Ignore Rule for Violations, both in Xray (if possible) and Teamscale. Returns a list of warnings that occurred during creation.", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.EXCLUDE_RED_FINDINGS})
    public List<String> ignoreViolation(@RequestBody IgnoreViolationRequest ignoreRequest) throws IOException, StorageException {
        boolean useApprovalWorkFlow = this.readApprovalOption().shouldUseApprovalWorkFlowForCompositionViolations();
        ArrayList<String> warnings = new ArrayList();
        JfrogXrayClient client = this.getFrogClient(ignoreRequest.tsAccountIdentifier());
        String xrayIdOfCreatedRule = null;
        if (!useApprovalWorkFlow) {
            XrayIgnoreRulePushResult xrayPushResult = this.pushIgnoreRuleToXrayUnlessInTestMode(ignoreRequest, client);
            warnings = xrayPushResult.warnings();
            xrayIdOfCreatedRule = xrayPushResult.xrayIdOfCreatedRule();
        }
        try {
            FindingBlacklistEvent.EExtendedBlacklistChangeType approvalType = FindingBlacklistEvent.EExtendedBlacklistChangeType.EXCLUSION;
            if (useApprovalWorkFlow) {
                approvalType = FindingBlacklistEvent.EExtendedBlacklistChangeType.PENDING_EXCLUSION;
            }
            JFrogXrayIndex xrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
            IgnoreViolationRule ignoreRule = new IgnoreViolationRule(this.getUser().getUsername(), UUID.randomUUID().toString(), Date.from(Instant.now()).toString(), ignoreRequest.notes(), null, ignoreRequest, xrayIdOfCreatedRule, ignoreRequest.externalProjectKey(), ignoreRequest.tsAccountIdentifier(), new IgnoreRuleApprovalState(approvalType, null, null, null));
            xrayIndex.storeIgnoreRules(List.of(ignoreRule));
        }
        catch (StorageException e) {
            throw new InternalServerErrorException("Unexpected error storing ignored violation: " + e.getMessage(), (Throwable)e);
        }
        return warnings;
    }

    private FindingExclusionApprovalOption readApprovalOption() throws StorageException {
        return FindingExclusionApprovalOption.getInstance((ProjectOptionIndex)this.openProjectIndex(ProjectOptionIndex.class, null));
    }

    @POST
    @Path(value="ignore-rules/{ignoreRuleId}/approve")
    @Operation(summary="Approves or rejects a Ignore Rule that has a pending approval state", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION})
    public XrayIgnoreRulePushResult approvePendingIgnoreRule(@PathParam(value="ignoreRuleId") String ignoreRuleId, @QueryParam(value="comment") @Nullable String approvalComment) throws StorageException {
        this.checkNonEmptyRationale(approvalComment);
        IgnoreViolationRule updatedRule = this.setIgnoreRuleState(ignoreRuleId, FindingBlacklistEvent.EExtendedBlacklistChangeType.APPROVAL, approvalComment);
        XrayIgnoreRulePushResult xrayPushResult = this.pushIgnoreRuleToXrayUnlessInTestMode(updatedRule.ignoreFilters(), this.getFrogClient(updatedRule.ignoreFilters().tsAccountIdentifier()));
        if (xrayPushResult.xrayIdOfCreatedRule() != null) {
            IgnoreViolationRule updatedRuleWithXrayRuleId = updatedRule.withXrayRuleId(xrayPushResult.xrayIdOfCreatedRule());
            this.openProjectIndex(JFrogXrayIndex.class, null).storeIgnoreRules(List.of(updatedRuleWithXrayRuleId));
        }
        return xrayPushResult;
    }

    @POST
    @Path(value="ignore-rules/{ignoreRuleId}/reject")
    @Operation(summary="Rejects a Ignore Rule that has a pending approval state", tags={"Software Composition"})
    @RequiresProjectPermission(value={EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION})
    public void rejectPendingIgnoreRule(@PathParam(value="ignoreRuleId") String ignoreRuleId, @QueryParam(value="comment") @Nullable String rejectionComment) throws StorageException {
        this.checkNonEmptyRationale(rejectionComment);
        this.setIgnoreRuleState(ignoreRuleId, FindingBlacklistEvent.EExtendedBlacklistChangeType.REJECTION, rejectionComment);
    }

    private void checkNonEmptyRationale(String rationale) {
        try {
            if (StringUtils.isEmpty((String)rationale) && BlacklistingOption.getBlacklistingOption((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class)).disableEmptyRationale) {
                throw new BadRequestException("Non-empty rationale is required!");
            }
        }
        catch (StorageException e) {
            LOGGER.error("Error while trying to check if rationale is empty, skipping check", (Throwable)e);
        }
    }

    private IgnoreViolationRule setIgnoreRuleState(String ignoreRuleId, FindingBlacklistEvent.EExtendedBlacklistChangeType newState, @Nullable String approveOrDenyNotes) throws StorageException {
        JFrogXrayIndex jFrogXrayIndex = this.openProjectIndex(JFrogXrayIndex.class, null);
        IgnoreViolationRule rule = jFrogXrayIndex.getIgnoreRule(ignoreRuleId);
        if (rule == null) {
            throw new NotFoundException("No Ignore Rule with id " + ignoreRuleId + " was found.");
        }
        if ((newState == FindingBlacklistEvent.EExtendedBlacklistChangeType.APPROVAL || newState == FindingBlacklistEvent.EExtendedBlacklistChangeType.REJECTION) && this.getUser().getUsername().equals(rule.tsCreatorUser()) && !this.readApprovalOption().isAllowSelfApproval()) {
            throw new BadRequestException("User " + rule.tsCreatorUser() + " is not allowed to approve/reject their own ignore rule (self approval/rejection can be enabled in the project options).");
        }
        IgnoreViolationRule updatedRule = rule.with(new IgnoreRuleApprovalState(newState, this.getUser().getUsername(), approveOrDenyNotes, Long.valueOf(DateTimeUtils.millisNow())));
        jFrogXrayIndex.storeIgnoreRules(List.of(updatedRule));
        return updatedRule;
    }

    private XrayIgnoreRulePushResult pushIgnoreRuleToXrayUnlessInTestMode(IgnoreViolationRequest ignoreRequest, JfrogXrayClient client) {
        if (this.isInShadowModeOrTestMode()) {
            return new XrayIgnoreRulePushResult(null, List.of("Test Mode"));
        }
        String xrayIdOfCreatedRule = null;
        ArrayList<String> warnings = new ArrayList<String>();
        try {
            JfrogXrayClient.IgnoreRuleRequest xrayRequestBody = JfrogXrayClient.IgnoreRuleRequest.forTsRequest((IgnoreViolationRequest)ignoreRequest);
            Response response = client.getClient().createIgnoreRule(xrayRequestBody).execute();
            if (response.isSuccessful()) {
                String responseText = response.message();
                if (responseText.startsWith("successfully added ignore rule with id:")) {
                    xrayIdOfCreatedRule = responseText.split(":")[1].trim();
                }
            } else {
                String message = "Error while creating Ignore Rule in Xray: " + response.code() + ": " + response.message();
                LOGGER.error(message);
                warnings.add(message);
            }
        }
        catch (IOException e) {
            String error = e.getMessage();
            String message = "Request error while creating Ignore Rule in Xray: " + error;
            warnings.add(message);
        }
        return new XrayIgnoreRulePushResult(xrayIdOfCreatedRule, warnings);
    }

    private JfrogXrayClient getFrogClient(String accountIdentifier) throws StorageException {
        Optional<ConnectorConfiguration> softwareCompositionConnector = this.getSoftwareCompositionToolConnectorsInProject().stream().filter(connector -> StringUtils.emptyIfNull((String)connector.getOptionValue("Account")).equals(accountIdentifier)).findFirst();
        if (softwareCompositionConnector.isEmpty()) {
            throw new NotFoundException("Connector with id " + accountIdentifier + " was not found in project");
        }
        String accountName = softwareCompositionConnector.get().getOptionValue("Account");
        ExternalCredentials externalCredentials = this.openGlobalIndex(ExternalCredentialsIndex.class).getExternalCredentials(accountName);
        if (externalCredentials == null) {
            throw new NotFoundException("Account with id " + accountIdentifier + " was not found in project");
        }
        return new JfrogXrayClient(externalCredentials.uri, externalCredentials.password);
    }

    public record ViolationWithIgnoreRule(@JsonUnwrapped ViolationWithProperties violation, IgnoreViolationRule rule) {
    }

    public record CommitsForBuild(List<RepositoryLogEntryAggregate> logEntries, List<String> rawCommitHashes) {
    }

    public record XrayIgnoreRulePushResult(@Nullable String xrayIdOfCreatedRule, List<String> warnings) {
    }
}

