/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.findings.calculation.BasicFindingFilterUtils;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testcoverage.CoverageAdjuster;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.service.treemap.CoverageMethodTreeMapNode;
import com.teamscale.service.treemap.FindingsResolvedMethodTreeMapNode;
import com.teamscale.service.treemap.IColorOption;
import com.teamscale.service.treemap.MethodBasedTreeMapNodeBase;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.test.RequireThreadSafe;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@Schema(oneOf={FindingMetricOption.class, LineCoverageMetricOption.class}, description="Describes the respective metric and appropriate parameters, that should be shown within the treemap")
@RequireThreadSafe
sealed interface IMetricOption<NODE extends MethodBasedTreeMapNodeBase> {
    public static IMetricOption<?> fromJson(JsonNode jsonNode) {
        try {
            Class optionClass;
            if (jsonNode.has("findingsFilter")) {
                optionClass = FindingMetricOption.class;
            } else if (jsonNode.has("partitionSelection")) {
                optionClass = LineCoverageMetricOption.class;
            } else {
                throw new BadRequestException("Unable to detect correct metric option from " + String.valueOf(jsonNode));
            }
            return (IMetricOption)JsonUtils.getObjectMapper().treeToValue((TreeNode)jsonNode, optionClass);
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException("Unable to deserialize metric option: " + String.valueOf(jsonNode), (Throwable)e);
        }
    }

    public void init(PublicProjectId var1, IndexLayer var2, ProjectStorageSystem var3, CommitDescriptor var4) throws StorageException;

    public Set<UniformPath> filterPaths(Set<UniformPath> var1) throws StorageException;

    public IColorOption<NODE> parseColorOption(JsonNode var1);

    public void prepareForPath(UniformPath var1) throws StorageException;

    public NODE createLeafNode(UniformPath var1, AssociatedMethodInfo var2, Set<TeamscaleIssueId> var3);

    public NODE createIntermediateNode(String var1);

    public void finishPath(UniformPath var1);

    @ThreadSafe
    public static final class FindingMetricOption
    implements IMetricOption<FindingsResolvedMethodTreeMapNode> {
        private static final String FINDINGS_FILTER_PARAMETER_NAME = "findingsFilter";
        @JsonProperty(value="findingsFilter")
        private BasicFindingsFilterSettings findingsFilterSettings;
        @JsonIgnore
        private IFindingsRetriever findingsRetriever;
        @JsonIgnore
        private ExtendedTrackedFindingUtils.ExtendedFindingLookup findingLookup;
        @JsonIgnore
        private CommitDescriptor commit;
        @JsonIgnore
        private final ConcurrentMap<UniformPath, List<ExtendedTrackedFinding>> preLoadedFindingsStore = new ConcurrentHashMap<UniformPath, List<ExtendedTrackedFinding>>();

        @Override
        public void init(PublicProjectId primaryPublicId, IndexLayer indexLayer, ProjectStorageSystem projectStorageSystem, CommitDescriptor commit) throws StorageException {
            FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(primaryPublicId, projectStorageSystem, indexLayer);
            this.findingsRetriever = IFindingsRetriever.getFindingsRetriever((boolean)false, (boolean)false, (String)commit.getBranchName(), (FindingsCalculationInfo)calculationInfo);
            this.findingLookup = ExtendedTrackedFindingUtils.buildLookup((FindingsCalculationInfo)calculationInfo);
            this.commit = commit;
        }

        @Override
        public Set<UniformPath> filterPaths(Set<UniformPath> paths) {
            return paths;
        }

        @Override
        public IColorOption<FindingsResolvedMethodTreeMapNode> parseColorOption(JsonNode jsonNode) {
            Class targetClass;
            if (jsonNode.has("minReferencesColor")) {
                targetClass = IColorOption.MatchedIssuesColorOption.class;
            } else if (jsonNode.has("minFindingsColor")) {
                targetClass = IColorOption.NumberOfFindingsColorOption.class;
            } else if (jsonNode.has("colorBlindMode")) {
                targetClass = IColorOption.FindingsSeverityColorOption.class;
            } else {
                throw new BadRequestException("Unable to detect correct color option from " + String.valueOf(jsonNode));
            }
            try {
                return (IColorOption)JsonUtils.getObjectMapper().treeToValue((TreeNode)jsonNode, targetClass);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("Unable to deserialize color option: " + String.valueOf(jsonNode), (Throwable)e);
            }
        }

        @Override
        public FindingsResolvedMethodTreeMapNode createLeafNode(UniformPath filePath, AssociatedMethodInfo methodInfo, Set<TeamscaleIssueId> matchedIssues) {
            List fileFindings = (List)this.preLoadedFindingsStore.get(filePath);
            Preconditions.checkState((fileFindings != null ? 1 : 0) != 0, (String)"Did not preload findings for %s", (Object)filePath);
            List<ExtendedTrackedFinding> findings = FindingMetricOption.extractMethodFindings(methodInfo.getLocation(), fileFindings);
            return new FindingsResolvedMethodTreeMapNode(filePath, methodInfo, findings, matchedIssues);
        }

        private static List<ExtendedTrackedFinding> extractMethodFindings(MethodLocation methodLocation, List<ExtendedTrackedFinding> fileFindings) {
            return fileFindings.stream().filter(FindingMetricOption.isMatching(methodLocation)).toList();
        }

        private static Predicate<? super TrackedFinding> isMatching(MethodLocation methodLocation) {
            return finding -> {
                ElementLocation patt0$temp = finding.getLocation();
                if (!(patt0$temp instanceof TextRegionLocation)) return false;
                TextRegionLocation findingLocation = (TextRegionLocation)patt0$temp;
                if (!Objects.equals(methodLocation.getUniformPath().toStringAsMigrationFrontier(), findingLocation.getUniformPath())) return false;
                if (findingLocation.getRawEndOffset() < methodLocation.getRegion().getStart()) return false;
                if (findingLocation.getRawStartOffset() > methodLocation.getRegion().getEnd()) return false;
                return true;
            };
        }

        @Override
        public FindingsResolvedMethodTreeMapNode createIntermediateNode(String path) {
            return new FindingsResolvedMethodTreeMapNode(path);
        }

        @Override
        public void prepareForPath(UniformPath filePath) throws StorageException {
            this.preLoadedFindingsStore.put(filePath, this.loadFileFindings(filePath));
        }

        private List<ExtendedTrackedFinding> loadFileFindings(UniformPath filePath) throws StorageException {
            List fileFindings = this.findingsRetriever.getFindings(filePath.toString(), this.commit);
            Map blacklistLookup = this.findingsRetriever.getFlaggedFindings((Collection)fileFindings, this.commit);
            List extendedTrackedFindings = this.findingLookup.enhance(fileFindings, blacklistLookup);
            return BasicFindingFilterUtils.filterFindings((List)extendedTrackedFindings, (BasicFindingsFilterSettings)this.findingsFilterSettings, (CodeScopeAware)this.findingLookup.getTypeIdToTypeDescription()).filteredFindings();
        }

        @Override
        public void finishPath(UniformPath filePath) {
            this.preLoadedFindingsStore.remove(filePath);
        }
    }

    @ThreadSafe
    public static final class LineCoverageMetricOption
    implements IMetricOption<CoverageMethodTreeMapNode> {
        private static final String PARTITION_SELECTION_PARAMETER_NAME = "partitionSelection";
        @JsonProperty(value="partitionSelection")
        private PartitionSelection partitionSelection;
        @JsonIgnore
        private List<String> resolvedPartitions;
        @JsonIgnore
        private LineCoverageIndex lineCoverageIndex;
        @JsonIgnore
        private TokenElementLineInfoIndex tokenElementLineInfoIndex;
        @JsonIgnore
        private ExtendedResourceTypeIndex extendedResourceTypeIndex;
        @JsonIgnore
        private final ConcurrentMap<UniformPath, PreLoadedData> preLoadedDataStore = new ConcurrentHashMap<UniformPath, PreLoadedData>();

        @Override
        public void init(PublicProjectId primaryPublicId, IndexLayer indexLayer, ProjectStorageSystem projectStorageSystem, CommitDescriptor commit) throws StorageException {
            this.lineCoverageIndex = (LineCoverageIndex)projectStorageSystem.openProjectIndex(LineCoverageIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
            this.tokenElementLineInfoIndex = (TokenElementLineInfoIndex)projectStorageSystem.openProjectIndex(TokenElementLineInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
            this.extendedResourceTypeIndex = (ExtendedResourceTypeIndex)projectStorageSystem.openProjectIndex(ExtendedResourceTypeIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
            this.resolvedPartitions = this.partitionSelection.useAll() ? this.lineCoverageIndex.getPartitions() : this.partitionSelection.partitions();
        }

        @Override
        public Set<UniformPath> filterPaths(Set<UniformPath> paths) throws StorageException {
            Set testCodePaths = this.extendedResourceTypeIndex.getTestCodePaths(paths);
            if (testCodePaths.isEmpty()) {
                return paths;
            }
            HashSet<UniformPath> result = new HashSet<UniformPath>(paths);
            result.removeAll(testCodePaths);
            return result;
        }

        @Override
        public IColorOption<CoverageMethodTreeMapNode> parseColorOption(JsonNode jsonNode) {
            try {
                return (IColorOption)JsonUtils.getObjectMapper().treeToValue((TreeNode)jsonNode, IColorOption.LineCoverageColorOption.class);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("Unable to deserialize color option: " + String.valueOf(jsonNode), (Throwable)e);
            }
        }

        @Override
        public void prepareForPath(UniformPath filePath) throws StorageException {
            UniformPath codePath = filePath.resolveToCodePath();
            TokenElementLineInfo lineInfo = this.tokenElementLineInfoIndex.getLineInfo(codePath.toString());
            LineCoverageInfo coverage = this.getCoverage(codePath, lineInfo);
            this.preLoadedDataStore.put(filePath, new PreLoadedData(lineInfo.getRawLineOffsetConverter(), coverage));
        }

        @Override
        public void finishPath(UniformPath filePath) {
            this.preLoadedDataStore.remove(filePath);
        }

        @Override
        public CoverageMethodTreeMapNode createLeafNode(UniformPath filePath, AssociatedMethodInfo methodInfo, Set<TeamscaleIssueId> matchedIssues) {
            PreLoadedData preLoadedData = (PreLoadedData)this.preLoadedDataStore.get(filePath);
            Preconditions.checkState((preLoadedData != null ? 1 : 0) != 0, (String)"No preloaded data found for %s", (Object)filePath);
            LineOffsetConverter lineOffsetConverter = preLoadedData.lineOffsetConverter();
            LineCoverageInfo coverage = preLoadedData.coverage();
            int startLine = lineOffsetConverter.getLine(methodInfo.getLocation().getRegion().getStart());
            int endLine = lineOffsetConverter.getLine(methodInfo.getLocation().getRegion().getEnd());
            CompactLines methodLines = new CompactLines();
            methodLines.addRange(startLine, endLine);
            int coverableLines = coverage.getAllCoverableLines().intersection(methodLines).size();
            int coveredLines = coverage.getCoveredLines().intersection(methodLines).size();
            return new CoverageMethodTreeMapNode(filePath, methodInfo, coverableLines, coveredLines, matchedIssues);
        }

        private @NonNull LineCoverageInfo getCoverage(UniformPath filePath, TokenElementLineInfo lineInfo) throws StorageException {
            Optional<LineCoverageInfo> resolvedCoverage = this.lineCoverageIndex.getAllCoverageForFile(this.resolvedPartitions, filePath).stream().filter(Objects::nonNull).reduce((c1, c2) -> {
                c1.addAll(c2);
                return c1;
            });
            LineCoverageInfo coverageInfo = resolvedCoverage.orElseGet(() -> new LineCoverageInfo(false));
            CoverageAdjuster.correctLineCoverage((String)filePath.toString(), (TokenElementLineInfo)lineInfo, (LineCoverageInfo)coverageInfo, (boolean)resolvedCoverage.isPresent());
            return coverageInfo;
        }

        @Override
        public CoverageMethodTreeMapNode createIntermediateNode(String path) {
            return new CoverageMethodTreeMapNode(path);
        }

        private record PartitionSelection(@JsonProperty(value="partitions") List<String> partitions, @JsonProperty(value="useAll") boolean useAll) {
        }

        private record PreLoadedData(LineOffsetConverter lineOffsetConverter, LineCoverageInfo coverage) {
        }
    }
}

