/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github;

import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.github.GitHubChangeRetriever;
import com.teamscale.index.repository.git.github.GitHubMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.index.GitHubWebhookPayloadIndex;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerFactory;
import com.teamscale.service.webhook.github.event_handler.IMergeRequestUpdateTriggerSchedulingHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@Path(value="api/github/web-hook")
public class GitHubApplicationWebHookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern URL_PATTERN = Pattern.compile("\"html_url\":\"(https://[-a-zA-Z0-9+.]*\\.[-a-zA-Z]*/)");
    public static final String GITHUB_EVENT_HEADER_NAME = "X-GitHub-Event";
    public static final String GITHUB_SHA256_SIGNATURE_HEADER_NAME = "X-Hub-Signature-256";
    public static final String GITHUB_INSTALLATION_TARGET_ID_HEADER_NAME = "X-GitHub-Hook-Installation-Target-ID";

    public GitHubApplicationWebHookService() {
        super(GitHubChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles the incoming requests from the GitHub app.", description="Handles the incoming requests from the GitHub app and processes the request body depending on the event. The events which are handled by the service are: 'ping', 'installation', 'installation_repositories', 'pull_request', 'push', 'github_app_authorization', 'check_run' and 'status'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHook(@HeaderParam(value="X-GitHub-Event") String event, @HeaderParam(value="X-Hub-Signature-256") String signature, @HeaderParam(value="X-GitHub-Hook-Installation-Target-ID") String appId, @RequestBody byte[] requestBody) throws StorageException {
        String queryContent = StringUtils.bytesToString((byte[])requestBody);
        LOGGER.debug("Received a web hook request from GitHub with event \"{}\" and payload: {}", (Object)event, (Object)queryContent);
        if (StringUtils.isEmpty((String)event)) {
            throw new BadRequestException("Event header missing!");
        }
        if (event.equals("ping")) {
            return Response.ok().build();
        }
        GitHubApplicationDescription applicationDescription = this.checkSignature(queryContent, event, signature, appId);
        try {
            return this.processEvent(event, queryContent, applicationDescription.serverUrl);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid request: " + e.getMessage(), (Throwable)e);
        }
    }

    private GitHubApplicationDescription checkSignature(String queryContent, String event, String signature, String appId) throws StorageException {
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        Matcher urlMatcher = URL_PATTERN.matcher(queryContent);
        String gitHubServerUrl = urlMatcher.find() ? urlMatcher.group(1) : "";
        GitHubApplicationDescription description = GitHubAppUtils.loadConfiguredApplication((String)appId, (String)gitHubServerUrl, (ServerOptionIndex)optionIndex, InternalServerErrorException::new);
        if (description == null) {
            LOGGER.error("Could not load app description for app ID: {} and GitHub Server URL {}.", (Object)appId, (Object)gitHubServerUrl);
            throw new BadRequestException("Missing app description!");
        }
        if (StringUtils.isEmpty((String)description.webhookSecret)) {
            return description;
        }
        if (StringUtils.isEmpty((String)signature)) {
            LOGGER.error("Received GitHub request without signature: {}", (Object)event);
            throw new BadRequestException("Missing signature!");
        }
        String sha256 = GitHubApplicationWebHookService.generateWebhookSignature(queryContent.trim(), description.webhookSecret);
        if (!sha256.equals(signature)) {
            LOGGER.error("Received GitHub request with invalid signature: {}", (Object)event);
            throw new BadRequestException("Invalid signature!");
        }
        return description;
    }

    @VisibleForTesting
    public static String generateWebhookSignature(String jsonPayload, String webhookSecret) {
        String digestedQueryContent = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, webhookSecret).hmacHex(jsonPayload);
        return "sha256=" + digestedQueryContent;
    }

    private Response processEvent(String event, @Language(value="JSON") String payload, String appGitHubServerUrl) throws ConQATException {
        IMergeRequestUpdateTriggerSchedulingHelper mergeRequestUpdateTriggerSchedulingHelper = this.createIMergeRequestUpdateTriggerSchedulingHelper(appGitHubServerUrl);
        GitHubWebhookEventHandlerFactory.create(event, this.getIndexLayer(), appGitHubServerUrl, mergeRequestUpdateTriggerSchedulingHelper).handle(payload);
        return Response.ok().build();
    }

    private @NonNull IMergeRequestUpdateTriggerSchedulingHelper createIMergeRequestUpdateTriggerSchedulingHelper(final String appGitHubServerUrl) {
        return new IMergeRequestUpdateTriggerSchedulingHelper(){

            @Override
            public void scheduleMergeRequestUpdateTriggersForPullRequest(String cloneUrl, String repositoryName, long pullRequestNumber) throws StorageException {
                GitHubApplicationWebHookService.this.scheduleMergeRequestUpdateTriggers(cloneUrl, repositoryName, pullRequestNumber, appGitHubServerUrl, GitHubMergeRequestUpdateTrigger.class, null);
            }

            @Override
            public void scheduleMergeRequestUpdateTriggersForCommit(String cloneUrl, String repositoryName, String commitSha) throws StorageException {
                GitHubApplicationWebHookService.this.scheduleMergeRequestUpdateTriggers(cloneUrl, repositoryName, commitSha, appGitHubServerUrl, GitHubMergeRequestUpdateTrigger.class);
            }

            @Override
            public void addPullRequestToWebhookPayloadIndex(String cloneUrl, String repositoryName, long pullRequestNumber, GitHubPullRequest pullRequest) throws StorageException {
                if (!EFeatureToggle.ENABLE_PULLING_MERGE_REQUEST_DATA_FROM_WEBHOOK_PAYLOADS.isEnabled()) {
                    return;
                }
                GitHubApplicationWebHookService.this.runForEachProjectWithRepository(repositoryName, (projectInfo, projectStorageSystem) -> GitHubApplicationWebHookService.addPullRequestToPayloadIndex(repositoryName, pullRequestNumber, pullRequest, projectStorageSystem), null);
            }

            @Override
            public void addCheckRunToWebhookPayloadIndex(String cloneUrl, String repositoryName, String commitSha, CheckRun checkRun) throws StorageException {
                if (!EFeatureToggle.ENABLE_PULLING_MERGE_REQUEST_DATA_FROM_WEBHOOK_PAYLOADS.isEnabled()) {
                    return;
                }
                GitHubApplicationWebHookService.this.runForEachProjectWithRepository(repositoryName, (projectInfo, projectStorageSystem) -> GitHubApplicationWebHookService.addCheckRunToPayloadIndex(repositoryName, commitSha, checkRun, projectStorageSystem), null);
            }

            @Override
            public void addCommitStatusToWebhookPayLoadIndex(String cloneUrl, String repositoryName, String commitSha, GitHubCommitStatus commitStatus) throws StorageException {
                if (!EFeatureToggle.ENABLE_PULLING_MERGE_REQUEST_DATA_FROM_WEBHOOK_PAYLOADS.isEnabled()) {
                    return;
                }
                GitHubApplicationWebHookService.this.runForEachProjectWithRepository(repositoryName, (projectInfo, projectStorageSystem) -> GitHubApplicationWebHookService.addCommitStatusToPayloadIndex(repositoryName, commitSha, commitStatus, projectStorageSystem), null);
            }
        };
    }

    private static void addPullRequestToPayloadIndex(String repositoryName, long pullRequestNumber, GitHubPullRequest pullRequest, ProjectStorageSystem projectStorageSystem) {
        try {
            GitHubWebhookPayloadIndex index = (GitHubWebhookPayloadIndex)projectStorageSystem.openProjectIndex(GitHubWebhookPayloadIndex.class, null);
            MergeRequestIdentifier mergeRequestIdentifier = new MergeRequestIdentifier(repositoryName, pullRequestNumber);
            index.addPullRequestFromPayload(mergeRequestIdentifier, pullRequest);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to store pull request '{}' for repository '{}'", new Supplier[]{() -> pullRequestNumber, () -> repositoryName});
        }
    }

    private static void addCheckRunToPayloadIndex(String repositoryName, String commitSha, CheckRun checkRun, ProjectStorageSystem projectStorageSystem) {
        try {
            GitHubWebhookPayloadIndex index = (GitHubWebhookPayloadIndex)projectStorageSystem.openProjectIndex(GitHubWebhookPayloadIndex.class, null);
            index.addCheckRunFromPayload(commitSha, checkRun);
        }
        catch (StorageException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to store check run '{}' for repository '{}'", new Supplier[]{() -> checkRun, () -> repositoryName});
        }
    }

    private static void addCommitStatusToPayloadIndex(String repositoryName, String commitSha, GitHubCommitStatus commitStatus, ProjectStorageSystem projectStorageSystem) {
        try {
            GitHubWebhookPayloadIndex index = (GitHubWebhookPayloadIndex)projectStorageSystem.openProjectIndex(GitHubWebhookPayloadIndex.class, null);
            index.addCommitStatusFromPayload(commitSha, commitStatus);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to store commit status '{}' for repository '{}'", new Supplier[]{() -> commitStatus, () -> repositoryName});
        }
    }
}

