/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class CallStatementCheckBase
extends CheckImplementationBase {
    private UnmodifiableList<IToken> callStatementTokens = CollectionUtils.emptyList();
    private ShallowEntity callStatement;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"call".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    protected abstract boolean isTargetedCallStatement(ETokenType var1);

    protected final void processEntity(ShallowEntity entity) throws CheckException {
        this.callStatement = entity;
        this.callStatementTokens = entity.ownStartTokens();
        if (this.callStatementTokens.size() < 2 || !this.isTargetedCallStatement(((IToken)this.callStatementTokens.get(1)).getType())) {
            return;
        }
        this.processCallStatement();
    }

    protected abstract void processCallStatement() throws CheckException;

    protected ShallowEntity getCallStatement() {
        return this.callStatement;
    }

    protected UnmodifiableList<IToken> getCallStatmentTokens() {
        return this.callStatementTokens;
    }
}

