/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.SystemVariablesCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-usage-of-system-variables", languages={ELanguage.ABAP}, parameters={})
public class UsageOfSystemVariablesCheck
extends SystemVariablesCheckBase {
    static final String CHECK_NAME = "Usage of system variables";
    @CheckOption(name="Usage of system variables - relevant system variables", description="Fields of SY structure to be considered. If empty, all fields are considered.")
    private Set<String> systemFieldsToCheck = CollectionUtils.asHashSet((Object[])new String[]{"UNAME", "SYSID"});
    @CheckOption(name="Usage of system variables - relevant context info methods", description="Static methods of the `CL_ABAP_CONTEXT_INFO` class to be considered. If empty, all methods are considered.")
    private Set<String> abapContextInfoMethodsToCheck = CollectionUtils.asHashSet((Object[])new String[]{"GET_USER_TECHNICAL_NAME", "GET_USER_FORMATTED_NAME", "GET_USER_DESCRIPTION", "GET_USER_BUSINESS_PARTNER_ID", "GET_USER_ALIAS"});
    @CheckOption(name="Usage of system variables - ignore control statements", description="If true, control statements are ignored (when checked with Control flow depending on system variables).")
    private boolean ignoreControlStatements = true;

    @Override
    protected Set<String> getSystemFieldsToCheck() {
        return this.systemFieldsToCheck;
    }

    @Override
    protected Set<String> getAbapContextInfoMethodsToCheck() {
        return this.abapContextInfoMethodsToCheck;
    }

    @Override
    protected void performSystemVariableCheck(List<IToken> tokens, int index) throws CheckException {
        if (this.ignoreControlStatements && UsageOfSystemVariablesCheck.isInControlStatement(tokens, index)) {
            return;
        }
        IToken token = tokens.get(index);
        this.buildFinding("Usage of system variable " + MarkupUtils.formatAsSourceCode((String)token.getText().toUpperCase()), this.buildLocation().forToken(token)).createAndStore();
    }

    @Override
    protected void performAbapContextInfoMethodCheck(List<IToken> tokens, int index) throws CheckException {
        if (this.ignoreControlStatements && UsageOfSystemVariablesCheck.isInControlStatement(tokens, index)) {
            return;
        }
        IToken classToken = tokens.get(index);
        IToken methodToken = tokens.get(index + 2);
        this.buildFinding("Usage of method " + MarkupUtils.formatAsSourceCode((String)methodToken.getText().toUpperCase()) + " from " + MarkupUtils.formatAsSourceCode((String)classToken.getText().toUpperCase()), this.buildLocation().forToken(classToken)).createAndStore();
    }

    @Override
    protected void performAbapXcoLibraryMethodCheck(List<IToken> tokens, int index) throws CheckException {
        if (this.ignoreControlStatements && UsageOfSystemVariablesCheck.isInControlStatement(tokens, index)) {
            return;
        }
        IToken classToken = tokens.get(index);
        IToken methodToken = tokens.get(index + 4);
        this.buildFinding("Usage of method call " + MarkupUtils.formatAsSourceCode((String)(classToken.getText().toUpperCase() + "=>SY->" + methodToken.getText().toUpperCase())), this.buildLocation().forToken(classToken)).createAndStore();
    }
}

