/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionPredicates;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class CLikeAvoidUnusedPrivateMethodsCheckBase
extends CheckImplementationBase {
    protected static final int UNKNOWN_PARAMETER_NUMBER = -1;
    private static final List<ETokenType> OPENING_TOKEN_TYPES = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LT);
    private static final List<ETokenType> CLOSING_TOKEN_TYPES = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.GT);
    private static final Set<String> OUTERMOST_DEFINITION_TYPES = Set.of("class", "interface", "enum", "record");
    protected CLikeLanguageFeatureParserBase languageFeatureParser;
    private static List<ShallowEntity> allLocalVariableEntities = new ArrayList<ShallowEntity>();
    private static List<ShallowEntity> allTypeEntities = new ArrayList<ShallowEntity>();
    private static final String FINAL = "final";

    public ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.UNFILTERED_PREPROCESSED;
    }

    protected List<ShallowEntity> getAbstractSyntaxTree() throws CheckException {
        return this.context.getAbstractSyntaxTree(this.getCodeViewOption());
    }

    protected CLikeAvoidUnusedPrivateMethodsCheckBase(CLikeLanguageFeatureParserBase languageFeatureParser) {
        CCSMAssert.isNotNull((Object)languageFeatureParser);
        this.languageFeatureParser = languageFeatureParser;
    }

    public void execute() throws CheckException {
        this.loadFilteredEntities();
        List<MethodDescription> methodDefinitions = this.getMethodDefinitionsToCheck();
        List<MethodDescription> methodCalls = this.getMethodCalls();
        this.createFindings(methodDefinitions, methodCalls);
    }

    private void createFindings(List<MethodDescription> methodDefinitions, List<MethodDescription> methodCalls) {
        Map<String, List<MethodDescription>> methodCallsByName = methodCalls.stream().collect(Collectors.groupingBy(MethodDescription::getName));
        for (MethodDescription definition : methodDefinitions) {
            List<MethodDescription> candidateCalls;
            if (CLikeAvoidUnusedPrivateMethodsCheckBase.isCalled(definition, candidateCalls = methodCallsByName.getOrDefault(definition.getName(), Collections.emptyList()))) continue;
            int startLine = definition.getEntity().getStartLine();
            this.buildFinding("Private method `" + definition.getName() + "` is unused", this.buildLocation().forLine(startLine, this.getCodeViewOption().textView)).createAndStore();
        }
    }

    private static boolean isCalled(MethodDescription definition, List<MethodDescription> candidateCalls) {
        return candidateCalls.stream().anyMatch(call -> CLikeAvoidUnusedPrivateMethodsCheckBase.isCalled(definition, call));
    }

    private static boolean isCalled(MethodDescription methodDefinition, MethodDescription methodCall) {
        if (!CLikeAvoidUnusedPrivateMethodsCheckBase.hasMatchingNumberOfParameters(methodDefinition, methodCall)) {
            return false;
        }
        if (methodDefinition.isInAnonymousClass() || methodCall.isInAnonymousClass() || methodDefinition.hasSameClassName(methodCall)) {
            return true;
        }
        return CLikeAvoidUnusedPrivateMethodsCheckBase.areInSameTopLevelClass(methodDefinition, methodCall);
    }

    private static boolean hasMatchingNumberOfParameters(MethodDescription methodDefinition, MethodDescription methodCall) {
        if (methodDefinition.getNumberOfParameters() == methodCall.getNumberOfParameters()) {
            return true;
        }
        if (methodCall.getNumberOfParameters() == -1) {
            return true;
        }
        int methodDefinitionParameterNumber = methodDefinition.getNumberOfParameters();
        int methodCallParameterNumber = methodCall.getNumberOfParameters();
        return methodDefinition.hasVariableNumberOfArguments() && methodCallParameterNumber >= methodDefinitionParameterNumber;
    }

    private static boolean areInSameTopLevelClass(MethodDescription methodDefinition, MethodDescription methodCall) {
        return Objects.equals(CLikeAvoidUnusedPrivateMethodsCheckBase.getNameOfOutermostSurroundingDefinition(methodDefinition.getEntity()), CLikeAvoidUnusedPrivateMethodsCheckBase.getNameOfOutermostSurroundingDefinition(methodCall.getEntity()));
    }

    private static String getNameOfOutermostSurroundingDefinition(ShallowEntity startEntity) {
        ShallowEntity topLevelClass = (ShallowEntity)CollectionUtils.getLast((List)ShallowEntityTraversalUtils.findMatchingParentEntities((ShallowEntity)startEntity, entity -> entity.getType() == EShallowEntityType.TYPE && OUTERMOST_DEFINITION_TYPES.contains(entity.getSubtype())));
        if (topLevelClass == null) {
            return "<top-level>";
        }
        return topLevelClass.getName();
    }

    private void loadFilteredEntities() throws CheckException {
        ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
        Predicate<ShallowEntity> isNameNotNull = entity -> entity.getName() != null;
        Predicate<ShallowEntity> isLocalVariable = entity -> "local variable".equals(entity.getSubtype());
        allLocalVariableEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)rootEntity.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT).stream().filter(isNameNotNull).filter(isLocalVariable).collect(Collectors.toList());
        allTypeEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)rootEntity.getChildren(), (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(isNameNotNull).collect(Collectors.toList());
    }

    protected List<MethodDescription> extractMethodDefinitions(List<ShallowEntity> entities) {
        ArrayList<MethodDescription> methodDefinitions = new ArrayList<MethodDescription>();
        for (ShallowEntity methodEntity : entities) {
            Optional parentEntity = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)methodEntity, (Predicate)EntitySelectionPredicates.type());
            String className = parentEntity.map(ShallowEntity::getName).orElse("");
            Pair<Integer, Boolean> parameterNumberWithOptionalParameter = this.getNumberOfParametersForMethodDefinition(methodEntity);
            int numberOfParameters = (Integer)parameterNumberWithOptionalParameter.getFirst();
            boolean hasVarargs = (Boolean)parameterNumberWithOptionalParameter.getSecond();
            methodDefinitions.add(new MethodDescription(methodEntity.getName(), className, numberOfParameters, hasVarargs, methodEntity));
        }
        return methodDefinitions;
    }

    protected List<ShallowEntity> getUnfilteredStatementAndAttributeEntities() throws CheckException {
        UnmodifiableList unfilteredPreprocessedEntities = this.context.getRootEntity(this.getCodeViewOption()).getChildren();
        return ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)unfilteredPreprocessedEntities, EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
    }

    protected List<MethodDescription> extractMethodCallsFromEntity(ShallowEntity entity, List<IToken> tokens) {
        ArrayList<MethodDescription> methodCalls = new ArrayList<MethodDescription>();
        List methodCallIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
        HashSet<Integer> checkedMethodCallIndices = new HashSet<Integer>();
        Iterator iterator = methodCallIndices.iterator();
        while (iterator.hasNext()) {
            int methodCallIndex = (Integer)iterator.next();
            String className = CLikeAvoidUnusedPrivateMethodsCheckBase.getClassName(entity, tokens, methodCallIndex);
            List<Integer> methodCallChainIndices = CLikeAvoidUnusedPrivateMethodsCheckBase.extractMethodCallsChainFromTokens(tokens, methodCallIndex, new ArrayList<Integer>());
            for (int methodCallChainIndex : methodCallChainIndices) {
                if (checkedMethodCallIndices.contains(methodCallChainIndex)) continue;
                checkedMethodCallIndices.add(methodCallChainIndex);
                String methodName = tokens.get(methodCallChainIndex).getText();
                int numberOfParameters = CLikeAvoidUnusedPrivateMethodsCheckBase.getNumberOfParametersForMethodCall(tokens, methodCallChainIndex);
                methodCalls.add(new MethodDescription(methodName, className, numberOfParameters, this.hasVariableLengthArgumentList(tokens, methodCallChainIndex), entity));
            }
        }
        return methodCalls;
    }

    private static List<Integer> extractMethodCallsChainFromTokens(List<IToken> tokens, int startIndex, List<Integer> methodCallChains) {
        int openingParenthesisIndex;
        int closingParenthesisIndex;
        int nextTokenIndex;
        int previousTokenIndex = startIndex - 1;
        if (previousTokenIndex < 0 || tokens.get(previousTokenIndex).getType() != ETokenType.NEW) {
            methodCallChains.add(startIndex);
        }
        if (startIndex < tokens.size() && (nextTokenIndex = (closingParenthesisIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)((openingParenthesisIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)startIndex, (ITokenMatcher)ETokenType.LPAREN)) + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) + 1) < tokens.size() && tokens.get(nextTokenIndex).getType() == ETokenType.DOT) {
            return CLikeAvoidUnusedPrivateMethodsCheckBase.extractMethodCallsChainFromTokens(tokens, nextTokenIndex + 1, methodCallChains);
        }
        return methodCallChains;
    }

    protected static String getClassName(ShallowEntity entity, List<IToken> tokens, int methodCallIndex) {
        ShallowEntity parentEntity = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, (Predicate)EntitySelectionPredicates.type()).orElse(null);
        if (parentEntity == null || CLikeAvoidUnusedPrivateMethodsCheckBase.isDefinedInLambdaFunction(entity)) {
            return "";
        }
        if (methodCallIndex == 0) {
            return parentEntity.getName();
        }
        IToken previousToken = tokens.get(methodCallIndex - 1);
        if (previousToken.getType() == ETokenType.DOT) {
            previousToken = tokens.get(methodCallIndex - 2);
            String tokenName = previousToken.getText();
            Optional<ShallowEntity> statementEntity = allLocalVariableEntities.stream().filter(e -> e.getName() != null && e.getName().equalsIgnoreCase(tokenName)).findFirst();
            if (statementEntity.isPresent()) {
                return CLikeAvoidUnusedPrivateMethodsCheckBase.getClassNameOfVariable(statementEntity.get());
            }
            Optional<ShallowEntity> classEntity = allTypeEntities.stream().filter(e -> e.getName() != null && e.getName().equalsIgnoreCase(tokenName)).findFirst();
            if (classEntity.isPresent()) {
                return classEntity.get().getName();
            }
        } else if (previousToken.getType() == ETokenType.NEW) {
            return tokens.get(methodCallIndex).getText();
        }
        return parentEntity.getName();
    }

    private static String getClassNameOfVariable(ShallowEntity statementEntity) {
        UnmodifiableList statementTokens = statementEntity.includedTokens();
        String variableType = ((IToken)statementTokens.get(0)).getText();
        if (variableType.equals(FINAL)) {
            return ((IToken)statementTokens.get(1)).getText();
        }
        return variableType;
    }

    private static boolean isDefinedInLambdaFunction(ShallowEntity entity) {
        Optional lambdaMethod = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parentEntity -> parentEntity.getType() == EShallowEntityType.METHOD && "lambda".equals(parentEntity.getSubtype()));
        return lambdaMethod.isPresent();
    }

    protected static int getNumberOfParametersForMethodCall(List<IToken> tokens, int startIndex) {
        List<IToken> parameterTokens = CLikeAvoidUnusedPrivateMethodsCheckBase.getMethodParameters(tokens, startIndex);
        if (!parameterTokens.isEmpty()) {
            parameterTokens = CLikeAvoidUnusedPrivateMethodsCheckBase.sanitizeUnbalancedLessThanAndGreaterThanTokens(parameterTokens);
            return TokenStreamUtils.splitWithNesting(parameterTokens, (ETokenType)ETokenType.COMMA, OPENING_TOKEN_TYPES, CLOSING_TOKEN_TYPES).size();
        }
        return 0;
    }

    private static List<IToken> sanitizeUnbalancedLessThanAndGreaterThanTokens(List<IToken> parameterTokens) {
        ArrayList<IToken> result = new ArrayList<IToken>(parameterTokens);
        Stack<Integer> ltIndices = new Stack<Integer>();
        Stack<Integer> gtIndices = new Stack<Integer>();
        for (int i = 0; i < parameterTokens.size(); ++i) {
            ETokenType tokenType = parameterTokens.get(i).getType();
            if (tokenType == ETokenType.LT) {
                ltIndices.push(i);
                continue;
            }
            if (tokenType != ETokenType.GT) continue;
            if (!ltIndices.isEmpty()) {
                ltIndices.pop();
                continue;
            }
            gtIndices.push(i);
        }
        CLikeAvoidUnusedPrivateMethodsCheckBase.replaceTokensWithEqEq(result, ltIndices);
        CLikeAvoidUnusedPrivateMethodsCheckBase.replaceTokensWithEqEq(result, gtIndices);
        return result;
    }

    private static void replaceTokensWithEqEq(List<IToken> result, Stack<Integer> ltIndices) {
        Iterator iterator = ltIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IToken token = result.get(index);
            result.set(index, token.newToken(ETokenType.EQEQ, token.getOffset(), token.getLineNumber(), token.getText(), token.getOriginId()));
        }
    }

    private Pair<Integer, Boolean> getNumberOfParametersForMethodDefinition(ShallowEntity entity) {
        List parameterTokens = this.languageFeatureParser.getSplitParameterTokens(entity);
        int numberOfParameters = parameterTokens.size();
        boolean hasOptionalParameter = false;
        for (List parameter : parameterTokens) {
            if (!this.languageFeatureParser.containsVariableLengthArgumentListIndicator(parameter)) continue;
            --numberOfParameters;
            hasOptionalParameter = true;
        }
        return new Pair((Object)numberOfParameters, (Object)hasOptionalParameter);
    }

    protected boolean hasVariableLengthArgumentList(List<IToken> tokens, int startIndex) {
        List<IToken> parameterTokens = CLikeAvoidUnusedPrivateMethodsCheckBase.getMethodParameters(tokens, startIndex);
        return this.languageFeatureParser.containsVariableLengthArgumentListIndicator(parameterTokens);
    }

    private static List<IToken> getMethodParameters(List<IToken> tokens, int index) {
        return TokenStreamUtils.tokensBetweenWithNesting(tokens, (int)index, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
    }

    protected abstract List<MethodDescription> getMethodDefinitionsToCheck() throws CheckException;

    protected abstract List<MethodDescription> getMethodCalls() throws CheckException;

    protected static class MethodDescription {
        private final String className;
        private final String name;
        private final int numberOfParameters;
        private final ShallowEntity entity;
        private final boolean variableNumberOfArguments;

        public MethodDescription(String name, String className, int numberOfParameters, boolean variableNumberOfArguments, ShallowEntity entity) {
            this.name = Objects.requireNonNull(name);
            this.className = className;
            this.numberOfParameters = numberOfParameters;
            this.variableNumberOfArguments = variableNumberOfArguments;
            this.entity = entity;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public int getNumberOfParameters() {
            return this.numberOfParameters;
        }

        private ShallowEntity getEntity() {
            return this.entity;
        }

        private boolean hasVariableNumberOfArguments() {
            return this.variableNumberOfArguments;
        }

        public String toString() {
            return "Method `" + this.name + "` with " + this.numberOfParameters + " parameters defined/called in `" + this.className + "` class";
        }

        private boolean isInAnonymousClass() {
            return this.getClassName().equals("");
        }

        private boolean hasSameClassName(MethodDescription method) {
            return method.getClassName().equals(this.className);
        }
    }
}

