/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.clike;

import eu.cqse.check.cloud_smells.UnwantedExpressionBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-avoid-hard-coded-ip-address", languages={ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HardCodedIPAddressUsageCheck
extends UnwantedExpressionBase {
    protected static final String CHECK_NAME = "Hard Coded IP Address";
    @CheckOption(name="Hard Coded IP Address - Allowed IP addresses", description="Using the IP addresses specified here is allowed. Separated by commas.")
    private Set<String> allowedIPAddresses = new HashSet<String>();

    @Override
    protected @NonNull EnumSet<EShallowEntityType> getTargetTypes() {
        return EnumSet.of(EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT);
    }

    @Override
    protected boolean shouldIgnore(MatchResult matchResult) {
        return this.allowedIPAddresses.contains(matchResult.group(0));
    }

    @Override
    protected Pattern getUnwantedRegex() {
        return Pattern.compile("[\"'\\s](?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\"'\\s]");
    }

    @Override
    protected String getFindingText(ShallowEntity entity, MatchResult matchResult) {
        return CHECK_NAME;
    }
}

