/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;

@Check(id="cqse-inline-functions-static", languages={ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class InlineFunctionsStaticCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity topLevelEntity : topLevelEntities) {
            if (topLevelEntity.getType() != EShallowEntityType.METHOD) continue;
            this.processEntity(topLevelEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        boolean staticModifier = TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.STATIC);
        boolean inlineModifier = TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.INLINE);
        if (inlineModifier && !staticModifier) {
            this.buildFinding("`" + entity.getName() + "` is declared inline, but not static", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

