/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.clike.CLikeAvoidUnusedPrivateMethodsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Check(id="cqse-avoid-unused-private-methods", languages={ELanguage.JAVA, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidUnusedPrivateMethodsCheck
extends CLikeAvoidUnusedPrivateMethodsCheckBase {
    private static final SetMap<String, Integer> EXCLUDED_METHODS = new SetMap();
    private static final Set<String> EXCLUDED_ANNOTATIONS_FULL_QUALIFIED_CLASSES = CollectionUtils.asHashSet((Object[])new String[]{"javax.annotations.PostConstruct", "javax.annotations.PreDestroy", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.BeforeAll", "org.junit.Before", "org.junit.BeforeClass", "org.junit.jupiter.params.provider.MethodSource", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.After", "org.junit.AfterClass"});
    private static final Set<String> JAVA_PERSISTENCE_API_CLASSES = Set.of("PostLoad", "PostPersist", "PostRemove", "PostUpdate", "PrePersist", "PreRemove", "PreUpdate");
    private static final String CHECK_OPTION_NAME = "Java annotations for unused private methods";
    private static final String CHECK_OPTION_DESCRIPTION = "A list of annotations that prevents methods from being reported as unused. The annotation used in code needs to match verbatim, so specifying the class name will not prevent findings if the fully qualified class is used in code (and vice versa).";
    private static final Set<String> EXCLUDED_ANNOTATIONS = new HashSet<String>();
    private static final String JUNIT_PARAMS_RUNNER = "JUnitParamsRunner";
    private static final String RUN_WITH_ANNOTATION = "RunWith";
    private static final String JUNIT_PARAMS_RUNNER_REFERENCE = "parametersFor";
    private static final String PARAMETERS_ANNOTATION = "Parameters";
    @CheckOption(name="Java annotations for unused private methods", description="A list of annotations that prevents methods from being reported as unused. The annotation used in code needs to match verbatim, so specifying the class name will not prevent findings if the fully qualified class is used in code (and vice versa).")
    private Set<String> annotations = new HashSet<String>(EXCLUDED_ANNOTATIONS);

    public AvoidUnusedPrivateMethodsCheck() {
        super((CLikeLanguageFeatureParserBase)LanguageFeatureParser.JAVA);
    }

    @Override
    protected List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> getMethodCalls() throws CheckException {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (ShallowEntity methodCallEntity : this.getUnfilteredStatementAndAttributeEntities()) {
            methodCalls.addAll(this.extractMethodCallsFromEntity(methodCallEntity, (List<IToken>)methodCallEntity.includedTokens()));
            methodCalls.addAll(AvoidUnusedPrivateMethodsCheck.extractXTendMethodCalls(methodCallEntity));
            methodCalls.addAll(this.extractMethodCallsFromMethodReferences(methodCallEntity));
        }
        methodCalls.addAll(this.extractJUnitParamsRunnerMethodReferences());
        methodCalls.addAll(this.extractStringLiteralsFromAnnotations());
        return methodCalls;
    }

    @Override
    protected List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> getMethodDefinitionsToCheck() throws CheckException {
        List methodDefinitions = this.select("//TYPE/METHOD[not(subtype('constructor')) and modifiers('private')]");
        return CollectionUtils.filter(this.extractMethodDefinitions(CollectionUtils.filter((Collection)methodDefinitions, this::isMethodIncluded)), definition -> !EXCLUDED_METHODS.contains((Object)definition.getName(), (Object)definition.getNumberOfParameters()));
    }

    private boolean isMethodIncluded(ShallowEntity entity) {
        return LanguageFeatureParser.JAVA.getAnnotations(entity).stream().map(ShallowEntity::getName).noneMatch(this.annotations::contains);
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractMethodCallsFromMethodReferences(ShallowEntity entity) {
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        UnmodifiableList tokens = entity.includedTokens();
        List methodReferenceIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DOUBLE_COLON, ETokenType.IDENTIFIER});
        Iterator iterator = methodReferenceIndices.iterator();
        while (iterator.hasNext()) {
            int methodReferenceIndex = (Integer)iterator.next();
            String className = AvoidUnusedPrivateMethodsCheck.getClassName(entity, (List<IToken>)tokens, methodReferenceIndex);
            String methodName = ((IToken)tokens.get(methodReferenceIndex + 1)).getText();
            methodCalls.add(new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(methodName, className, -1, this.hasVariableLengthArgumentList((List<IToken>)tokens, methodReferenceIndex), entity));
        }
        return methodCalls;
    }

    private static List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractXTendMethodCalls(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (TokenStreamUtils.getLanguage((Collection)tokens) != ELanguage.XTEND) {
            return Collections.emptyList();
        }
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodCalls = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        String className = AvoidUnusedPrivateMethodsCheck.getClassName(entity, (List<IToken>)tokens, 0);
        List<IToken> identifierTokens = tokens.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).toList();
        for (IToken identifierToken : identifierTokens) {
            String methodName = identifierToken.getText();
            methodCalls.add(new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(methodName, className, -1, false, entity));
        }
        return methodCalls;
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractJUnitParamsRunnerMethodReferences() throws CheckException {
        List classEntities = ShallowEntityTraversalUtils.listEntitiesOfType(this.getAbstractSyntaxTree(), (EShallowEntityType)EShallowEntityType.TYPE);
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> methodReferences = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (ShallowEntity classEntity : classEntities) {
            if (!AvoidUnusedPrivateMethodsCheck.hasJUnitParamsRunnerAnnotation(classEntity)) continue;
            List methodEntities = classEntity.getChildrenOfType(EShallowEntityType.METHOD);
            for (ShallowEntity methodEntity : methodEntities) {
                Optional<ShallowEntity> methodReference;
                Optional<ShallowEntity> parametersAnnotation = LanguageFeatureParser.JAVA.getAnnotations(methodEntity).stream().filter(entity -> PARAMETERS_ANNOTATION.equals(entity.getName())).findFirst();
                if (parametersAnnotation.isEmpty() || (methodReference = AvoidUnusedPrivateMethodsCheck.getJUnitParamsRunnerMethodReference(parametersAnnotation.get(), methodEntity, methodEntities)).isEmpty()) continue;
                String methodName = methodReference.get().getName();
                String className = AvoidUnusedPrivateMethodsCheck.getClassName(methodEntity, (List<IToken>)methodReference.get().includedTokens(), 0);
                int numberOfParameters = AvoidUnusedPrivateMethodsCheck.getNumberOfParametersForMethodCall((List<IToken>)methodReference.get().includedTokens(), 0);
                methodReferences.add(new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(methodName, className, numberOfParameters, this.hasVariableLengthArgumentList((List<IToken>)methodReference.get().includedTokens(), 0), methodEntity));
            }
        }
        return methodReferences;
    }

    private static Optional<ShallowEntity> getJUnitParamsRunnerMethodReference(ShallowEntity parametersAnnotation, ShallowEntity methodEntity, List<ShallowEntity> methodEntities) {
        Optional<ShallowEntity> methodReference = Optional.empty();
        List annotationParameters = TokenStreamUtils.tokensBetweenWithNesting((List)parametersAnnotation.includedTokens(), (int)0, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (annotationParameters.isEmpty()) {
            String searchingMethodName = JUNIT_PARAMS_RUNNER_REFERENCE + methodEntity.getName();
            methodReference = methodEntities.stream().filter(entity -> searchingMethodName.equalsIgnoreCase(entity.getName())).findFirst();
        } else if (annotationParameters.size() == 3) {
            String searchingMethodName = StringUtils.removeDoubleQuotes((String)((IToken)annotationParameters.getLast()).getText());
            methodReference = methodEntities.stream().filter(entity -> searchingMethodName.equals(entity.getName())).findFirst();
        }
        return methodReference;
    }

    private static boolean hasJUnitParamsRunnerAnnotation(ShallowEntity entity) {
        Optional<ShallowEntity> runWithAnnotation = LanguageFeatureParser.JAVA.getAnnotations(entity).stream().filter(annotation -> RUN_WITH_ANNOTATION.equals(annotation.getName())).findFirst();
        if (runWithAnnotation.isEmpty()) {
            return false;
        }
        List runWithAnnotationParameters = TokenStreamUtils.tokensBetweenWithNesting((List)runWithAnnotation.get().includedTokens(), (int)0, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        return runWithAnnotationParameters.stream().anyMatch(annotationParameter -> annotationParameter.getText().equals(JUNIT_PARAMS_RUNNER));
    }

    private List<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> extractStringLiteralsFromAnnotations() throws CheckException {
        List annotations = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(this.getAbstractSyntaxTree(), EnumSet.of(EShallowEntityType.META), Set.of("annotation"));
        ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription> result = new ArrayList<CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription>();
        for (ShallowEntity annotation : annotations) {
            for (IToken token : annotation.ownStartTokens()) {
                if (token.getType() != ETokenType.STRING_LITERAL) continue;
                String text = token.getText().replaceAll("\"", "");
                Optional.ofNullable(AvoidUnusedPrivateMethodsCheck.extractMethodeDescriptionFromStringLiterals(text, annotation)).ifPresent(result::add);
            }
        }
        return result;
    }

    private static @Nullable CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription extractMethodeDescriptionFromStringLiterals(String text, ShallowEntity annotation) {
        int numberOfParameters;
        String methodeName;
        if (text.contains("(") && text.contains(")")) {
            int idxMethodNameEnd;
            int idxMethodNameStart = text.contains("#") ? text.indexOf("#") + 1 : 0;
            if (idxMethodNameStart >= (idxMethodNameEnd = text.indexOf("("))) {
                return null;
            }
            methodeName = text.substring(idxMethodNameStart, idxMethodNameEnd);
            numberOfParameters = text.indexOf(")") - text.indexOf("(") == 1 ? 0 : StringUtils.countCharacter((String)text.substring(text.indexOf("(") + 1, text.indexOf(")")), (char)',') + 1;
        } else if (text.contains("#")) {
            methodeName = text.substring(text.indexOf("#") + 1);
            numberOfParameters = -1;
        } else {
            methodeName = text;
            numberOfParameters = -1;
        }
        if (!methodeName.contains(" ")) {
            return new CLikeAvoidUnusedPrivateMethodsCheckBase.MethodDescription(methodeName, "", numberOfParameters, false, annotation);
        }
        return null;
    }

    static {
        EXCLUDED_METHODS.add((Object)"readObject", (Object)1);
        EXCLUDED_METHODS.add((Object)"writeObject", (Object)1);
        EXCLUDED_METHODS.add((Object)"readObjectNoData", (Object)0);
        EXCLUDED_METHODS.add((Object)"writeReplace", (Object)0);
        EXCLUDED_METHODS.add((Object)"readResolve", (Object)0);
        for (String clazz : JAVA_PERSISTENCE_API_CLASSES) {
            EXCLUDED_ANNOTATIONS_FULL_QUALIFIED_CLASSES.add("javax.persistence." + clazz);
            EXCLUDED_ANNOTATIONS_FULL_QUALIFIED_CLASSES.add("jakarta.persistence." + clazz);
        }
        for (String className : EXCLUDED_ANNOTATIONS_FULL_QUALIFIED_CLASSES) {
            EXCLUDED_ANNOTATIONS.add(className);
            EXCLUDED_ANNOTATIONS.add(StringUtils.getLastPart((String)className, (char)'.'));
        }
    }
}

