/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import java.util.List;

@Check(id="cqse-constructor-call-without-encoding", languages={ELanguage.JAVA}, parameters={ECheckParameter.TYPE_RESOLUTION, ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ConstructorCallWithoutEncodingCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher STRING_CONSTRUCTOR_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"String", "java.lang.String"}).constructors().withParameterMinCount(1);
    private static final JavaMethodCallMatcher STREAM_CONSTRUCTOR_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"java.io.InputStreamReader", "java.io.OutputStreamWriter"}).constructors().withParameterMinCount(1);
    private static final JavaMethodCallMatcher FILE_READER_CONSTRUCTOR_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"java.io.FileReader"}).constructors().withParameterCount(1);

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall stringConstructor : STRING_CONSTRUCTOR_MATCHER.find(this.context, typeResolver)) {
            ScopedTypeLookup typeLookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(stringConstructor.entity());
            this.stringCheck(typeLookup, stringConstructor.token(), stringConstructor.parameters());
        }
        for (JavaMethodCallMatcher.MethodCall streamConstructor : STREAM_CONSTRUCTOR_MATCHER.find(this.context, typeResolver)) {
            this.ioStreamReaderWriterCheck(streamConstructor.token(), streamConstructor.parameters());
        }
        for (JavaMethodCallMatcher.MethodCall fileReaderConstructor : FILE_READER_CONSTRUCTOR_MATCHER.find(this.context, typeResolver)) {
            this.createFinding(fileReaderConstructor.token());
        }
    }

    private void stringCheck(ScopedTypeLookup tokenTypeLookup, IToken constructorNameToken, List<List<IToken>> constructorArguments) {
        int numberOfParameters = constructorArguments.size();
        if (numberOfParameters == 0) {
            return;
        }
        if (ConstructorCallWithoutEncodingCheck.isParameterByteArray(tokenTypeLookup, constructorArguments.getFirst())) {
            List<IToken> lastParameter;
            if (numberOfParameters == 1 || numberOfParameters == 3) {
                this.createFinding(constructorNameToken);
            } else if ((numberOfParameters == 2 || numberOfParameters == 4) && ConstructorCallWithoutEncodingCheck.parameterIsNotCharsetOrString(tokenTypeLookup, lastParameter = constructorArguments.getLast())) {
                this.createFinding(constructorNameToken);
            }
        }
    }

    private void ioStreamReaderWriterCheck(IToken constructorNameToken, List<List<IToken>> constructorArguments) {
        int numberOfParameters = constructorArguments.size();
        if (numberOfParameters == 1) {
            this.createFinding(constructorNameToken);
        }
    }

    private static boolean parameterIsNotCharsetOrString(ScopedTypeLookup tokenTypeLookup, List<IToken> parameterTokens) {
        if (parameterTokens.size() == 1) {
            IToken parameterToken = parameterTokens.getFirst();
            ETokenType parameterTokenType = parameterToken.getType();
            if (parameterTokenType == ETokenType.IDENTIFIER) {
                return ConstructorCallWithoutEncodingCheck.identifierTypeNotStringOrCharset(parameterToken, tokenTypeLookup);
            }
            return parameterTokenType != ETokenType.STRING_LITERAL;
        }
        if (TokenStreamUtils.endsWith(parameterTokens, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER})) {
            return ConstructorCallWithoutEncodingCheck.identifierTypeNotStringOrCharset(parameterTokens.getLast(), tokenTypeLookup);
        }
        return false;
    }

    private static boolean identifierTypeNotStringOrCharset(IToken identifier, ScopedTypeLookup tokenTypeLookup) {
        TypedVariable typeInfo = tokenTypeLookup.getTypeInfo(identifier.getText());
        if (typeInfo != null) {
            String typeName = typeInfo.getTypeNameWithoutGenericTypeParameter();
            return !typeName.equals("String") && !typeName.equals("Charset");
        }
        return false;
    }

    private static boolean isParameterByteArray(ScopedTypeLookup tokenTypeLookup, List<IToken> parameterTokens) {
        TypedVariable typeInfo;
        if (parameterTokens.size() == 1 && parameterTokens.getFirst().getType() == ETokenType.IDENTIFIER && (typeInfo = tokenTypeLookup.getTypeInfo(parameterTokens.getFirst().getText())) != null && typeInfo.getTypeNameWithoutGenericTypeParameter().equals("byte[]")) {
            return true;
        }
        if (parameterTokens.size() > 4) {
            int lastIndex = parameterTokens.size() - 1;
            if (ConstructorCallWithoutEncodingCheck.endsWithMethodCall(parameterTokens, lastIndex, "getBytes") || ConstructorCallWithoutEncodingCheck.endsWithMethodCall(parameterTokens, lastIndex, "toByteArray")) {
                return true;
            }
            if (parameterTokens.size() >= 6) {
                return ConstructorCallWithoutEncodingCheck.isCastToByteArray(parameterTokens) || ConstructorCallWithoutEncodingCheck.isByteArrayConstruction(parameterTokens) && parameterTokens.get(lastIndex).getType() == ETokenType.RBRACE;
            }
        }
        return false;
    }

    private static boolean endsWithMethodCall(List<IToken> parameterTokens, int lastIndex, String methodName) {
        return TokenStreamTextUtils.hasSequence(parameterTokens, (int)(lastIndex - 3), (String[])new String[]{".", methodName, "(", ")"});
    }

    private static boolean isByteArrayConstruction(List<IToken> parameterTokens) {
        return TokenStreamTextUtils.hasSequence(parameterTokens, (int)0, (String[])new String[]{"new", "byte", "[", "]", "{"});
    }

    private static boolean isCastToByteArray(List<IToken> parameterTokens) {
        return TokenStreamTextUtils.hasSequence(parameterTokens, (int)0, (String[])new String[]{"(", "byte", "[", "]", ")"});
    }

    private void createFinding(IToken constructorNameToken) {
        this.buildFinding("Transformation of byte sequence into `String` uses platform encoding", this.buildLocation().forToken(constructorNameToken)).createAndStore();
    }
}

