/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.JavaClassInformationExtractorPhase;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="java:S1161", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={JavaClassInformationExtractorPhase.class})
public class OverrideAnnotationCheck
extends CheckImplementationBase {
    private JavaImportSensitiveTypeResolver typeResolver;

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        this.check(this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
    }

    private void check(List<ShallowEntity> children) {
        for (ShallowEntity entity : children) {
            this.handleType(entity);
            this.check((List<ShallowEntity>)entity.getChildren());
        }
    }

    private void handleType(ShallowEntity entity) {
        if (EShallowEntityType.TYPE != entity.getType()) {
            return;
        }
        if (entity.getSubtype().equals("anonymous class")) {
            Set possibleFullyQualifiedTypeNames = LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(this.typeResolver, entity, Objects.requireNonNull(entity.getName()));
            possibleFullyQualifiedTypeNames.forEach(possibleQualifiedTypeName -> entity.getChildrenOfType(EShallowEntityType.METHOD).forEach(methodEntity -> this.checkMethod(entity, (String)possibleQualifiedTypeName, (ShallowEntity)methodEntity)));
            return;
        }
        String fullyQualifiedTypeName = LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(entity);
        List phaseResult = (List)this.context.accessPhaseInvertedResult(JavaClassInformationExtractorPhase.class).apply(fullyQualifiedTypeName);
        phaseResult.stream().flatMap(result -> Stream.concat(result.getAdditionalInformation().possibleSuperclasses().stream(), result.getAdditionalInformation().possibleSuperinterfaces().stream().flatMap(Collection::stream))).forEach(possibleSupertype -> entity.getChildrenOfType(EShallowEntityType.METHOD).forEach(methodEntity -> this.checkMethod(entity, (String)possibleSupertype, (ShallowEntity)methodEntity)));
    }

    private void checkMethod(ShallowEntity entity, String possibleSupertype, ShallowEntity methodEntity) {
        if (LanguageFeatureParser.JAVA.hasAnnotation(methodEntity, new String[]{"Override", "java.lang.Override"})) {
            return;
        }
        JavaClassInformationExtractorPhase.MethodInformation methodInformation = new JavaClassInformationExtractorPhase.MethodInformation(methodEntity.getName(), LanguageFeatureParser.JAVA.getParameterTypeNames(methodEntity).stream().flatMap(Optional::stream).toList());
        if (this.findMethod(possibleSupertype, methodInformation)) {
            this.buildFinding(String.format("Method %s misses `@Override` annotation", MarkupUtils.formatAsSourceCode((String)(entity.getName() + "." + methodEntity.getName()))), this.buildLocation().forEntity(methodEntity)).createAndStore();
        }
    }

    private boolean findMethod(String className, JavaClassInformationExtractorPhase.MethodInformation methodInformation) {
        List phaseResult = (List)this.context.accessPhaseInvertedResult(JavaClassInformationExtractorPhase.class).apply(className);
        for (JavaClassInformationExtractorPhase.MethodInformation superclassMethod : phaseResult.stream().flatMap(s -> s.getAdditionalInformation().methods().stream()).toList()) {
            if (!superclassMethod.equals(methodInformation)) continue;
            return true;
        }
        return phaseResult.stream().flatMap(c -> Stream.concat(c.getAdditionalInformation().possibleSuperclasses().stream(), c.getAdditionalInformation().possibleSuperinterfaces().stream().flatMap(Collection::stream))).distinct().anyMatch(possibleSuperType -> this.findMethod((String)possibleSuperType, methodInformation));
    }
}

