/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import com.google.common.collect.Streams;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-document-parallel-stream-usage", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DocumentParallelStreamUsage
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Document usage of parallel stream";
    private static final int METHOD_CALL_GROUP = 0;
    private static final TokenPattern METHOD_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.DOT}).alternative(new Object[]{TokenPattern.text((String)"parallel"), TokenPattern.text((String)"parallelStream")}).group(0).sequence(new Object[]{ETokenType.LPAREN, ETokenType.RPAREN});
    @CheckOption(name="Comments documenting parallel stream usage", description="If the regular expression matches the comment then it is considered as documenting the usage of parallel streams.")
    private String usageCommentsRegex = "parallel|performance";
    private Pattern usageCommentsPattern;

    public void initialize() throws CheckException {
        super.initialize();
        this.usageCommentsPattern = Pattern.compile(this.usageCommentsRegex, 32);
    }

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity statement) throws CheckException {
        if (statement.ownTokens().stream().noneMatch(arg_0 -> ((TokenPattern)METHOD_CALL_PATTERN).matchesAnywhere(arg_0))) {
            return;
        }
        UnmodifiableList statementTokens = statement.includedTokens();
        UnmodifiableList allTokens = this.context.getTokens(this.getCodeViewOption());
        int firstStatementTokenIndex = allTokens.indexOf(statementTokens.get(0));
        int lastStatementTokenIndex = allTokens.indexOf(CollectionUtils.getLast((List)statementTokens));
        Stream<IToken> leadingComments = DocumentParallelStreamUsage.reverseRange(0, firstStatementTokenIndex).mapToObj(((List)allTokens)::get).takeWhile(TokenUtils::isCommentToken);
        Stream<IToken> inStatementComments = IntStream.rangeClosed(firstStatementTokenIndex, lastStatementTokenIndex).mapToObj(((List)allTokens)::get).filter(TokenUtils::isCommentToken);
        Stream<IToken> trailingComments = IntStream.range(lastStatementTokenIndex + 1, allTokens.size()).mapToObj(((List)allTokens)::get).takeWhile(TokenUtils::isCommentToken);
        if (!Streams.concat((Stream[])new Stream[]{leadingComments, inStatementComments, trailingComments}).anyMatch(this::isUsefulComment)) {
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private boolean isUsefulComment(IToken commentToken) {
        String commentContent = LanguageProperties.of((ELanguage)commentToken.getLanguage()).getCommentContent(commentToken.getText());
        return this.usageCommentsPattern.matcher(commentContent).find();
    }

    private static IntStream reverseRange(int endInclusive, int startExclusive) {
        return IntStream.range(endInclusive, startExclusive).map(i -> endInclusive - i + startExclusive - 1);
    }
}

