/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.PythonLanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-do-not-shadow-built-ins", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotShadowBuiltInsCheck
extends CheckImplementationBase {
    @CheckOption(name="Do not shadow built-ins: Allow class and instance members", description="Allow the usage of names that shadow built-ins for methods and attributes of classes and instances")
    private boolean allowForClassAndInstanceMemberNames = true;
    @CheckOption(name="Do not shadow built-ins: Allow shadowing these built-ins", description="Allow the usage of names that shadow any of the built-ins listed here")
    private Set<String> allowedShadowingNames = Collections.emptySet();
    private static final TokenPattern INSTANCE_ATTRIBUTE_ASSIGNMENT = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.EQ});
    private static final TokenPattern FIRST_PARAMETER_IDENTIFIER = new TokenPattern().sequence(new Object[]{ETokenType.DEF, ETokenType.IDENTIFIER, ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);

    public void execute() throws CheckException {
        List syntaxTree = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        this.analyzeNames(syntaxTree);
        this.analyzeDeclaredVariables(syntaxTree);
        this.analyzeInstanceAttributes(syntaxTree);
    }

    private void analyzeNames(List<ShallowEntity> syntaxTree) {
        EnumSet<EShallowEntityType> entityTypes = EnumSet.of(EShallowEntityType.TYPE, EShallowEntityType.METHOD);
        if (!this.allowForClassAndInstanceMemberNames) {
            entityTypes.add(EShallowEntityType.ATTRIBUTE);
        }
        ShallowEntityTraversalUtils.listEntitiesOfTypes(syntaxTree, entityTypes).forEach(this::analyzeName);
    }

    private void analyzeName(ShallowEntity entity) {
        String entityName = entity.getName();
        if (entityName == null || !this.shouldNameGenerateFinding(entityName)) {
            return;
        }
        if (this.allowForClassAndInstanceMemberNames && LanguageFeatureParser.PYTHON.isDefinedOnClass(entity)) {
            return;
        }
        this.buildFinding(DoNotShadowBuiltInsCheck.getMessage(entityName), this.buildLocation().forEntityFirstLine(entity)).createAndStore();
    }

    private void analyzeDeclaredVariables(List<ShallowEntity> entities) {
        ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.STATEMENT)).forEach(this::analyzeDeclaredVariablesInEntity);
    }

    private void analyzeDeclaredVariablesInEntity(ShallowEntity entity) {
        for (IToken parameter : LanguageFeatureParser.PYTHON.getDeclaredVariableNames(entity)) {
            String name = parameter.getText();
            if (!this.shouldNameGenerateFinding(name)) continue;
            this.buildFinding(DoNotShadowBuiltInsCheck.getMessage(name), this.buildLocation().forToken(parameter)).createAndStore();
        }
    }

    private void analyzeInstanceAttributes(List<ShallowEntity> entities) {
        if (!this.allowForClassAndInstanceMemberNames) {
            ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD).stream().filter(arg_0 -> ((PythonLanguageFeatureParser)LanguageFeatureParser.PYTHON).isConstructor(arg_0)).flatMap(constructor -> constructor.getChildren().stream()).forEach(this::analyzeForInstanceAttributeDeclaration);
        }
    }

    private void analyzeForInstanceAttributeDeclaration(ShallowEntity statement) {
        UnmodifiableList startTokens = statement.ownStartTokens();
        if (INSTANCE_ATTRIBUTE_ASSIGNMENT.findFirstMatch((List)startTokens) == null) {
            return;
        }
        ShallowEntity constructor = Objects.requireNonNull(statement.getParent());
        TokenPatternMatch selfMatch = FIRST_PARAMETER_IDENTIFIER.findFirstMatch((List)constructor.ownStartTokens());
        String selfName = ((IToken)Objects.requireNonNull(selfMatch).groupTokens(0).getFirst()).getText();
        if (!((IToken)startTokens.get(0)).getText().equals(selfName)) {
            return;
        }
        IToken nameToken = (IToken)startTokens.get(2);
        String name = nameToken.getText();
        if (this.shouldNameGenerateFinding(name)) {
            this.buildFinding(DoNotShadowBuiltInsCheck.getMessage(name), this.buildLocation().forToken(nameToken)).createAndStore();
        }
    }

    private boolean shouldNameGenerateFinding(String name) {
        if (!LanguageFeatureParser.PYTHON.isBuiltInName(name)) {
            return false;
        }
        return !this.allowedShadowingNames.contains(name);
    }

    private static String getMessage(String name) {
        return String.format("Name %s shadows a built-in", MarkupUtils.formatAsSourceCode((String)name));
    }
}

