/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.naming_conventions.SimulinkNameLengthCheckUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0247", languages={ELanguage.SIMULINK})
public class SimulinkBlockNameLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Minimum length of block names", description="The minimum number of characters for names of blocks.")
    private int minimumLength = 1;
    @CheckOption(name="Maximum length of block names", description="The maximum number of characters for names of blocks.")
    private int maximumLength = 63;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (SimulinkUtils.isInport((SimulinkBlock)block) || SimulinkUtils.isOutport((SimulinkBlock)block) || SimulinkBlockNameLengthCheck.isNonBasicBlock(block)) continue;
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, this.minimumLength, this.maximumLength, block.getName(), "Block", this.buildLocation().forSimulinkBlock(block));
        }
    }

    private static boolean isNonBasicBlock(SimulinkBlock block) {
        return SimulinkUtils.isSubsystem((SimulinkBlock)block) || "Model".equals(block.getType());
    }
}

