/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.na_0011", languages={ELanguage.SIMULINK}, parameters={})
public class SimulinkGotoScopeCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the block visibility to `Local`.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("Goto"), (boolean)false, (boolean)false)) {
            GotoFromResolver.ETagVisibility visibility = GotoFromResolver.extractTagVisibility((SimulinkBlock)block);
            if (visibility == GotoFromResolver.ETagVisibility.LOCAL) continue;
            this.buildFinding("Goto block parameter *tag visibility* shall be set to `Local` but is " + visibility.name(), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

