/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jc_0723", languages={ELanguage.SIMULINK})
public class SimulinkTransitionFromExternalToChildStateCheck
extends CheckImplementationBase {
    private static final String TRANSITION_TO_EXTERNAL_CHILD_FINDING_MESSAGE = "There is a transition from state %s to external child state %s";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider changing the chart to avoid transitions to external child states.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateFlow = (StateflowBlock)block;
            for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)stateFlow.getChart(), (boolean)false)) {
                StateflowNodeBase srcNode = transition.getSrc();
                StateflowNodeBase dstNode = transition.getDst();
                if (!(dstNode instanceof StateflowState) || !(srcNode instanceof StateflowState) || StateflowUtils.isCommented((ParameterizedElement)srcNode) || StateflowUtils.isCommented((ParameterizedElement)dstNode) || SimulinkTransitionFromExternalToChildStateCheck.destinationAncestorIsParentOfSource((IStateflowNodeContainer)dstNode.getParent(), (IStateflowNodeContainer)srcNode.getParent()) || dstNode.getParent() instanceof StateflowChart) continue;
                StateflowState srcState = (StateflowState)srcNode;
                StateflowState dstState = (StateflowState)dstNode;
                this.buildFinding(String.format(TRANSITION_TO_EXTERNAL_CHILD_FINDING_MESSAGE, StateflowUtils.getStateName((StateflowState)srcState), StateflowUtils.getStateName((StateflowState)dstState)), (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private static boolean destinationAncestorIsParentOfSource(IStateflowNodeContainer<?> dstParent, IStateflowNodeContainer<?> srcParent) {
        if (srcParent == null || dstParent == null) {
            return false;
        }
        if (dstParent.equals(srcParent)) {
            return true;
        }
        if (!(dstParent.getParent() instanceof StateflowState) || !(srcParent instanceof StateflowBlock)) {
            return false;
        }
        return SimulinkTransitionFromExternalToChildStateCheck.destinationAncestorIsParentOfSource((IStateflowNodeContainer)dstParent.getParent(), srcParent);
    }
}

