/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.base;

import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.user.UserOptionIndex;
import com.teamscale.core.option.user.UserOptionRegistry;
import com.teamscale.core.options.AdminContactUrlOption;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserSatisfactionStatusIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.index.event_announcement.EventAnnouncement;
import com.teamscale.index.event_announcement.EventAnnouncementIndex;
import com.teamscale.index.user.UserEventAnnouncementPreferencesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dashboard.ParallelProjectInfoLoadingUtils;
import com.teamscale.service.dashboard.PerspectiveContextUtils;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.ui.ETeamscalePerspective;
import com.teamscale.ui.base.PerspectiveContext;
import com.teamscale.ui.base.PerspectiveContextProjectInfos;
import com.teamscale.ui.base.PerspectiveContextTeamscaleInfo;
import com.teamscale.ui.base.PerspectiveContextUserInfo;
import com.teamscale.ui.resources.CustomCssService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/context/perspective")
public class PerspectiveContextService
extends ApiBase {
    @GET
    @RequiresNoPermission
    @Operation(summary="Perspective context", description="Provides basic information about the logged in user, permissions, available projects and the Teamscale instance.")
    public PerspectiveContext getPerspectiveContext() throws StorageException, IOException, ExecutionException, InterruptedException {
        User currentUser = this.serviceInfo.getUser();
        UserUtils.sanitizeUser((User)currentUser);
        boolean shouldPromptUserForFeedback = ((UserSatisfactionStatusIndex)this.serviceInfo.getIndexLayer().openGlobalIndex(UserSatisfactionStatusIndex.class)).shouldPromptUserForFeedback(currentUser.getUsername());
        PerspectiveContextUserInfo userInfo = new PerspectiveContextUserInfo(currentUser, this.getUserOptions(currentUser), this.collectAllowedPerspectives(), this.getPermissions().createPermissionSummary(), this.getEventAnnouncement(currentUser), PerspectiveContextService.canChangePassword(currentUser), shouldPromptUserForFeedback);
        List visibleProjects = this.getPermissions().getVisibleProjects();
        List recentProjects = PerspectiveContextUtils.getRecentProjectsForUser((ITeamscaleServiceInfo)this.serviceInfo, (List)visibleProjects);
        PerspectiveContextProjectInfos perspectiveContextProjectInfos = new PerspectiveContextProjectInfos(visibleProjects, ParallelProjectInfoLoadingUtils.getProjectsState((List)visibleProjects, (IParallelTaskExecutor)this.getParallelTaskExecutor(), (IndexLayer)this.serviceInfo.getIndexLayer()), recentProjects);
        PerspectiveContextTeamscaleInfo teamscaleInfo = new PerspectiveContextTeamscaleInfo(this.getAdminContactUrl(), this.serviceInfo, CustomCssService.getCustomCssUrl(), this.serviceInfo.getAiEngineProvider().listAvailableAiEngines());
        return new PerspectiveContext(userInfo, perspectiveContextProjectInfos, teamscaleInfo);
    }

    private static boolean canChangePassword(User user) {
        String authName = AuthenticationManager.getAuthenticatorName((String)user.getAuthenticator());
        AuthenticationManager authManager = AuthenticationManager.getInstance();
        return authManager.getAuthenticator(authName).allowsPasswordChanges();
    }

    private @Nullable EventAnnouncement getEventAnnouncement(User currentUser) throws StorageException {
        IndexLayer indexLayer = this.serviceInfo.getIndexLayer();
        EventAnnouncementIndex eventPromotionIndex = (EventAnnouncementIndex)indexLayer.openGlobalIndex(EventAnnouncementIndex.class);
        Set hiddenByUser = ((UserEventAnnouncementPreferencesIndex)indexLayer.openGlobalIndex(UserEventAnnouncementPreferencesIndex.class)).getHiddenEventsForUser(currentUser.getUsername());
        return eventPromotionIndex.getCurrentEvents().stream().filter(event -> !hiddenByUser.contains(event.eventId())).findFirst().orElse(null);
    }

    private String getAdminContactUrl() throws StorageException {
        return AdminContactUrlOption.getAdministratorContactInformation((GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
    }

    private Map<String, IOption> getUserOptions(User currentUser) throws StorageException {
        UserOptionIndex userOptionIndex = (UserOptionIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(UserOptionIndex.class);
        return UserOptionRegistry.getInstance().getOptions(currentUser.getUsername(), (OptionIndexBase)userOptionIndex);
    }

    private List<ETeamscalePerspective> collectAllowedPerspectives() throws StorageException {
        return CollectionUtils.filterWithException(Arrays.asList(ETeamscalePerspective.values()), perspective -> perspective.isUserVisible(this.serviceInfo.getPermissions()));
    }
}

